/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.perf.clients.BackToBackLoadGenerator;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;
import org.apache.derbyTesting.perf.clients.SingleRecordSelectClient;

public class BlobAccessTest
extends JDBCPerfTestCase {
    private static final boolean disableSmallBlobs = Boolean.getBoolean("derby.tests.disableSmallBlobs");
    private static final boolean disableLargeBlobs = Boolean.getBoolean("derby.tests.disableLargeBlobs");
    private static final boolean disableConcurrencyTest = Boolean.getBoolean("derby.tests.disableConcurrencyTest");
    private static final int largeBlobSizeMB = Integer.getInteger("derby.tests.largeBlobSize", 15);
    private static final int FETCH_GETBYTES = 0;
    private static final int FETCH_GETBINARYSTREAM = 1;

    public BlobAccessTest(String name, int iterations, int repeats) {
        super(name, iterations, repeats);
    }

    @Override
    public void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        int reps;
        int iters;
        BaseTestSuite mainSuite = new BaseTestSuite("BlobAccessTest suite");
        if (!disableSmallBlobs) {
            iters = 50;
            reps = 3;
            BlobAccessTest.println("Adding small Blob tests.");
            BaseTestSuite smallSuite = new BaseTestSuite("Small Blob suite");
            smallSuite.addTest((Test)new BlobAccessTest("testFetchSmallBlobs", iters, reps));
            smallSuite.addTest((Test)new BlobAccessTest("testFetchSmallBlobsInaccurateLength", iters, reps));
            smallSuite.addTest((Test)new BlobAccessTest("testModifySmallBlobs", iters, reps));
            mainSuite.addTest((Test)smallSuite);
        }
        if (!disableLargeBlobs) {
            iters = 5;
            reps = 3;
            BlobAccessTest.println("Adding large Blob tests.");
            BaseTestSuite largeSuite = new BaseTestSuite("Large Blob suite");
            largeSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobs", iters, reps));
            largeSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobOneByOneByteBaseline", iters, reps));
            largeSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobOneByOneByteModified", iters, reps));
            largeSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobOneByOneByte", iters, reps));
            largeSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlob", iters, reps));
            largeSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobModified", iters, reps));
            largeSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobPieceByPiece", iters, reps));
            largeSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobPieceByPieceModified", iters, reps));
            largeSuite.addTest((Test)new BlobAccessTest("testLargeBlobGetLength", iters, reps));
            mainSuite.addTest((Test)largeSuite);
        }
        if (!disableConcurrencyTest) {
            mainSuite.addTest((Test)new BlobAccessTest("testConcurrency", 1, 1));
        }
        return new CleanDatabaseTestSetup((Test)mainSuite){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                try {
                    BlobAccessTest.initializeBlobData(stmt);
                }
                catch (UnsupportedEncodingException uee) {
                    SQLException sqle = new SQLException();
                    sqle.initCause(uee);
                    throw sqle;
                }
            }
        };
    }

    public void testFetchSmallBlobs() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from smallBlobs");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob Blob2 = rs.getBlob(1);
            int blobLength = rs.getInt(2);
            byte[] byArray = Blob2.getBytes(1L, blobLength);
        }
        rs.close();
    }

    public void testFetchSmallBlobsInaccurateLength() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from smallBlobs");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob Blob2 = rs.getBlob(1);
            int unusedLength = rs.getInt(2);
            byte[] byArray = Blob2.getBytes(1L, 100);
        }
        rs.close();
    }

    public void testModifySmallBlobs() throws SQLException, UnsupportedEncodingException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from smallBlobs");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob Blob2 = rs.getBlob(1);
            int length = rs.getInt(2);
            Blob2.setBytes(length, "X".getBytes("US-ASCII"));
            byte[] byArray = Blob2.getBytes(1L, 100);
        }
        rs.close();
    }

    public void testFetchLargeBlobs() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from largeBlobs");
        ResultSet rs = ps.executeQuery();
        byte[] byteBuf = new byte[16384];
        while (rs.next()) {
            Blob Blob2 = rs.getBlob(1);
            InputStream content = Blob2.getBinaryStream();
            for (long remaining = (long)rs.getInt(2); remaining > 0L; remaining -= (long)content.read(byteBuf)) {
            }
            content.close();
        }
        rs.close();
    }

    public void testFetchLargeBlobOneByOneByteBaseline() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from largeBlobs where id = 4");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob Blob2 = rs.getBlob(1);
            InputStream content = Blob2.getBinaryStream();
            BufferedInputStream bufferedContent = new BufferedInputStream(content);
            long remaining = rs.getInt(2);
            while (bufferedContent.read() != -1) {
                --remaining;
            }
            content.close();
            BlobAccessTest.assertEquals((long)0L, (long)remaining);
        }
        rs.close();
    }

    public void testFetchLargeBlobOneByOneByte() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from largeBlobs where id = 4");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob Blob2 = rs.getBlob(1);
            InputStream content = Blob2.getBinaryStream();
            long remaining = rs.getInt(2);
            while (content.read() != -1) {
                --remaining;
            }
            content.close();
            BlobAccessTest.assertEquals((long)0L, (long)remaining);
        }
        rs.close();
    }

    public void testFetchLargeBlobOneByOneByteModified() throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from largeBlobs where id = 4");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob Blob2 = rs.getBlob(1);
            long remaining = rs.getInt(2);
            Blob2.setBytes(++remaining, "X".getBytes("US-ASCII"));
            InputStream content = Blob2.getBinaryStream();
            while (content.read() != -1) {
                --remaining;
            }
            content.close();
            BlobAccessTest.assertEquals((long)0L, (long)remaining);
        }
        rs.close();
    }

    public void testFetchLargeBlobPieceByPiece() throws IOException, SQLException {
        this.fetchBlobPieceByPiece(false, 0);
    }

    public void testFetchLargeBlobPieceByPieceModified() throws IOException, SQLException {
        this.fetchBlobPieceByPiece(true, 0);
    }

    public void testFetchLargeBlob() throws IOException, SQLException {
        this.fetchBlobPieceByPiece(false, 1);
    }

    public void testFetchLargeBlobModified() throws IOException, SQLException {
        this.fetchBlobPieceByPiece(true, 1);
    }

    private void fetchBlobPieceByPiece(boolean modifyBlob, int fetchMode) throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from largeBlobs where id = 4");
        ResultSet rs = ps.executeQuery();
        block4: while (rs.next()) {
            Blob blob = rs.getBlob(1);
            long remaining = rs.getInt(2);
            if (modifyBlob) {
                long modifyStart = System.currentTimeMillis();
                blob.setBytes(++remaining, new byte[]{88});
                BlobAccessTest.println("Blob modification duration: " + (System.currentTimeMillis() - modifyStart) + " ms");
            }
            long pos = 1L;
            int MAX_SIZE = 32676;
            switch (fetchMode) {
                case 0: {
                    while (remaining > 0L) {
                        byte[] bytes = blob.getBytes(pos, (int)Math.min((long)MAX_SIZE, remaining));
                        pos += (long)bytes.length;
                        remaining -= (long)bytes.length;
                    }
                    continue block4;
                }
                case 1: {
                    InputStream stream = blob.getBinaryStream();
                    byte[] buf = new byte[MAX_SIZE];
                    while (remaining > 0L) {
                        int read = stream.read(buf);
                        pos += (long)read;
                        remaining -= (long)read;
                    }
                    stream.close();
                    continue block4;
                }
            }
            BlobAccessTest.fail((String)("Unknown fetch mode: " + fetchMode));
        }
        rs.close();
    }

    public void testLargeBlobGetLength() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from largeBlobs where id = 7");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob blob = rs.getBlob(1);
            long length = rs.getInt(2);
            for (int i = 0; i < 50; ++i) {
                BlobAccessTest.assertEquals((long)length, (long)blob.length());
            }
        }
        rs.close();
    }

    public void testLargeBlobGetLengthModified() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob, length from largeBlobs where id = 7");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Blob blob = rs.getBlob(1);
            blob.setBytes(1L, new byte[]{88});
            long length = rs.getInt(2);
            for (int i = 0; i < 50; ++i) {
                BlobAccessTest.assertEquals((long)length, (long)blob.length());
            }
        }
        rs.close();
    }

    public void testConcurrency() throws InterruptedException, SQLException {
        int records = 100000;
        boolean tables = true;
        int threads = 16;
        SingleRecordFiller filler = new SingleRecordFiller(100000, 1, 2004, false, false);
        Connection conn = this.getConnection();
        BlobAccessTest.println("initializing database...");
        filler.fill(conn);
        conn.close();
        Client[] clients = new Client[16];
        for (int i = 0; i < clients.length; ++i) {
            Connection c = this.openDefaultConnection();
            c.setTransactionIsolation(2);
            clients[i] = new SingleRecordSelectClient(100000, 1, 2004, false, false);
            clients[i].init(c);
        }
        int warmupSec = 30;
        int steadySec = 60;
        BackToBackLoadGenerator gen = new BackToBackLoadGenerator();
        gen.init(clients);
        BlobAccessTest.println("starting warmup...");
        gen.startWarmup();
        Thread.sleep(30000L);
        BlobAccessTest.println("entering steady state...");
        gen.startSteadyState();
        Thread.sleep(60000L);
        BlobAccessTest.println("stopping threads...");
        gen.stop();
        gen.printReport(System.out);
    }

    private static void initializeBlobData(Statement stmt) throws SQLException, UnsupportedEncodingException {
        Connection con = stmt.getConnection();
        con.setAutoCommit(false);
        if (!disableSmallBlobs) {
            BlobAccessTest.println("Generating small Blobs test data.");
            try {
                stmt.executeUpdate("drop table smallBlobs");
            }
            catch (SQLException sqle) {
                BlobAccessTest.assertSQLState("42Y55", sqle);
            }
            stmt.executeUpdate("create table smallBlobs (dBlob Blob, length int)");
            PreparedStatement smallBlobInsert = con.prepareStatement("insert into smallBlobs values (?,?)");
            for (int BlobCounter = 1; BlobCounter < 15001; ++BlobCounter) {
                byte[] content = Integer.toString(BlobCounter).getBytes("US-ASCII");
                smallBlobInsert.setBytes(1, content);
                smallBlobInsert.setInt(2, content.length);
                smallBlobInsert.executeUpdate();
                if (BlobCounter % 1000 != 0) continue;
                con.commit();
            }
            con.commit();
        }
        if (!disableLargeBlobs) {
            BlobAccessTest.println("Generating large Blobs test data.");
            try {
                stmt.executeUpdate("drop table largeBlobs");
            }
            catch (SQLException sqle) {
                BlobAccessTest.assertSQLState("42Y55", sqle);
            }
            stmt.executeUpdate("create table largeBlobs (id int unique not null, dBlob Blob, length int)");
            PreparedStatement largeBlobInsert = con.prepareStatement("insert into largeBlobs values (?,?,?)");
            int size = largeBlobSizeMB * 1024 * 1024;
            for (int BlobCounter = 1; BlobCounter < 11; ++BlobCounter) {
                largeBlobInsert.setInt(1, BlobCounter);
                largeBlobInsert.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(size), size);
                largeBlobInsert.setInt(3, size);
                largeBlobInsert.executeUpdate();
            }
            con.commit();
        }
    }
}

