/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;

public final class AttributeGetter
extends Expression {
    private final FingerprintedQName attributeName;

    public AttributeGetter(FingerprintedQName attributeName) {
        this.attributeName = attributeName;
    }

    public FingerprintedQName getAttributeName() {
        return this.attributeName;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    @Override
    protected int computeCardinality() {
        return 24576;
    }

    @Override
    protected int computeSpecialProperties() {
        return 0x800000;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public AttributeGetter copy(RebindingMap rebindings) {
        return new AttributeGetter(this.attributeName);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        return pathMapNodeSet.createArc(2, new NameTest(2, this.attributeName, this.getConfiguration().getNamePool()));
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item instanceof TinyElementImpl) {
            String val = ((TinyElementImpl)item).getAttributeValue(this.attributeName.getFingerprint());
            return val == null ? null : StringValue.makeUntypedAtomic(StringView.tidy(val));
        }
        if (item == null) {
            this.dynamicError("The context item for @" + this.attributeName.getDisplayName() + " is absent", "XPDY0002", context);
        }
        if (!(item instanceof NodeInfo)) {
            this.typeError("The context item for @" + this.attributeName.getDisplayName() + " is not a node", "XPDY0002", context);
        }
        assert (item instanceof NodeInfo);
        NodeInfo node = (NodeInfo)item;
        if (node.getNodeKind() == 1) {
            String val = node.getAttributeValue(this.attributeName.getNamespaceUri(), this.attributeName.getLocalPart());
            return val == null ? null : StringValue.makeUntypedAtomic(StringView.tidy(val));
        }
        return null;
    }

    @Override
    public UnicodeString evaluateAsString(XPathContext context) throws XPathException {
        String val;
        Item item = context.getContextItem();
        if (item instanceof TinyElementImpl) {
            String val2 = ((TinyElementImpl)item).getAttributeValue(this.attributeName.getFingerprint());
            return val2 == null ? EmptyUnicodeString.getInstance() : StringView.tidy(val2);
        }
        if (item == null) {
            this.dynamicError("The context item for @" + this.attributeName.getDisplayName() + " is absent", "XPDY0002", context);
        }
        if (!(item instanceof NodeInfo)) {
            this.typeError("The context item for @" + this.attributeName.getDisplayName() + " is not a node", "XPDY0002", context);
        }
        assert (item instanceof NodeInfo);
        NodeInfo node = (NodeInfo)item;
        if (node.getNodeKind() == 1 && (val = node.getAttributeValue(this.attributeName.getNamespaceUri(), this.attributeName.getLocalPart())) != null) {
            return StringView.tidy(val);
        }
        return EmptyUnicodeString.getInstance();
    }

    @Override
    public String getExpressionName() {
        return "attGetter";
    }

    @Override
    public String toShortString() {
        return "@" + this.attributeName.getDisplayName();
    }

    @Override
    public String toString() {
        return "data(@" + this.attributeName.getDisplayName() + ")";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AttributeGetter && ((AttributeGetter)obj).attributeName.equals(this.attributeName);
    }

    @Override
    protected int computeHashCode() {
        return 0x14673 ^ this.attributeName.hashCode();
    }

    @Override
    public void export(ExpressionPresenter out) {
        out.startElement("attVal", this);
        out.emitAttribute("name", this.attributeName.getStructuredQName());
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new AttributeGetterElaborator();
    }

    public static class AttributeGetterElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            AttributeGetter exp = (AttributeGetter)this.getExpression();
            int fingerprint = exp.getAttributeName().getFingerprint();
            NamespaceUri uri = exp.getAttributeName().getNamespaceUri();
            String local = exp.getAttributeName().getLocalPart();
            return context -> {
                String val;
                Item item = context.getContextItem();
                if (item instanceof TinyElementImpl) {
                    String val2 = ((TinyElementImpl)item).getAttributeValue(fingerprint);
                    return val2 == null ? null : new StringValue(val2, (AtomicType)BuiltInAtomicType.UNTYPED_ATOMIC);
                }
                assert (item instanceof NodeInfo);
                NodeInfo node = (NodeInfo)item;
                if (node.getNodeKind() == 1 && (val = node.getAttributeValue(uri, local)) != null) {
                    return new StringValue(val, (AtomicType)BuiltInAtomicType.UNTYPED_ATOMIC);
                }
                return null;
            };
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthWhenAbsent) {
            AttributeGetter expr = (AttributeGetter)this.getExpression();
            int fingerprint = expr.getAttributeName().getFingerprint();
            NamespaceUri uri = expr.getAttributeName().getNamespaceUri();
            String local = expr.getAttributeName().getLocalPart();
            return context -> {
                Item item = context.getContextItem();
                if (item instanceof TinyElementImpl) {
                    String val = ((TinyElementImpl)item).getAttributeValue(fingerprint);
                    return this.handlePossiblyNullString(val, zeroLengthWhenAbsent);
                }
                if (!(item instanceof NodeInfo)) {
                    expr.typeError("The context item for @" + expr.getAttributeName().getDisplayName() + " is not a node", "XPDY0002", context);
                }
                assert (item instanceof NodeInfo);
                NodeInfo node = (NodeInfo)item;
                if (node.getNodeKind() == 1) {
                    String val = node.getAttributeValue(uri, local);
                    return this.handlePossiblyNullString(val, zeroLengthWhenAbsent);
                }
                return zeroLengthWhenAbsent ? "" : null;
            };
        }
    }
}

