/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared;

import java.io.Serializable;
import org.ehcache.spi.persistence.StateHolder;
import org.ehcache.spi.persistence.StateRepository;

public class StateHolderIdGenerator<K extends Serializable> {
    private static final Object DEAD_SENTINEL = new Sentinel();
    volatile int lastUsedId;
    private final StateHolder<K, Integer> forwardMap;
    private final StateHolder<Integer, Serializable> reverseMap;

    public StateHolderIdGenerator(StateRepository repository, Class<K> keyClazz) {
        this.forwardMap = repository.getPersistentStateHolder("forward-map", keyClazz, Integer.class, c -> true, null);
        this.reverseMap = repository.getPersistentStateHolder("reverse-map", Integer.class, Serializable.class, c -> true, null);
    }

    public int map(K key) {
        Integer existing = this.forwardMap.get(key);
        if (existing == null) {
            int candidate = this.lastUsedId + 1;
            while (true) {
                Serializable mappedKey;
                if ((mappedKey = this.reverseMap.putIfAbsent(candidate, (Serializable)key)) == null || mappedKey.equals(key)) {
                    existing = this.forwardMap.putIfAbsent(key, candidate);
                    if (existing == null || existing.equals(candidate)) {
                        this.lastUsedId = candidate;
                        return this.lastUsedId;
                    }
                    this.reverseMap.remove(candidate, (Serializable)key);
                    this.setLastUsedId(existing);
                    return existing;
                }
                ++candidate;
            }
        }
        this.setLastUsedId(existing);
        return existing;
    }

    private synchronized void setLastUsedId(Integer existing) {
        this.lastUsedId = Integer.max(existing, this.lastUsedId);
    }

    public void clear(K key, int id) {
        if (!this.forwardMap.remove(key, id) || !this.reverseMap.remove(id, (Serializable)key)) {
            throw new IllegalStateException();
        }
    }

    public void purge(K alias) {
        int id = this.forwardMap.get(alias);
        this.reverseMap.remove(id, (Serializable)alias);
        this.reverseMap.putIfAbsent(id, (Serializable)DEAD_SENTINEL);
        this.forwardMap.remove(alias, id);
    }

    static final class Sentinel
    implements Serializable {
        private static final long serialVersionUID = 1L;

        Sentinel() {
        }
    }
}

