/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.utils;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.rs.security.httpsignature.exception.SignatureException;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.rs.PrivateKeyPasswordProvider;

public final class KeyManagementUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(KeyManagementUtils.class);
    private static final String CLASSPATH_PREFIX = "classpath:";

    private KeyManagementUtils() {
    }

    public static Properties loadSignatureOutProperties() {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        return KeyManagementUtils.loadStoreProperties(m, "rs.security.signature.out.properties", "rs.security.signature.properties");
    }

    public static Properties loadSignatureInProperties() {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        return KeyManagementUtils.loadStoreProperties(m, "rs.security.signature.in.properties", "rs.security.signature.properties");
    }

    private static Properties loadStoreProperties(Message m, String storeProp1, String storeProp2) {
        if (m == null) {
            return null;
        }
        Properties props = null;
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)storeProp1, (String)storeProp2);
        if (propLoc != null) {
            try {
                props = KeyManagementUtils.loadProperties(propLoc, m.getExchange().getBus());
            }
            catch (Exception ex) {
                LOG.warning("Properties resource is not identified");
                throw new SignatureException("Properties resource is not identified", ex);
            }
        } else {
            String keyFile = (String)m.getContextualProperty("rs.security.keystore.file");
            if (keyFile != null) {
                String keyPassword;
                String keystorePassword;
                props = new Properties();
                props.setProperty("rs.security.keystore.file", keyFile);
                String type = (String)m.getContextualProperty("rs.security.keystore.type");
                if (type == null) {
                    type = "JKS";
                }
                props.setProperty("rs.security.keystore.type", type);
                String alias = (String)m.getContextualProperty("rs.security.keystore.alias");
                if (alias != null) {
                    props.setProperty("rs.security.keystore.alias", alias);
                }
                if ((keystorePassword = (String)m.getContextualProperty("rs.security.keystore.password")) != null) {
                    props.setProperty("rs.security.keystore.password", keystorePassword);
                }
                if ((keyPassword = (String)m.getContextualProperty("rs.security.key.password")) != null) {
                    props.setProperty("rs.security.key.password", keyPassword);
                }
            }
        }
        return props;
    }

    public static PrivateKey loadPrivateKey(Message m, Properties props) {
        char[] keyPswdChars;
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        String keyPswd = props.getProperty("rs.security.key.password");
        String alias = props.getProperty("rs.security.keystore.alias");
        char[] cArray = keyPswdChars = keyPswd != null ? keyPswd.toCharArray() : null;
        if (keyPswdChars == null) {
            PrivateKeyPasswordProvider provider = KeyManagementUtils.loadPasswordProvider(m, props);
            keyPswdChars = provider != null ? provider.getPassword(props) : null;
        }
        return CryptoUtils.loadPrivateKey((KeyStore)keyStore, (char[])keyPswdChars, (String)alias);
    }

    public static PublicKey loadPublicKey(Message m, Properties props) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        String alias = props.getProperty("rs.security.keystore.alias");
        return CryptoUtils.loadCertificate((KeyStore)keyStore, (String)alias).getPublicKey();
    }

    private static PrivateKeyPasswordProvider loadPasswordProvider(Message m, Properties props) {
        PrivateKeyPasswordProvider cb = null;
        if (props.containsKey("rs.security.key.password.provider")) {
            cb = (PrivateKeyPasswordProvider)props.get("rs.security.key.password.provider");
        } else if (m != null) {
            cb = (PrivateKeyPasswordProvider)m.getContextualProperty("rs.security.key.password.provider");
        }
        return cb;
    }

    private static KeyStore loadPersistKeyStore(Message m, Properties props) {
        KeyStore keyStore = null;
        if (props.containsKey("rs.security.keystore")) {
            keyStore = (KeyStore)props.get("rs.security.keystore");
        }
        if (keyStore == null) {
            if (!props.containsKey("rs.security.keystore.file")) {
                LOG.warning("No keystore file has been configured");
                throw new SignatureException("No keystore file has been configured");
            }
            if (m != null) {
                Object keyStoreProp = m.getExchange().get(props.get("rs.security.keystore.file"));
                if (keyStoreProp != null && !(keyStoreProp instanceof KeyStore)) {
                    throw new SignatureException("Unexpected key store class: " + keyStoreProp.getClass().getName());
                }
                keyStore = (KeyStore)keyStoreProp;
            }
        }
        if (keyStore == null) {
            Bus bus = m != null ? m.getExchange().getBus() : null;
            keyStore = KeyManagementUtils.loadKeyStore(props, bus);
            if (m != null) {
                m.getExchange().put((Object)((String)props.get("rs.security.keystore.file")), (Object)keyStore);
            }
        }
        return keyStore;
    }

    private static KeyStore loadKeyStore(Properties props, Bus bus) {
        String keyStoreLoc = props.getProperty("rs.security.keystore.file");
        String keyStoreType = props.getProperty("rs.security.keystore.type");
        String keyStorePswd = props.getProperty("rs.security.keystore.password");
        return KeyManagementUtils.loadKeyStore(keyStoreLoc, keyStoreType, keyStorePswd, bus);
    }

    private static KeyStore loadKeyStore(String keyStoreLoc, String keyStoreType, String keyStorePswd, Bus bus) {
        if (keyStorePswd == null) {
            throw new SignatureException("No keystore password was defined");
        }
        try {
            InputStream is = KeyManagementUtils.getResourceStream(keyStoreLoc, bus);
            return CryptoUtils.loadKeyStore((InputStream)is, (char[])keyStorePswd.toCharArray(), (String)keyStoreType);
        }
        catch (Exception ex) {
            LOG.warning("Key store can not be loaded");
            throw new SignatureException("Key store can not be loaded", ex);
        }
    }

    private static InputStream getResourceStream(String loc, Bus bus) throws Exception {
        URL url = KeyManagementUtils.getResourceURL(loc, bus);
        return url == null ? null : url.openStream();
    }

    private static URL getResourceURL(String loc, Bus bus) throws Exception {
        URL url;
        block5: {
            if (loc.startsWith(CLASSPATH_PREFIX)) {
                String path = loc.substring(CLASSPATH_PREFIX.length());
                url = KeyManagementUtils.getClasspathResourceURL(path, KeyManagementUtils.class, bus);
            } else {
                try {
                    url = new URL(loc);
                }
                catch (Exception ex) {
                    File file;
                    url = KeyManagementUtils.getClasspathResourceURL(loc, KeyManagementUtils.class, bus);
                    if (url != null || !(file = new File(loc)).exists()) break block5;
                    url = file.toURI().toURL();
                }
            }
        }
        if (url == null) {
            LOG.warning("No resource " + loc + " is available");
        }
        return url;
    }

    private static URL getClasspathResourceURL(String path, Class<?> callingClass, Bus bus) {
        URL url = ClassLoaderUtils.getResource((String)path, callingClass);
        return url == null ? KeyManagementUtils.getResource(path, URL.class, bus) : url;
    }

    private static <T> T getResource(String path, Class<T> resourceClass, Bus bus) {
        ResourceManager rm;
        if (bus != null && (rm = (ResourceManager)bus.getExtension(ResourceManager.class)) != null) {
            return (T)rm.resolveResource(path, resourceClass);
        }
        return null;
    }

    private static Properties loadProperties(String propertiesLocation, Bus bus) throws Exception {
        Properties props = new Properties();
        try (InputStream is = KeyManagementUtils.getResourceStream(propertiesLocation, bus);){
            if (is == null) {
                throw new SignatureException("The properties file " + propertiesLocation + " could not be read");
            }
            props.load(is);
        }
        return props;
    }
}

