/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeBody;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.CoreLargeServerMessage;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LargeServerMessageImpl
extends CoreMessage
implements CoreLargeServerMessage {
    private static final int MEMORY_OFFSET = 168;
    private static final int CHUNK_LM_SIZE = 102400;
    private static final int ESTIMATE_RECORD_TRAIL = 512;
    private final LargeBody largeBody;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final StorageManager storageManager;

    @Override
    public Message toMessage() {
        return this;
    }

    public static Message checkLargeMessage(Message message, StorageManager storageManager) throws Exception {
        if (message.isLargeMessage()) {
            return message;
        }
        if ((long)(message.getEncodeSize() + 512) > storageManager.getMaxRecordSize()) {
            return LargeServerMessageImpl.asLargeMessage(message, storageManager);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Message asLargeMessage(Message message, StorageManager storageManager) throws Exception {
        ICoreMessage coreMessage = message.toCore();
        long id = storageManager.generateID();
        if (logger.isDebugEnabled()) {
            logger.debug("asLargeMessage create largeMessage with id={}", (Object)id);
        }
        LargeServerMessage lsm = storageManager.createCoreLargeMessage(id, (Message)coreMessage);
        ActiveMQBuffer messageBodyBuffer = coreMessage.getReadOnlyBodyBuffer();
        int readableBytes = messageBodyBuffer.readableBytes();
        ByteBuf ioBuffer = PooledByteBufAllocator.DEFAULT.ioBuffer(102400, 102400);
        ChannelBufferWrapper wrappedIOBuffer = new ChannelBufferWrapper(ioBuffer);
        try {
            while (messageBodyBuffer.readableBytes() > 0) {
                wrappedIOBuffer.clear();
                int bytesToRead = Math.min(102400, messageBodyBuffer.readableBytes());
                messageBodyBuffer.readBytes((ActiveMQBuffer)wrappedIOBuffer, 0, bytesToRead);
                wrappedIOBuffer.writerIndex(bytesToRead);
                lsm.addBytes((ActiveMQBuffer)wrappedIOBuffer);
            }
        }
        finally {
            lsm.releaseResources(true, true);
            ioBuffer.release();
        }
        if (!coreMessage.containsProperty(Message.HDR_LARGE_BODY_SIZE)) {
            lsm.toMessage().putLongProperty(Message.HDR_LARGE_BODY_SIZE, (long)readableBytes);
        }
        return lsm.toMessage();
    }

    public long getBodySize() throws ActiveMQException {
        return this.largeBody.getBodySize();
    }

    private void checkDebug() {
        if (LargeServerMessageImpl.isRefDebugEnabled()) {
            this.registerDebug();
        }
    }

    public LargeServerMessageImpl(StorageManager storageManager) {
        this.largeBody = new LargeBody(this, storageManager);
        this.storageManager = storageManager;
    }

    public LargeServerMessageImpl(LargeServerMessageImpl copy, TypedProperties properties, SequentialFile fileCopy, long newID) {
        super((CoreMessage)copy, properties);
        this.storageManager = copy.storageManager;
        this.largeBody = new LargeBody(this, this.storageManager, fileCopy);
        this.largeBody.setBodySize(copy.largeBody.getStoredBodySize());
        this.setMessageID(newID);
    }

    public LargeServerMessageImpl(byte type, long id, StorageManager storageManager, SequentialFile fileCopy) {
        this.storageManager = storageManager;
        this.setMessageID(id);
        this.setType(type);
        this.largeBody = new LargeBody(this, storageManager, fileCopy);
    }

    private static String toDate(long timestamp) {
        if (timestamp == 0L) {
            return "0";
        }
        return new Date(timestamp).toString();
    }

    public LargeServerMessageImpl setMessageID(long messageID) {
        super.setMessageID(messageID);
        this.checkDebug();
        return this;
    }

    @Override
    public Message getMessage() {
        return this;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public boolean isServerMessage() {
        return true;
    }

    @Override
    public void setPaged() {
        super.setPaged();
        this.largeBody.setPaged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBytes(byte[] bytes) throws Exception {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.addBytes(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBytes(ActiveMQBuffer bytes, boolean initialHeader) throws Exception {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.addBytes(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEncodeSize() {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            return this.getHeadersAndPropertiesEncodeSize();
        }
    }

    public long getWholeMessageSize() {
        try {
            return (long)this.getEncodeSize() + this.largeBody.getBodySize();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return this.getEncodeSize();
        }
    }

    public void encode(ActiveMQBuffer buffer1) {
        super.encodeHeadersAndProperties(buffer1.byteBuf());
    }

    public void decode(ActiveMQBuffer buffer1) {
        this.largeBody.clearFile();
        super.decodeHeadersAndProperties(buffer1.byteBuf());
    }

    @Override
    public LargeBodyReader getLargeBodyReader() {
        return this.largeBody.getLargeBodyReader();
    }

    protected void releaseComplete() {
        this.largeBody.releaseComplete();
    }

    public ActiveMQBuffer getReadOnlyBodyBuffer() {
        return this.largeBody.getReadOnlyBodyBuffer();
    }

    public int getBodyBufferSize() {
        return this.largeBody.getBodyBufferSize();
    }

    public boolean isLargeMessage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile() throws Exception {
        this.released();
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.deleteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMemoryEstimate() {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            if (this.memoryEstimate == -1) {
                this.memoryEstimate = 168 + this.getHeadersAndPropertiesEncodeSize() + 4 + this.getEncodeSize() + 40 + 1;
            }
            return this.memoryEstimate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResources(boolean sync, boolean sendEvent) {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            this.largeBody.releaseResources(sync, sendEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        LargeBody largeBody = this.largeBody;
        synchronized (largeBody) {
            try {
                return this.largeBody.getAppendFile().isOpen();
            }
            catch (Throwable e) {
                return false;
            }
        }
    }

    public void referenceOriginalMessage(Message original, SimpleString originalQueue) {
        super.referenceOriginalMessage(original, originalQueue);
        if (original instanceof LargeServerMessageImpl) {
            LargeServerMessageImpl largeServerMessage = (LargeServerMessageImpl)original;
            this.largeBody.referenceOriginalMessage(largeServerMessage.largeBody);
        }
    }

    @Override
    public void setStorageManager(StorageManager storageManager) {
        this.largeBody.setStorageManager(storageManager);
    }

    public ICoreMessage copy() {
        SequentialFile newfile = this.storageManager.createFileForLargeMessage(this.messageID, this.durable);
        LargeServerMessageImpl newMessage = new LargeServerMessageImpl(this, this.properties, newfile, this.messageID);
        newMessage.setParentRef((RefCountMessage)this);
        return newMessage;
    }

    @Override
    public LargeBody getLargeBody() {
        return this.largeBody;
    }

    public Message copy(long newID) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Copy large message id={} as newID={}", (Object)this.getMessageID(), (Object)newID);
            }
            LargeServerMessage newMessage = this.storageManager.createCoreLargeMessage(newID, (Message)this);
            this.largeBody.copyInto(newMessage);
            newMessage.releaseResources(true, true);
            return newMessage.toMessage();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.lareMessageErrorCopying(this, e);
            return null;
        }
    }

    @Override
    public SequentialFile getAppendFile() throws ActiveMQException {
        return this.largeBody.getAppendFile();
    }

    public long getPersistentSize() throws ActiveMQException {
        long size = super.getPersistentSize();
        return size += this.getBodySize();
    }

    public String toString() {
        try {
            return "LargeServerMessage[messageID=" + this.messageID + ",durable=" + this.isDurable() + ",userID=" + String.valueOf(this.getUserID()) + ",priority=" + this.getPriority() + ", timestamp=" + LargeServerMessageImpl.toDate(this.getTimestamp()) + ",expiration=" + LargeServerMessageImpl.toDate(this.getExpiration()) + ", durable=" + this.durable + ", address=" + this.getAddress() + ", properties=" + (this.properties != null ? this.properties.toString() : "") + "]@" + System.identityHashCode(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "LargeServerMessage[messageID=" + this.messageID + "]";
        }
    }
}

