/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratSampler;

public class AhrensDieterMarsagliaTsangGammaSampler
extends SamplerBase
implements SharedStateContinuousSampler {
    private final SharedStateContinuousSampler delegate;

    public AhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
        super(null);
        this.delegate = AhrensDieterMarsagliaTsangGammaSampler.of(rng, alpha, theta);
    }

    @Override
    public double sample() {
        return this.delegate.sample();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return (SharedStateContinuousSampler)this.delegate.withUniformRandomProvider(rng);
    }

    public static SharedStateContinuousSampler of(UniformRandomProvider rng, double alpha, double theta) {
        return alpha < 1.0 ? new AhrensDieterGammaSampler(rng, alpha, theta) : new MarsagliaTsangGammaSampler(rng, alpha, theta);
    }

    private static final class MarsagliaTsangGammaSampler
    extends BaseGammaSampler {
        private static final double ONE_THIRD = 0.3333333333333333;
        private final double dOptim;
        private final double cOptim;
        private final NormalizedGaussianSampler gaussian;

        MarsagliaTsangGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
            super(rng, alpha, theta);
            this.gaussian = ZigguratSampler.NormalizedGaussian.of(rng);
            this.dOptim = alpha - 0.3333333333333333;
            this.cOptim = 0.3333333333333333 / Math.sqrt(this.dOptim);
        }

        MarsagliaTsangGammaSampler(UniformRandomProvider rng, MarsagliaTsangGammaSampler source) {
            super(rng, source);
            this.gaussian = ZigguratSampler.NormalizedGaussian.of(rng);
            this.dOptim = source.dOptim;
            this.cOptim = source.cOptim;
        }

        @Override
        public double sample() {
            double v;
            while (true) {
                double x;
                double oPcTx;
                if ((v = (oPcTx = 1.0 + this.cOptim * (x = this.gaussian.sample())) * oPcTx * oPcTx) <= 0.0) {
                    continue;
                }
                double x2 = x * x;
                double u = this.rng.nextDouble();
                if (u < 1.0 - 0.0331 * x2 * x2) {
                    return this.theta * this.dOptim * v;
                }
                if (Math.log(u) < 0.5 * x2 + this.dOptim * (1.0 - v + Math.log(v))) break;
            }
            return this.theta * this.dOptim * v;
        }

        @Override
        public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new MarsagliaTsangGammaSampler(rng, this);
        }
    }

    private static final class AhrensDieterGammaSampler
    extends BaseGammaSampler {
        private final double oneOverAlpha;
        private final double bGSOptim;

        AhrensDieterGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
            super(rng, alpha, theta);
            this.oneOverAlpha = 1.0 / alpha;
            this.bGSOptim = 1.0 + alpha / Math.E;
        }

        AhrensDieterGammaSampler(UniformRandomProvider rng, AhrensDieterGammaSampler source) {
            super(rng, source);
            this.oneOverAlpha = source.oneOverAlpha;
            this.bGSOptim = source.bGSOptim;
        }

        @Override
        public double sample() {
            double x;
            while (true) {
                double u2;
                double u;
                double p;
                if ((p = this.bGSOptim * (u = this.rng.nextDouble())) <= 1.0) {
                    x = Math.pow(p, this.oneOverAlpha);
                    u2 = this.rng.nextDouble();
                    if (u2 > Math.exp(-x)) continue;
                    return this.theta * x;
                }
                x = -Math.log((this.bGSOptim - p) * this.oneOverAlpha);
                u2 = this.rng.nextDouble();
                if (u2 <= Math.pow(x, this.alpha - 1.0)) break;
            }
            return this.theta * x;
        }

        @Override
        public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new AhrensDieterGammaSampler(rng, this);
        }
    }

    private static abstract class BaseGammaSampler
    implements SharedStateContinuousSampler {
        protected final UniformRandomProvider rng;
        protected final double alpha;
        protected final double theta;

        BaseGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
            this(InternalUtils.requireStrictlyPositive(alpha, "alpha"), InternalUtils.requireStrictlyPositive(theta, "theta"), rng);
        }

        private BaseGammaSampler(double alpha, double theta, UniformRandomProvider rng) {
            this.rng = rng;
            this.alpha = alpha;
            this.theta = theta;
        }

        BaseGammaSampler(UniformRandomProvider rng, BaseGammaSampler source) {
            this.rng = rng;
            this.alpha = source.alpha;
            this.theta = source.theta;
        }

        public String toString() {
            return "Ahrens-Dieter-Marsaglia-Tsang Gamma deviate [" + this.rng.toString() + "]";
        }
    }
}

