/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.shape;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.shape.Coordinates;

public class TetrahedronSampler
implements SharedStateObjectSampler<double[]> {
    private static final int THREE_D = 3;
    private static final String VERTEX_A = "Vertex a";
    private static final String VERTEX_B = "Vertex b";
    private static final String VERTEX_C = "Vertex c";
    private static final String VERTEX_D = "Vertex d";
    private final double[] a;
    private final double[] b;
    private final double[] c;
    private final double[] d;
    private final UniformRandomProvider rng;

    TetrahedronSampler(UniformRandomProvider rng, double[] a, double[] b, double[] c, double[] d) {
        this.a = (double[])a.clone();
        this.b = (double[])b.clone();
        this.c = (double[])c.clone();
        this.d = (double[])d.clone();
        this.rng = rng;
    }

    TetrahedronSampler(UniformRandomProvider rng, TetrahedronSampler source) {
        this.a = source.a;
        this.b = source.b;
        this.c = source.c;
        this.d = source.d;
        this.rng = rng;
    }

    @Override
    public double[] sample() {
        double tpu;
        double sptpu;
        double s = this.rng.nextDouble();
        double t = this.rng.nextDouble();
        double u = this.rng.nextDouble();
        if (s + t > 1.0) {
            s = 1.0 - s;
            t = 1.0 - t;
        }
        if ((sptpu = s + (tpu = t + u)) > 1.0) {
            if (tpu > 1.0) {
                return this.createSample(u - 1.0 + t, s, 1.0 - u, 1.0 - s - t);
            }
            return this.createSample(1.0 - s - t, 1.0 - tpu, t, s - 1.0 + tpu);
        }
        return this.createSample(1.0 - sptpu, s, t, u);
    }

    private double[] createSample(double p1msmtmu, double s, double t, double u) {
        return new double[]{p1msmtmu * this.a[0] + s * this.b[0] + t * this.c[0] + u * this.d[0], p1msmtmu * this.a[1] + s * this.b[1] + t * this.c[1] + u * this.d[1], p1msmtmu * this.a[2] + s * this.b[2] + t * this.c[2] + u * this.d[2]};
    }

    @Override
    public TetrahedronSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new TetrahedronSampler(rng, this);
    }

    public static TetrahedronSampler of(UniformRandomProvider rng, double[] a, double[] b, double[] c, double[] d) {
        Coordinates.requireLength(a, 3, VERTEX_A);
        Coordinates.requireLength(b, 3, VERTEX_B);
        Coordinates.requireLength(c, 3, VERTEX_C);
        Coordinates.requireLength(d, 3, VERTEX_D);
        Coordinates.requireFinite(a, VERTEX_A);
        Coordinates.requireFinite(b, VERTEX_B);
        Coordinates.requireFinite(c, VERTEX_C);
        Coordinates.requireFinite(d, VERTEX_D);
        return new TetrahedronSampler(rng, a, b, c, d);
    }
}

