/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.commons.fileupload2.core.AbstractRequestContext;
import org.apache.commons.fileupload2.core.RequestContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MockRequestContextTest {
    MockRequestContextTest() {
    }

    @Test
    public void getCharset() {
        MockRequestContext request = new MockRequestContext(x -> "1234", () -> 5678L, "Request", "US-ASCII", "text/plain", null);
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)request.getCharset());
    }

    @Test
    public void getContentLengthByParsing() {
        MockRequestContext request = new MockRequestContext(x -> "1234", () -> 5678L, "Request", "US-ASCII", "text/plain", null);
        Assertions.assertEquals((long)1234L, (long)request.getContentLength());
    }

    @Test
    public void getContentLengthDefaultBecauseOfInvalidNumber() {
        MockRequestContext request = new MockRequestContext(x -> "not-a-number", () -> 5678L, "Request", "US-ASCII", "text/plain", null);
        Assertions.assertEquals((long)5678L, (long)request.getContentLength());
    }

    @Test
    public void getInvalidCharset() {
        MockRequestContext request = new MockRequestContext(x -> "1234", () -> 5678L, "Request", "invalid-charset", "text/plain", null);
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> ((RequestContext)request).getCharset());
    }

    @Test
    void testIsMultipartRelated() {
        MockRequestContext request = new MockRequestContext(x -> "1234", () -> 5678L, "Request", "US-ASCII", "multipart/related; boundary=---1234; type=\"application/xop+xml\"; start-info=\"application/soap+xml\"", null);
        Assertions.assertTrue((boolean)request.isMultipartRelated());
    }

    @Test
    void testIsNotMultipartRelated() {
        MockRequestContext request = new MockRequestContext(x -> "1234", () -> 5678L, "Request", "US-ASCII", "text/plain", null);
        Assertions.assertFalse((boolean)request.isMultipartRelated());
    }

    @Test
    void testToString() {
        MockRequestContext request = new MockRequestContext(x -> "1234", () -> 5678L, "Request", "US-ASCII", "text/plain", null);
        Assertions.assertEquals((Object)"MockRequestContext [ContentLength=1234, ContentType=text/plain]", (Object)((Object)((Object)request)).toString());
    }

    private static final class MockRequestContext
    extends AbstractRequestContext<Object> {
        private final String characterEncoding;
        private final String contentType;
        private final InputStream inputStream;

        private MockRequestContext(Function<String, String> contentLengthString, LongSupplier contentLengthDefault, Object request, String characterEncoding, String contentType, InputStream inputStream) {
            super(contentLengthString, contentLengthDefault, request);
            this.characterEncoding = characterEncoding;
            this.contentType = contentType;
            this.inputStream = inputStream;
        }

        public String getCharacterEncoding() {
            return this.characterEncoding;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

