/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.File;
import java.util.List;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.network.buffer.FileSegmentManagedBuffer;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.util.TransportConf;

public class FileManagedBuffers {
    private final File file;
    private final long[] offsets;
    private final int numChunks;
    private final TransportConf conf;

    public FileManagedBuffers(FileInfo fileInfo, TransportConf conf) {
        this.file = fileInfo.getFile();
        this.numChunks = fileInfo.numChunks();
        if (this.numChunks > 0) {
            this.offsets = new long[this.numChunks + 1];
            List<Long> chunkOffsets = fileInfo.getChunkOffsets();
            for (int i = 0; i <= this.numChunks; ++i) {
                this.offsets[i] = chunkOffsets.get(i);
            }
        } else {
            this.offsets = new long[]{0L};
        }
        this.conf = conf;
    }

    public int numChunks() {
        return this.numChunks;
    }

    public ManagedBuffer chunk(int chunkIndex, int offset, int len) {
        long chunkOffset = this.offsets[chunkIndex];
        long chunkLength = this.offsets[chunkIndex + 1] - chunkOffset;
        assert ((long)offset < chunkLength);
        long length = Math.min(chunkLength - (long)offset, (long)len);
        return new FileSegmentManagedBuffer(this.conf, this.file, chunkOffset + (long)offset, length);
    }
}

