/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.sasl;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import org.apache.celeborn.shaded.com.google.common.collect.ImmutableMap;

public class SaslUtils {
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final String DIGEST_MD5 = "DIGEST-MD5";
    static final String QOP_AUTH = "auth";
    static final String DEFAULT_REALM = "default";
    static final Map<String, String> DEFAULT_SASL_CLIENT_PROPS = ImmutableMap.builder().put("javax.security.sasl.qop", "auth").build();
    static final Map<String, String> DEFAULT_SASL_SERVER_PROPS = ImmutableMap.builder().put("javax.security.sasl.server.authentication", "true").put("javax.security.sasl.qop", "auth").build();

    static String encodeIdentifier(String identifier) {
        Preconditions.checkNotNull(identifier, "User cannot be null if SASL is enabled");
        return Base64.getEncoder().encodeToString(identifier.getBytes(StandardCharsets.UTF_8));
    }

    static String decodeIdentifier(String identifier) {
        Preconditions.checkNotNull(identifier, "User cannot be null if SASL is enabled");
        return new String(Base64.getDecoder().decode(identifier.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    static char[] encodePassword(String password) {
        Preconditions.checkNotNull(password, "Password cannot be null if SASL is enabled");
        return Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8)).toCharArray();
    }
}

