/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network;

import java.util.Collections;
import java.util.List;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.client.TransportResponseHandler;
import org.apache.celeborn.common.network.protocol.MessageEncoder;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.server.TransportChannelHandler;
import org.apache.celeborn.common.network.server.TransportRequestHandler;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.server.TransportServerBootstrap;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.network.util.TransportFrameDecoder;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.apache.celeborn.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandler;
import org.apache.celeborn.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.celeborn.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.celeborn.shaded.io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportContext {
    private static final Logger logger = LoggerFactory.getLogger(TransportContext.class);
    private final TransportConf conf;
    private final BaseMessageHandler msgHandler;
    private final ChannelDuplexHandler channelsLimiter;
    private final boolean closeIdleConnections;
    private final boolean enableHeartbeat;
    private final AbstractSource source;
    private static final MessageEncoder ENCODER = MessageEncoder.INSTANCE;

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler, boolean closeIdleConnections, ChannelDuplexHandler channelsLimiter, boolean enableHeartbeat, AbstractSource source) {
        this.conf = conf;
        this.msgHandler = msgHandler;
        this.closeIdleConnections = closeIdleConnections;
        this.channelsLimiter = channelsLimiter;
        this.enableHeartbeat = enableHeartbeat;
        this.source = source;
    }

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler, boolean closeIdleConnections, boolean enableHeartbeat, AbstractSource source) {
        this(conf, msgHandler, closeIdleConnections, null, enableHeartbeat, source);
    }

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler, boolean closeIdleConnections) {
        this(conf, msgHandler, closeIdleConnections, null, false, null);
    }

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler) {
        this(conf, msgHandler, false, false, null);
    }

    public TransportClientFactory createClientFactory(List<TransportClientBootstrap> bootstraps) {
        return new TransportClientFactory(this, bootstraps);
    }

    public TransportClientFactory createClientFactory() {
        return this.createClientFactory(Collections.emptyList());
    }

    public TransportServer createServer(String host, int port) {
        return new TransportServer(this, host, port, this.source, this.msgHandler, Collections.emptyList());
    }

    public TransportServer createServer(String host, int port, List<TransportServerBootstrap> bootstraps) {
        return new TransportServer(this, host, port, this.source, this.msgHandler, bootstraps);
    }

    public TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return this.createServer(null, 0, bootstraps);
    }

    public TransportServer createServer(int port) {
        return this.createServer(null, port, Collections.emptyList());
    }

    public TransportServer createServer() {
        return this.createServer(null, 0, Collections.emptyList());
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, ChannelInboundHandlerAdapter decoder) {
        return this.initializePipeline(channel, decoder, this.msgHandler);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, BaseMessageHandler resolvedMsgHandler) {
        return this.initializePipeline(channel, new TransportFrameDecoder(), resolvedMsgHandler);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, ChannelInboundHandlerAdapter decoder, BaseMessageHandler resolvedMsgHandler) {
        try {
            if (this.channelsLimiter != null) {
                channel.pipeline().addLast("limiter", (ChannelHandler)this.channelsLimiter);
            }
            TransportChannelHandler channelHandler = this.createChannelHandler(channel, resolvedMsgHandler);
            channel.pipeline().addLast("encoder", (ChannelHandler)ENCODER).addLast("frameDecoder", (ChannelHandler)decoder).addLast("idleStateHandler", (ChannelHandler)(this.enableHeartbeat ? new IdleStateHandler(this.conf.connectionTimeoutMs() / 1000, 0, 0) : new IdleStateHandler(0, 0, this.conf.connectionTimeoutMs() / 1000))).addLast("handler", (ChannelHandler)channelHandler);
            return channelHandler;
        }
        catch (RuntimeException e) {
            logger.error("Error while initializing Netty pipeline", (Throwable)e);
            throw e;
        }
    }

    private TransportChannelHandler createChannelHandler(Channel channel, BaseMessageHandler msgHandler) {
        TransportResponseHandler responseHandler = new TransportResponseHandler(this.conf, channel);
        TransportClient client = new TransportClient(channel, responseHandler);
        TransportRequestHandler requestHandler = new TransportRequestHandler(channel, client, msgHandler);
        return new TransportChannelHandler(client, responseHandler, requestHandler, this.conf.connectionTimeoutMs(), this.closeIdleConnections, this.enableHeartbeat, this.conf.clientHeartbeatInterval(), this);
    }

    public TransportConf getConf() {
        return this.conf;
    }

    public BaseMessageHandler getMsgHandler() {
        return this.msgHandler;
    }
}

