/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.identity.UserIdentifier$;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.CollectionUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.master.clustermeta.ResourceProtos;

public class MetaUtil {
    private MetaUtil() {
    }

    public static WorkerInfo addrToInfo(ResourceProtos.WorkerAddress address) {
        return new WorkerInfo(address.getHost(), address.getRpcPort(), address.getPushPort(), address.getFetchPort(), address.getReplicatePort());
    }

    public static ResourceProtos.WorkerAddress infoToAddr(WorkerInfo info) {
        return ResourceProtos.WorkerAddress.newBuilder().setHost(info.host()).setRpcPort(info.rpcPort()).setPushPort(info.pushPort()).setFetchPort(info.fetchPort()).setReplicatePort(info.replicatePort()).build();
    }

    public static Map<String, DiskInfo> fromPbDiskInfos(Map<String, ResourceProtos.DiskInfo> diskInfos) {
        HashMap<String, DiskInfo> map = new HashMap<String, DiskInfo>();
        diskInfos.forEach((k, v) -> {
            DiskInfo diskInfo = new DiskInfo(v.getMountPoint(), v.getUsableSpace(), v.getAvgFlushTime(), v.getAvgFetchTime(), v.getUsedSlots(), (StorageInfo.Type)StorageInfo.typesMap.get(v.getStorageType()));
            diskInfo.setStatus(Utils.toDiskStatus((int)v.getStatus()));
            map.put((String)k, diskInfo);
        });
        return map;
    }

    public static Map<String, ResourceProtos.DiskInfo> toPbDiskInfos(Map<String, DiskInfo> diskInfos) {
        HashMap<String, ResourceProtos.DiskInfo> map = new HashMap<String, ResourceProtos.DiskInfo>();
        diskInfos.forEach((k, v) -> map.put((String)k, ResourceProtos.DiskInfo.newBuilder().setMountPoint(v.mountPoint()).setUsableSpace(v.actualUsableSpace()).setAvgFlushTime(v.avgFlushTime()).setAvgFetchTime(v.avgFetchTime()).setUsedSlots(v.activeSlots()).setStorageType(v.storageType().getValue()).setStatus(v.status().getValue()).build()));
        return map;
    }

    public static ResourceConsumption fromPbResourceConsumption(ResourceProtos.ResourceConsumption pbResourceConsumption) {
        return new ResourceConsumption(pbResourceConsumption.getDiskBytesWritten(), pbResourceConsumption.getDiskFileCount(), pbResourceConsumption.getHdfsBytesWritten(), pbResourceConsumption.getHdfsFileCount(), MetaUtil.fromPbSubResourceConsumptions(pbResourceConsumption.getSubResourceConsumptionMap()));
    }

    public static ResourceProtos.ResourceConsumption toPbResourceConsumption(ResourceConsumption resourceConsumption) {
        return ResourceProtos.ResourceConsumption.newBuilder().setDiskBytesWritten(resourceConsumption.diskBytesWritten()).setDiskFileCount(resourceConsumption.diskFileCount()).setHdfsBytesWritten(resourceConsumption.hdfsBytesWritten()).setHdfsFileCount(resourceConsumption.hdfsFileCount()).putAllSubResourceConsumption(MetaUtil.toPbSubResourceConsumptions(resourceConsumption.subResourceConsumptions())).build();
    }

    public static Map<String, ResourceConsumption> fromPbSubResourceConsumptions(Map<String, ResourceProtos.ResourceConsumption> pbSubResourceConsumptions) {
        return CollectionUtils.isEmpty(pbSubResourceConsumptions) ? null : pbSubResourceConsumptions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, resourceConsumption -> MetaUtil.fromPbResourceConsumption((ResourceProtos.ResourceConsumption)resourceConsumption.getValue())));
    }

    public static Map<String, ResourceProtos.ResourceConsumption> toPbSubResourceConsumptions(Map<String, ResourceConsumption> subResourceConsumptions) {
        return CollectionUtils.isEmpty(subResourceConsumptions) ? new HashMap<String, ResourceProtos.ResourceConsumption>() : subResourceConsumptions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, resourceConsumption -> MetaUtil.toPbResourceConsumption((ResourceConsumption)resourceConsumption.getValue())));
    }

    public static Map<UserIdentifier, ResourceConsumption> fromPbUserResourceConsumption(Map<String, ResourceProtos.ResourceConsumption> pbUserResourceConsumption) {
        HashMap<UserIdentifier, ResourceConsumption> map = new HashMap<UserIdentifier, ResourceConsumption>();
        pbUserResourceConsumption.forEach((k, v) -> map.put(UserIdentifier$.MODULE$.apply(k), MetaUtil.fromPbResourceConsumption(v)));
        return map;
    }

    public static Map<String, ResourceProtos.ResourceConsumption> toPbUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> userResourceConsumption) {
        HashMap<String, ResourceProtos.ResourceConsumption> map = new HashMap<String, ResourceProtos.ResourceConsumption>();
        userResourceConsumption.forEach((k, v) -> map.put(k.toString(), MetaUtil.toPbResourceConsumption(v)));
        return map;
    }
}

