/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

public final class RaftPeerId {
    private static final Map<ByteString, RaftPeerId> BYTE_STRING_MAP = new ConcurrentHashMap<ByteString, RaftPeerId>();
    private static final Map<String, RaftPeerId> STRING_MAP = new ConcurrentHashMap<String, RaftPeerId>();
    private final String idString;
    private final ByteString id;
    private final Supplier<RaftProtos.RaftPeerIdProto> raftPeerIdProto;

    public static RaftPeerId valueOf(ByteString id) {
        return BYTE_STRING_MAP.computeIfAbsent(id, RaftPeerId::new);
    }

    public static RaftPeerId valueOf(String id) {
        return STRING_MAP.computeIfAbsent(id, RaftPeerId::new);
    }

    public static RaftPeerId getRaftPeerId(String id) {
        return id == null || id.isEmpty() ? null : RaftPeerId.valueOf(id);
    }

    private RaftPeerId(String id) {
        this.idString = Objects.requireNonNull(id, "id == null");
        this.id = ByteString.copyFrom((String)this.idString, (Charset)StandardCharsets.UTF_8);
        this.raftPeerIdProto = JavaUtils.memoize(this::buildRaftPeerIdProto);
    }

    private RaftPeerId(ByteString id) {
        this.id = Objects.requireNonNull(id, "id == null");
        Preconditions.assertTrue(id.size() > 0, "id is empty.");
        this.idString = id.toString(StandardCharsets.UTF_8);
        this.raftPeerIdProto = JavaUtils.memoize(this::buildRaftPeerIdProto);
    }

    private RaftProtos.RaftPeerIdProto buildRaftPeerIdProto() {
        RaftProtos.RaftPeerIdProto.Builder builder = RaftProtos.RaftPeerIdProto.newBuilder().setId(this.id);
        return builder.build();
    }

    public RaftProtos.RaftPeerIdProto getRaftPeerIdProto() {
        return this.raftPeerIdProto.get();
    }

    public ByteString toByteString() {
        return this.id;
    }

    public String toString() {
        return this.idString;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof RaftPeerId && this.idString.equals(((RaftPeerId)other).idString);
    }

    public int hashCode() {
        return this.idString.hashCode();
    }
}

