/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.JavaUtils;

public final class GroupManagementRequest
extends RaftClientRequest {
    private final Op op;

    public static GroupManagementRequest newAdd(ClientId clientId, RaftPeerId serverId, long callId, RaftGroup group) {
        return new GroupManagementRequest(clientId, serverId, callId, new Add(group));
    }

    public static GroupManagementRequest newRemove(ClientId clientId, RaftPeerId serverId, long callId, RaftGroupId groupId, boolean deleteDirectory, boolean renameDirectory) {
        return new GroupManagementRequest(clientId, serverId, callId, new Remove(groupId, deleteDirectory, renameDirectory));
    }

    private GroupManagementRequest(ClientId clientId, RaftPeerId serverId, long callId, Op op) {
        super(clientId, serverId, op.getGroupId(), callId, false, GroupManagementRequest.writeRequestType());
        this.op = op;
    }

    public Add getAdd() {
        return this.op instanceof Add ? (Add)this.op : null;
    }

    public Remove getRemove() {
        return this.op instanceof Remove ? (Remove)this.op : null;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.op;
    }

    public static class Remove
    extends Op {
        private final RaftGroupId groupId;
        private final boolean deleteDirectory;
        private final boolean renameDirectory;

        public Remove(RaftGroupId groupId, boolean deleteDirectory, boolean renameDirectory) {
            this.groupId = groupId;
            this.deleteDirectory = deleteDirectory;
            this.renameDirectory = renameDirectory;
        }

        @Override
        public RaftGroupId getGroupId() {
            return this.groupId;
        }

        public boolean isDeleteDirectory() {
            return this.deleteDirectory;
        }

        public boolean isRenameDirectory() {
            return this.renameDirectory;
        }

        public String toString() {
            return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.getGroupId() + ", " + (this.deleteDirectory ? "delete" : (this.renameDirectory ? "rename" : "retain")) + "-dir";
        }
    }

    public static class Add
    extends Op {
        private final RaftGroup group;

        public Add(RaftGroup group) {
            this.group = group;
        }

        @Override
        public RaftGroupId getGroupId() {
            return this.getGroup().getGroupId();
        }

        public RaftGroup getGroup() {
            return this.group;
        }

        public String toString() {
            return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.getGroup();
        }
    }

    public static abstract class Op {
        public abstract RaftGroupId getGroupId();
    }
}

