/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.metrics.NettyShuffleMetricFactory;
import org.apache.flink.runtime.io.network.partition.PartitionProducerStateProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteShuffleEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteShuffleEnvironment.class);
    protected final NetworkBufferPool networkBufferPool;
    protected final ResultPartitionManager resultPartitionManager;
    protected boolean isClosed;
    protected final Object lock = new Object();
    protected final CelebornConf conf;

    public AbstractRemoteShuffleEnvironment(NetworkBufferPool networkBufferPool, ResultPartitionManager resultPartitionManager, CelebornConf conf) {
        this.networkBufferPool = networkBufferPool;
        this.resultPartitionManager = resultPartitionManager;
        this.conf = conf;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOG.info("Close RemoteShuffleEnvironment.");
        Object object = this.lock;
        synchronized (object) {
            try {
                this.networkBufferPool.destroyAllBufferPools();
            }
            catch (Throwable t) {
                LOG.error("Close RemoteShuffleEnvironment failure.", t);
            }
            try {
                this.resultPartitionManager.shutdown();
            }
            catch (Throwable t) {
                LOG.error("Close RemoteShuffleEnvironment failure.", t);
            }
            try {
                this.networkBufferPool.destroy();
            }
            catch (Throwable t) {
                LOG.error("Close RemoteShuffleEnvironment failure.", t);
            }
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Utils.checkState(!this.isClosed, "The RemoteShuffleEnvironment has already been shut down.");
            LOG.info("Starting the network environment and its components.");
            return 1;
        }
    }

    public boolean updatePartitionInfo(ExecutionAttemptID consumerID, PartitionInfo partitionInfo) {
        throw new FlinkRuntimeException("Not implemented yet.");
    }

    public ShuffleIOOwnerContext createShuffleIOOwnerContext(String ownerName, ExecutionAttemptID executionAttemptID, MetricGroup parentGroup) {
        MetricGroup nettyGroup = NettyShuffleMetricFactory.createShuffleIOOwnerMetricGroup((MetricGroup)Utils.checkNotNull(parentGroup));
        return new ShuffleIOOwnerContext(Utils.checkNotNull(ownerName), Utils.checkNotNull(executionAttemptID), parentGroup, nettyGroup.addGroup("Output"), nettyGroup.addGroup("Input"));
    }

    public void releasePartitionsLocally(Collection<ResultPartitionID> partitionIds) {
        throw new FlinkRuntimeException("Not implemented yet.");
    }

    public Collection<ResultPartitionID> getPartitionsOccupyingLocalResources() {
        return new ArrayList<ResultPartitionID>();
    }

    @VisibleForTesting
    NetworkBufferPool getNetworkBufferPool() {
        return this.networkBufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultPartitionWriter> createResultPartitionWriters(ShuffleIOOwnerContext ownerContext, List<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors) {
        Object object = this.lock;
        synchronized (object) {
            Utils.checkState(!this.isClosed, "The RemoteShuffleEnvironment has already been shut down.");
            ResultPartitionWriter[] resultPartitions = new ResultPartitionWriter[resultPartitionDeploymentDescriptors.size()];
            for (int index = 0; index < resultPartitions.length; ++index) {
                resultPartitions[index] = this.createResultPartitionWriterInternal(ownerContext, index, resultPartitionDeploymentDescriptors.get(index), this.conf);
            }
            return Arrays.asList(resultPartitions);
        }
    }

    public abstract ResultPartitionWriter createResultPartitionWriterInternal(ShuffleIOOwnerContext var1, int var2, ResultPartitionDeploymentDescriptor var3, CelebornConf var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndexedInputGate> createInputGates(ShuffleIOOwnerContext ownerContext, PartitionProducerStateProvider producerStateProvider, List<InputGateDeploymentDescriptor> inputGateDescriptors) {
        Object object = this.lock;
        synchronized (object) {
            Utils.checkState(!this.isClosed, "The RemoteShuffleEnvironment has already been shut down.");
            IndexedInputGate[] inputGates = new IndexedInputGate[inputGateDescriptors.size()];
            for (int gateIndex = 0; gateIndex < inputGates.length; ++gateIndex) {
                IndexedInputGate inputGate;
                InputGateDeploymentDescriptor igdd = inputGateDescriptors.get(gateIndex);
                inputGates[gateIndex] = inputGate = this.createInputGateInternal(ownerContext, gateIndex, igdd);
            }
            return Arrays.asList(inputGates);
        }
    }

    abstract IndexedInputGate createInputGateInternal(ShuffleIOOwnerContext var1, int var2, InputGateDeploymentDescriptor var3);
}

