/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import java.nio.charset.StandardCharsets;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;

public class Encoders {

    public static class StringArrays {
        public static int encodedLength(String[] strings) {
            int totalLength = 4;
            for (String s : strings) {
                totalLength += Strings.encodedLength(s);
            }
            return totalLength;
        }

        public static void encode(ByteBuf buf, String[] strings) {
            buf.writeInt(strings.length);
            for (String s : strings) {
                Strings.encode(buf, s);
            }
        }

        public static String[] decode(ByteBuf buf) {
            int numStrings = buf.readInt();
            String[] strings = new String[numStrings];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = Strings.decode(buf);
            }
            return strings;
        }
    }

    public static class IntArrays {
        public static int encodedLength(int[] ints) {
            return 4 + 4 * ints.length;
        }

        public static void encode(ByteBuf buf, int[] ints) {
            buf.writeInt(ints.length);
            for (int i : ints) {
                buf.writeInt(i);
            }
        }

        public static int[] decode(ByteBuf buf) {
            int length = buf.readInt();
            int[] ints = new int[length];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = buf.readInt();
            }
            return ints;
        }
    }

    public static class Strings {
        public static int encodedLength(String s) {
            return 4 + s.getBytes(StandardCharsets.UTF_8).length;
        }

        public static void encode(ByteBuf buf, String s) {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }

        public static String decode(ByteBuf buf) {
            int length = buf.readInt();
            byte[] bytes = new byte[length];
            buf.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }
}

