/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.ratis.shell.cli.Command;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.thirdparty.com.google.common.io.Closer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShell
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractShell.class);
    private final Map<String, Command> mCommands;
    private final Closer closer = Closer.create();

    public AbstractShell(Context context) {
        this.mCommands = this.loadCommands(context);
        this.mCommands.values().forEach(arg_0 -> ((Closer)this.closer).register(arg_0));
    }

    public int run(String ... argv) {
        CommandLine cmdline;
        if (argv.length == 0) {
            this.printUsage();
            return -1;
        }
        String cmd = argv[0];
        Command command = this.mCommands.get(cmd);
        if (command == null) {
            System.err.printf("%s is an unknown command.%n", cmd);
            this.printUsage();
            return -1;
        }
        try {
            String[] currArgs = Arrays.copyOf(argv, argv.length);
            while (command.hasSubCommand()) {
                if (currArgs.length < 2) {
                    throw new IllegalArgumentException("No sub-command is specified");
                }
                if (!command.getSubCommands().containsKey(currArgs[1])) {
                    throw new IllegalArgumentException("Unknown sub-command: " + currArgs[1]);
                }
                command = command.getSubCommands().get(currArgs[1]);
                currArgs = Arrays.copyOfRange(currArgs, 1, currArgs.length);
            }
            currArgs = Arrays.copyOfRange(currArgs, 1, currArgs.length);
            cmdline = command.parseAndValidateArgs(currArgs);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            System.out.println("Usage: " + command.getUsage());
            System.out.println(command.getDescription());
            LOG.error("Invalid arguments for command {}:", (Object)command.getCommandName(), (Object)e);
            return -1;
        }
        try {
            return command.run(cmdline);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            LOG.error("Error running" + Arrays.stream(argv).reduce("", (a, b) -> a + " " + b), (Throwable)e);
            return -1;
        }
    }

    public Collection<Command> getCommands() {
        return this.mCommands.values();
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    protected abstract String getShellName();

    protected abstract Map<String, Command> loadCommands(Context var1);

    protected Closer getCloser() {
        return this.closer;
    }

    protected void printUsage() {
        System.out.println("Usage: ratis " + this.getShellName() + " [generic options]");
        TreeSet<String> sortedCmds = new TreeSet<String>(this.mCommands.keySet());
        for (String cmd : sortedCmds) {
            System.out.format("%-60s%n", "\t [" + this.mCommands.get(cmd).getUsage() + "]");
        }
    }
}

