/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.postgres.PostgresBatchAction;
import org.apache.cayenne.dba.postgres.PostgresProcedureAction;
import org.apache.cayenne.dba.postgres.PostgresSelectAction;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;

class PostgresActionBuilder
extends JdbcActionBuilder {
    public PostgresActionBuilder(DataNode dataNode) {
        super(dataNode);
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.dataNode.getAdapter().supportsBatchUpdates();
        return new PostgresBatchAction(query, this.dataNode, runningAsBatch);
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new PostgresProcedureAction(query, this.dataNode);
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new PostgresSelectAction(query, this.dataNode);
    }

    @Override
    public <T> SQLAction objectSelectAction(FluentSelect<T> query) {
        return new PostgresSelectAction(query, this.dataNode);
    }
}

