/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import java.util.Objects;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.map.DbEntity;

public class TableNode
extends Node {
    private final DbEntity dbEntity;
    private final String tableName;
    private final String alias;

    public TableNode(String tableName, String alias) {
        this.dbEntity = null;
        this.tableName = Objects.requireNonNull(tableName);
        this.alias = alias;
    }

    public TableNode(DbEntity dbEntity, String alias) {
        this.dbEntity = Objects.requireNonNull(dbEntity);
        this.tableName = null;
        this.alias = alias;
    }

    @Override
    public QuotingAppendable append(QuotingAppendable buffer) {
        buffer.append(' ');
        if (this.dbEntity != null) {
            if (this.dbEntity.getCatalog() != null) {
                buffer.appendQuoted(this.dbEntity.getCatalog()).append('.');
            }
            if (this.dbEntity.getSchema() != null) {
                buffer.appendQuoted(this.dbEntity.getSchema()).append('.');
            }
            buffer.appendQuoted(this.dbEntity.getName());
        } else {
            buffer.appendQuoted(this.tableName);
        }
        if (this.alias != null) {
            buffer.append(' ').appendQuoted(this.alias);
        }
        return buffer;
    }

    @Override
    public Node copy() {
        return new TableNode(this.tableName, this.alias);
    }
}

