/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.retry;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.retry.ExponentialBackoffRetryPolicy;
import org.apache.cassandra.sidecar.client.retry.RetryAction;
import org.apache.cassandra.sidecar.common.request.Request;
import org.jetbrains.annotations.VisibleForTesting;

public class IgnoreConflictRetryPolicy
extends ExponentialBackoffRetryPolicy {
    @VisibleForTesting
    IgnoreConflictRetryPolicy() {
    }

    public IgnoreConflictRetryPolicy(int maxRetries, long retryDelayMillis, long maxRetryDelayMillis) {
        super(maxRetries, retryDelayMillis, maxRetryDelayMillis);
    }

    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (response != null && response.statusCode() == HttpResponseStatus.CONFLICT.code()) {
            responseFuture.complete(response);
        } else {
            super.onResponse(responseFuture, request, response, throwable, attempts, canRetryOnADifferentHost, retryAction);
        }
    }
}

