/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.schemastore;

import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.CdcBridgeFactory;
import org.apache.cassandra.cdc.api.SchemaSupplier;
import org.apache.cassandra.cdc.avro.AvroSchemas;
import org.apache.cassandra.cdc.avro.CqlToAvroSchemaConverter;
import org.apache.cassandra.cdc.kafka.KafkaOptions;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.cdc.schemastore.SchemaStorePublisherFactory;
import org.apache.cassandra.cdc.schemastore.SchemaStoreStats;
import org.apache.cassandra.cdc.schemastore.TableSchemaPublisher;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.utils.TableIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingSchemaStore
implements SchemaStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingSchemaStore.class);
    private final Map<TableIdentifier, SchemaCacheEntry> avroSchemasCache = new ConcurrentHashMap<TableIdentifier, SchemaCacheEntry>();
    @Nullable
    volatile TableSchemaPublisher publisher;
    private final SchemaSupplier schemaSupplier;
    private final Supplier<CassandraVersion> cassandraVersionSupplier;
    private final SchemaStorePublisherFactory schemaStorePublisherFactory;
    private final KafkaOptions kafkaOptions;
    private final SchemaStoreStats schemaStoreStats;

    public CachingSchemaStore(SchemaStoreStats schemaStoreStats, Supplier<CassandraVersion> cassandraVersionSupplier, SchemaSupplier schemaSupplier, SchemaStorePublisherFactory schemaStorePublisherFactory, KafkaOptions kafkaOptions) {
        this.cassandraVersionSupplier = cassandraVersionSupplier;
        this.schemaSupplier = schemaSupplier;
        this.schemaStorePublisherFactory = schemaStorePublisherFactory;
        this.kafkaOptions = kafkaOptions;
        this.schemaStoreStats = schemaStoreStats;
        AvroSchemas.registerLogicalTypes();
    }

    public void initialize() {
        LOGGER.info("Initializing CachingSchemaStore");
        this.schemaSupplier.getCdcEnabledTables().thenAccept(refreshedCdcTables -> {
            this.loadPublisher();
            this.publishSchemas();
            LOGGER.info("CachingSchemaStore initialized");
        });
    }

    public void onConfigChange() {
        LOGGER.info("Services configuration changed. Reloading publisher...");
        this.loadPublisher();
        this.publishSchemas();
    }

    public void onSchemaChange() {
        this.schemaSupplier.getCdcEnabledTables().thenAccept(refreshedCdcTables -> {
            for (CqlTable cqlTable2 : refreshedCdcTables) {
                TableIdentifier tableIdentifier = TableIdentifier.of((String)cqlTable2.keyspace(), (String)cqlTable2.table());
                this.avroSchemasCache.compute(tableIdentifier, (key, value) -> {
                    if (value == null || !value.tableSchema().equals(cqlTable2.createStatement())) {
                        LOGGER.info("Re-generating Avro Schema after schema change keyspace={} table={}", (Object)tableIdentifier.keyspace(), (Object)tableIdentifier.table());
                        return new SchemaCacheEntry(this.schemaConverter().convert(cqlTable2), cqlTable2);
                    }
                    return value;
                });
                this.publishSchemas();
            }
            List refreshedTableIds = refreshedCdcTables.stream().map(cqlTable -> TableIdentifier.of((String)cqlTable.keyspace(), (String)cqlTable.table())).collect(Collectors.toList());
            this.avroSchemasCache.keySet().retainAll(refreshedTableIds);
        });
    }

    private synchronized void loadPublisher() {
        TableSchemaPublisher publisherRef = this.publisher;
        if (publisherRef != null) {
            try {
                publisherRef.close();
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to shut down schema publisher", (Throwable)exception);
            }
        }
        this.publisher = this.schemaStorePublisherFactory.buildPublisher(this.kafkaOptions);
    }

    @NotNull
    protected CqlToAvroSchemaConverter schemaConverter() {
        return Objects.requireNonNull(CdcBridgeFactory.getCqlToAvroSchemaConverter((CassandraVersion)this.cassandraVersionSupplier.get()), "CqlToAvroSchemaConverter could not be found by the CdcBridgeFactory");
    }

    private void publishSchemas() {
        ((CompletableFuture)this.schemaSupplier.getCdcEnabledTables().thenAccept(refreshedCdcTables -> {
            for (CqlTable cqlTable : refreshedCdcTables) {
                TableIdentifier tableIdentifier = TableIdentifier.of((String)cqlTable.keyspace(), (String)cqlTable.table());
                this.avroSchemasCache.compute(tableIdentifier, (key, value) -> {
                    Schema schema = this.schemaConverter().convert(cqlTable);
                    TableSchemaPublisher publisherRef = this.publisher;
                    if (publisherRef != null) {
                        TableSchemaPublisher.SchemaPublishMetadata metadata = new TableSchemaPublisher.SchemaPublishMetadata();
                        metadata.put("name", cqlTable.table());
                        metadata.put("namespace", cqlTable.keyspace());
                        publisherRef.publishSchema(schema.toString(), metadata);
                        this.schemaStoreStats.capturePublishedSchema();
                    }
                    return new SchemaCacheEntry(schema, cqlTable);
                });
            }
        })).whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                LOGGER.warn("Failed to publish Avro schemas", throwable);
            }
        });
    }

    @Override
    public Schema getSchema(String namespace, String name) {
        TableIdentifier tableIdentifier = this.getTableIdentifierFromNamespace(namespace);
        return this.avroSchemasCache.computeIfAbsent((TableIdentifier)tableIdentifier, (Function<TableIdentifier, SchemaCacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getSchema$7(org.apache.cassandra.spark.utils.TableIdentifier org.apache.cassandra.spark.utils.TableIdentifier ), (Lorg/apache/cassandra/spark/utils/TableIdentifier;)Lorg/apache/cassandra/cdc/schemastore/CachingSchemaStore$SchemaCacheEntry;)((TableIdentifier)tableIdentifier)).schema;
    }

    @Override
    public GenericDatumWriter<GenericRecord> getWriter(String namespace, String name) {
        TableIdentifier tableIdentifier = this.getTableIdentifierFromNamespace(namespace);
        return this.avroSchemasCache.computeIfAbsent((TableIdentifier)tableIdentifier, (Function<TableIdentifier, SchemaCacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getWriter$8(org.apache.cassandra.spark.utils.TableIdentifier org.apache.cassandra.spark.utils.TableIdentifier ), (Lorg/apache/cassandra/spark/utils/TableIdentifier;)Lorg/apache/cassandra/cdc/schemastore/CachingSchemaStore$SchemaCacheEntry;)((TableIdentifier)tableIdentifier)).writer;
    }

    @Override
    public GenericDatumReader<GenericRecord> getReader(String namespace, String name) {
        TableIdentifier tableIdentifier = this.getTableIdentifierFromNamespace(namespace);
        return this.avroSchemasCache.computeIfAbsent((TableIdentifier)tableIdentifier, (Function<TableIdentifier, SchemaCacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getReader$9(org.apache.cassandra.spark.utils.TableIdentifier org.apache.cassandra.spark.utils.TableIdentifier ), (Lorg/apache/cassandra/spark/utils/TableIdentifier;)Lorg/apache/cassandra/cdc/schemastore/CachingSchemaStore$SchemaCacheEntry;)((TableIdentifier)tableIdentifier)).reader;
    }

    @Override
    public String getVersion(String namespace, String name) {
        TableIdentifier tableIdentifier = this.getTableIdentifierFromNamespace(namespace);
        return this.avroSchemasCache.computeIfAbsent((TableIdentifier)tableIdentifier, (Function<TableIdentifier, SchemaCacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getVersion$10(org.apache.cassandra.spark.utils.TableIdentifier org.apache.cassandra.spark.utils.TableIdentifier ), (Lorg/apache/cassandra/spark/utils/TableIdentifier;)Lorg/apache/cassandra/cdc/schemastore/CachingSchemaStore$SchemaCacheEntry;)((TableIdentifier)tableIdentifier)).schemaUuid;
    }

    public Map<String, Schema> getSchemas() {
        return this.avroSchemasCache.values().stream().collect(Collectors.toMap(entry -> entry.schema.getNamespace(), entry -> entry.schema));
    }

    private TableIdentifier getTableIdentifierFromNamespace(String namespace) {
        String[] namespaceParts = namespace.split("\\.");
        return TableIdentifier.of((String)namespaceParts[0], (String)namespaceParts[1]);
    }

    private static /* synthetic */ SchemaCacheEntry lambda$getVersion$10(TableIdentifier tableIdentifier, TableIdentifier k) {
        LOGGER.warn("Unknown table for getting reader keyspace={} table={}", (Object)tableIdentifier.keyspace(), (Object)tableIdentifier.table());
        throw new RuntimeException("Unable to get reader for unknown table " + String.valueOf(tableIdentifier));
    }

    private static /* synthetic */ SchemaCacheEntry lambda$getReader$9(TableIdentifier tableIdentifier, TableIdentifier k) {
        LOGGER.warn("Unknown table for getting reader keyspace={} table={}", (Object)tableIdentifier.keyspace(), (Object)tableIdentifier.table());
        throw new RuntimeException("Unable to get reader for unknown table " + String.valueOf(tableIdentifier));
    }

    private static /* synthetic */ SchemaCacheEntry lambda$getWriter$8(TableIdentifier tableIdentifier, TableIdentifier k) {
        LOGGER.warn("Unknown table for getting writer keyspace={} table={}", (Object)tableIdentifier.keyspace(), (Object)tableIdentifier.table());
        throw new RuntimeException("Unable to get writer for unknown table " + String.valueOf(tableIdentifier));
    }

    private static /* synthetic */ SchemaCacheEntry lambda$getSchema$7(TableIdentifier tableIdentifier, TableIdentifier k) {
        LOGGER.warn("Unknown table for getting schema keyspace={} table={}", (Object)tableIdentifier.keyspace(), (Object)tableIdentifier.table());
        throw new RuntimeException("Unable to get schema for unknown table " + String.valueOf(tableIdentifier));
    }

    private static class SchemaCacheEntry {
        private final CqlTable table;
        private final Schema schema;
        private final String schemaUuid;
        private final GenericDatumWriter<GenericRecord> writer;
        private final GenericDatumReader<GenericRecord> reader;

        private SchemaCacheEntry(Schema schema, CqlTable table) {
            this.table = table;
            this.schema = schema;
            this.schemaUuid = UUID.nameUUIDFromBytes(table.createStatement().getBytes(StandardCharsets.UTF_8)).toString();
            this.writer = new GenericDatumWriter(schema);
            this.reader = new GenericDatumReader(schema);
        }

        public String tableSchema() {
            return this.table.createStatement();
        }
    }
}

