/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.cassandra.bridge.BigNumberConfigImpl;
import org.apache.cassandra.spark.config.SchemaFeature;
import org.apache.cassandra.spark.config.SchemaFeatureSet;
import org.apache.cassandra.spark.data.CassandraDataLayer;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;
import org.apache.cassandra.spark.sparksql.filters.SSTableTimeRangeFilter;
import org.apache.cassandra.spark.utils.FilterUtils;
import org.apache.cassandra.spark.utils.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfig {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Deprecated
    public static final String SIDECAR_INSTANCES = "sidecar_contact_points";
    public static final String SIDECAR_CONTACT_POINTS = "sidecar_contact_points";
    public static final String KEYSPACE_KEY = "keyspace";
    public static final String TABLE_KEY = "table";
    public static final String SNAPSHOT_NAME_KEY = "snapshotName";
    public static final String DC_KEY = "dc";
    public static final String CREATE_SNAPSHOT_KEY = "createSnapshot";
    public static final String CLEAR_SNAPSHOT_KEY = "clearSnapshot";
    public static final String CLEAR_SNAPSHOT_STRATEGY_KEY = "clearSnapshotStrategy";
    public static final String DEFAULT_SNAPSHOT_TTL_VALUE = "2d";
    public static final String SNAPSHOT_TTL_PATTERN = "\\d+(d|h|m|s)";
    public static final String DEFAULT_PARALLELISM_KEY = "defaultParallelism";
    public static final String NUM_CORES_KEY = "numCores";
    public static final String CONSISTENCY_LEVEL_KEY = "consistencyLevel";
    public static final String ENABLE_STATS_KEY = "enableStats";
    public static final String LAST_MODIFIED_COLUMN_NAME_KEY = "lastModifiedColumnName";
    public static final String READ_INDEX_OFFSET_KEY = "readIndexOffset";
    public static final String SIZING_KEY = "sizing";
    public static final String SIZING_DEFAULT = "default";
    public static final String SIZING_DYNAMIC = "dynamic";
    public static final String MAX_PARTITION_SIZE_KEY = "maxPartitionSize";
    public static final String USE_INCREMENTAL_REPAIR = "useIncrementalRepair";
    public static final String ENABLE_EXPANSION_SHRINK_CHECK_KEY = "enableExpansionShrinkCheck";
    public static final String SIDECAR_PORT = "sidecar_port";
    public static final String QUOTE_IDENTIFIERS = "quote_identifiers";
    public static final String SSTABLE_START_TIMESTAMP_MICROS = "sstable_start_timestamp_micros";
    public static final String SSTABLE_END_TIMESTAMP_MICROS = "sstable_end_timestamp_micros";
    public static final int DEFAULT_SIDECAR_PORT = 9043;
    protected String sidecarContactPoints;
    @Nullable
    protected String keyspace;
    @Nullable
    protected String table;
    protected String snapshotName;
    protected String datacenter;
    protected boolean createSnapshot;
    protected boolean clearSnapshot;
    protected ClearSnapshotStrategy clearSnapshotStrategy;
    protected int defaultParallelism;
    protected int numCores;
    protected ConsistencyLevel consistencyLevel;
    protected Map<String, BigNumberConfigImpl> bigNumberConfigMap;
    protected boolean enableStats;
    protected boolean readIndexOffset;
    protected String sizing;
    protected int maxPartitionSize;
    protected boolean useIncrementalRepair;
    protected List<SchemaFeature> requestedFeatures;
    protected String lastModifiedTimestampField;
    protected Boolean enableExpansionShrinkCheck;
    protected int sidecarPort;
    protected boolean quoteIdentifiers;
    protected SSTableTimeRangeFilter sstableTimeRangeFilter;

    protected ClientConfig(Map<String, String> options) {
        this.sidecarContactPoints = this.parseSidecarContactPoints(options);
        this.keyspace = MapUtils.getOrThrow(options, (String)KEYSPACE_KEY, (String)KEYSPACE_KEY);
        this.table = MapUtils.getOrThrow(options, (String)TABLE_KEY, (String)TABLE_KEY);
        this.snapshotName = MapUtils.getOrDefault(options, (String)SNAPSHOT_NAME_KEY, (String)("sbr_" + UUID.randomUUID().toString().replace("-", "")));
        this.datacenter = options.get(MapUtils.lowerCaseKey((String)DC_KEY));
        this.createSnapshot = MapUtils.getBoolean(options, (String)CREATE_SNAPSHOT_KEY, (boolean)true);
        this.clearSnapshot = MapUtils.getBoolean(options, (String)CLEAR_SNAPSHOT_KEY, (boolean)this.createSnapshot);
        String clearSnapshotStrategyOption = MapUtils.getOrDefault(options, (String)CLEAR_SNAPSHOT_STRATEGY_KEY, null);
        this.clearSnapshotStrategy = this.parseClearSnapshotStrategy(MapUtils.containsKey(options, (String)CLEAR_SNAPSHOT_KEY), this.clearSnapshot, clearSnapshotStrategyOption);
        this.defaultParallelism = MapUtils.getInt(options, (String)DEFAULT_PARALLELISM_KEY, (int)1);
        this.numCores = MapUtils.getInt(options, (String)NUM_CORES_KEY, (int)1);
        this.consistencyLevel = Optional.ofNullable(options.get(MapUtils.lowerCaseKey((String)CONSISTENCY_LEVEL_KEY))).map(ConsistencyLevel::valueOf).orElse(null);
        this.bigNumberConfigMap = BigNumberConfigImpl.build(options);
        this.enableStats = MapUtils.getBoolean(options, (String)ENABLE_STATS_KEY, (boolean)true);
        this.readIndexOffset = MapUtils.getBoolean(options, (String)READ_INDEX_OFFSET_KEY, (boolean)true);
        this.sizing = MapUtils.getOrDefault(options, (String)SIZING_KEY, (String)SIZING_DEFAULT);
        this.maxPartitionSize = MapUtils.getInt(options, (String)MAX_PARTITION_SIZE_KEY, (int)1);
        this.useIncrementalRepair = MapUtils.getBoolean(options, (String)USE_INCREMENTAL_REPAIR, (boolean)true);
        this.lastModifiedTimestampField = MapUtils.getOrDefault(options, (String)LAST_MODIFIED_COLUMN_NAME_KEY, null);
        this.enableExpansionShrinkCheck = MapUtils.getBoolean(options, (String)ENABLE_EXPANSION_SHRINK_CHECK_KEY, (boolean)false);
        this.requestedFeatures = this.initRequestedFeatures(options);
        this.sidecarPort = MapUtils.getInt(options, (String)SIDECAR_PORT, (int)9043);
        this.quoteIdentifiers = MapUtils.getBoolean(options, (String)QUOTE_IDENTIFIERS, (boolean)false);
        this.sstableTimeRangeFilter = FilterUtils.parseSSTableTimeRangeFilter(options);
    }

    protected String parseSidecarContactPoints(Map<String, String> options) {
        return (String)MapUtils.resolveDeprecated(options, (String)"sidecar_contact_points", (String)"sidecar_contact_points", option -> {
            if (option == null) {
                throw (RuntimeException)MapUtils.throwable((String)"sidecar_contact_points or sidecar_contact_points").get();
            }
            return MapUtils.getOrThrow((Map)options, (String)option);
        });
    }

    protected ClearSnapshotStrategy parseClearSnapshotStrategy(boolean hasDeprecatedOption, boolean clearSnapshot, String clearSnapshotStrategyOption) {
        if (hasDeprecatedOption) {
            this.logger.warn("The deprecated option 'clearSnapshot' is set. Please set 'clearSnapshotStrategy' instead.");
            if (clearSnapshotStrategyOption == null) {
                return clearSnapshot ? ClearSnapshotStrategy.defaultStrategy() : new ClearSnapshotStrategy.NoOp();
            }
        }
        return ClearSnapshotStrategy.parse(clearSnapshotStrategyOption);
    }

    public String sidecarContactPoints() {
        return this.sidecarContactPoints;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String table() {
        return this.table;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String datacenter() {
        return this.datacenter;
    }

    public boolean createSnapshot() {
        return this.createSnapshot;
    }

    public boolean clearSnapshot() {
        return this.clearSnapshot;
    }

    public ClearSnapshotStrategy clearSnapshotStrategy() {
        return this.clearSnapshotStrategy;
    }

    public int defaultParallelism() {
        return this.defaultParallelism;
    }

    public int numCores() {
        return this.numCores;
    }

    public ConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public Map<String, BigNumberConfigImpl> bigNumberConfigMap() {
        return this.bigNumberConfigMap;
    }

    public boolean enableStats() {
        return this.enableStats;
    }

    public boolean readIndexOffset() {
        return this.readIndexOffset;
    }

    public String sizing() {
        return this.sizing;
    }

    public int maxPartitionSize() {
        return this.maxPartitionSize;
    }

    public boolean useIncrementalRepair() {
        return this.useIncrementalRepair;
    }

    public List<SchemaFeature> requestedFeatures() {
        return this.requestedFeatures;
    }

    public String lastModifiedTimestampField() {
        return this.lastModifiedTimestampField;
    }

    public Boolean enableExpansionShrinkCheck() {
        return this.enableExpansionShrinkCheck;
    }

    public int sidecarPort() {
        return this.sidecarPort;
    }

    public boolean quoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    public SSTableTimeRangeFilter sstableTimeRangeFilter() {
        return this.sstableTimeRangeFilter;
    }

    public static ClientConfig create(Map<String, String> options) {
        return new ClientConfig(options);
    }

    protected List<SchemaFeature> initRequestedFeatures(Map<String, String> options) {
        HashMap<String, String> optionsCopy = new HashMap<String, String>(options);
        String lastModifiedColumnName = MapUtils.getOrDefault(options, (String)LAST_MODIFIED_COLUMN_NAME_KEY, null);
        if (lastModifiedColumnName != null) {
            optionsCopy.put(SchemaFeatureSet.LAST_MODIFIED_TIMESTAMP.optionName(), "true");
        }
        List requestedFeatures = SchemaFeatureSet.initializeFromOptions(optionsCopy);
        if (lastModifiedColumnName != null) {
            CassandraDataLayer.aliasLastModifiedTimestamp(requestedFeatures, lastModifiedColumnName);
        }
        return requestedFeatures;
    }

    public static abstract class ClearSnapshotStrategy {
        private static final Logger logger = LoggerFactory.getLogger(ClearSnapshotStrategy.class);
        private final String snapshotTTL;

        public ClearSnapshotStrategy(String snapshotTTL) {
            this.snapshotTTL = snapshotTTL;
        }

        public abstract boolean shouldClearOnCompletion();

        protected void validateTTLPresence(boolean expectTTL) {
            if (expectTTL && !this.hasTTL()) {
                throw new IllegalArgumentException("Incorrect value set for clearSnapshotStrategy, expected format is {strategy [snapshotTTLvalue]}. TTL value specified must contain unit along. For e.g. 2d represents a TTL for 2 days. Allowed units are d, h, m and s.");
            }
        }

        public boolean hasTTL() {
            return this.snapshotTTL != null && !this.snapshotTTL.isEmpty();
        }

        @Nullable
        public String ttl() {
            return this.snapshotTTL;
        }

        public String toString() {
            return this.getClass().getSimpleName() + (String)(this.hasTTL() ? " " + this.ttl() : "");
        }

        public static ClearSnapshotStrategy parse(String clearSnapshotStrategyOption) {
            String strategyName;
            if (clearSnapshotStrategyOption == null) {
                logger.debug("No clearSnapshotStrategy is set. Using the default strategy");
                return ClearSnapshotStrategy.defaultStrategy();
            }
            String[] strategyParts = clearSnapshotStrategyOption.split(" ", 2);
            String snapshotTTL = null;
            if (strategyParts.length == 1) {
                strategyName = strategyParts[0].trim();
            } else if (strategyParts.length == 2) {
                strategyName = strategyParts[0].trim();
                snapshotTTL = strategyParts[1].trim();
                if (!Pattern.matches(ClientConfig.SNAPSHOT_TTL_PATTERN, snapshotTTL)) {
                    String msg = "Incorrect value set for clearSnapshotStrategy, expected format is {strategy [snapshotTTLvalue]}. TTL value specified must contain unit along. For e.g. 2d represents a TTL for 2 days. Allowed units are d, h, m and s.";
                    throw new IllegalArgumentException(msg);
                }
            } else {
                logger.error("Invalid value for ClearSnapshotStrategy: '{}'", (Object)clearSnapshotStrategyOption);
                throw new IllegalArgumentException("Invalid value: " + clearSnapshotStrategyOption);
            }
            return ClearSnapshotStrategy.create(strategyName, snapshotTTL);
        }

        public static ClearSnapshotStrategy create(String name, String snapshotTTL) {
            String stripped = name.trim();
            if (stripped.equalsIgnoreCase(OnCompletion.class.getSimpleName())) {
                return new OnCompletion();
            }
            if (stripped.equalsIgnoreCase(TTL.class.getSimpleName())) {
                return new TTL(snapshotTTL);
            }
            if (stripped.equalsIgnoreCase(OnCompletionOrTTL.class.getSimpleName())) {
                return new OnCompletionOrTTL(snapshotTTL);
            }
            if (stripped.equalsIgnoreCase(NoOp.class.getSimpleName())) {
                return new NoOp();
            }
            ClearSnapshotStrategy defaultStrategy = ClearSnapshotStrategy.defaultStrategy();
            logger.warn("Unknown ClearSnapshotStrategy {} is passed. Fall back to default strategy {}.", (Object)name, (Object)defaultStrategy);
            throw new IllegalArgumentException("Invalid ClearSnapshotStrategy " + name + " passed");
        }

        public static ClearSnapshotStrategy defaultStrategy() {
            logger.info("A default TTL value of {} is added to the snapshot. If the job takes longer than {}, the snapshot will be cleared before job completion leading to errors.", (Object)ClientConfig.DEFAULT_SNAPSHOT_TTL_VALUE, (Object)ClientConfig.DEFAULT_SNAPSHOT_TTL_VALUE);
            return new OnCompletionOrTTL(ClientConfig.DEFAULT_SNAPSHOT_TTL_VALUE);
        }

        public static class TTL
        extends ClearSnapshotStrategy {
            public TTL(@NotNull String snapshotTTL) {
                super(snapshotTTL);
                this.validateTTLPresence(true);
            }

            @Override
            public boolean shouldClearOnCompletion() {
                return false;
            }
        }

        public static class OnCompletionOrTTL
        extends ClearSnapshotStrategy {
            public OnCompletionOrTTL(@NotNull String snapshotTTL) {
                super(snapshotTTL);
                this.validateTTLPresence(true);
            }

            @Override
            public boolean shouldClearOnCompletion() {
                return true;
            }
        }

        public static class NoOp
        extends ClearSnapshotStrategy {
            public NoOp() {
                super(null);
            }

            @Override
            public boolean shouldClearOnCompletion() {
                return false;
            }
        }

        public static class OnCompletion
        extends ClearSnapshotStrategy {
            public OnCompletion() {
                super(null);
            }

            @Override
            public boolean shouldClearOnCompletion() {
                return true;
            }
        }
    }
}

