/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import org.apache.cassandra.spark.bulkwriter.cloudstorage.Bundle;
import org.apache.cassandra.spark.common.DataObjectBuilder;

public class BundleStorageObject {
    public final String storageObjectKey;
    public final String storageObjectChecksum;
    public final Bundle bundle;

    static Builder builder() {
        return new Builder();
    }

    protected BundleStorageObject(Builder builder) {
        this.storageObjectChecksum = builder.storageObjectChecksum;
        this.storageObjectKey = builder.storageObjectKey;
        this.bundle = builder.bundle;
    }

    public String toString() {
        return "Bundle{manifest: " + String.valueOf(this.bundle) + ", storageObjectKey: " + this.storageObjectKey + ", storageObjectChecksum: " + this.storageObjectChecksum + "}";
    }

    static class Builder
    implements DataObjectBuilder<Builder, BundleStorageObject> {
        private String storageObjectChecksum;
        private String storageObjectKey;
        private Bundle bundle;

        Builder() {
        }

        public Builder storageObjectChecksum(String bundleChecksum) {
            return this.with(b -> {
                b.storageObjectChecksum = bundleChecksum;
            });
        }

        public Builder storageObjectKey(String storageObjectKey) {
            return this.with(b -> {
                b.storageObjectKey = storageObjectKey;
            });
        }

        public Builder bundle(Bundle bundle) {
            return this.with(b -> {
                b.bundle = bundle;
            });
        }

        @Override
        public BundleStorageObject build() {
            return new BundleStorageObject(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

