/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.bridge.CassandraBridgeImplementation;
import org.apache.cassandra.bridge.SSTableDescriptor;
import org.apache.cassandra.bridge.SSTableWriter;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class SSTableWriterImplementation
implements SSTableWriter {
    private final CQLSSTableWriter writer;
    private Consumer<Set<SSTableDescriptor>> producedSSTablesListener;

    public SSTableWriterImplementation(String inDirectory, String partitioner, String createStatement, String insertStatement, @NotNull Set<String> userDefinedTypeStatements, int bufferSizeMB) {
        this(inDirectory, SSTableWriterImplementation.determineSupportedPartitioner(partitioner), createStatement, insertStatement, userDefinedTypeStatements, bufferSizeMB);
    }

    @VisibleForTesting
    public SSTableWriterImplementation(String inDirectory, IPartitioner partitioner, String createStatement, String insertStatement, @NotNull Set<String> userDefinedTypeStatements, int bufferSizeMB) {
        this.writer = SSTableWriterImplementation.configureBuilder(inDirectory, createStatement, insertStatement, bufferSizeMB, userDefinedTypeStatements, this::onSSTablesProduced, partitioner).build();
    }

    private static IPartitioner determineSupportedPartitioner(String partitioner) {
        return partitioner.toLowerCase().contains("random") ? new RandomPartitioner() : new Murmur3Partitioner();
    }

    private void onSSTablesProduced(Collection<SSTableReader> sstables) {
        Objects.requireNonNull(this.producedSSTablesListener, "producedSSTablesListener is not set");
        Set sstableDescriptors = sstables.stream().map(sstable -> {
            String baseFilename = CassandraBridgeImplementation.baseFilename(sstable.descriptor);
            sstable.selfRef().close();
            return new SSTableDescriptor(baseFilename);
        }).collect(Collectors.toSet());
        this.producedSSTablesListener.accept(sstableDescriptors);
    }

    public void addRow(Map<String, Object> values) throws IOException {
        try {
            this.writer.addRow(values);
        }
        catch (InvalidRequestException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setSSTablesProducedListener(Consumer<Set<SSTableDescriptor>> listener) {
        this.producedSSTablesListener = Objects.requireNonNull(listener);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    @VisibleForTesting
    static CQLSSTableWriter.Builder configureBuilder(String inDirectory, String createStatement, String insertStatement, int bufferSizeMB, Set<String> udts, Consumer<Collection<SSTableReader>> producedSSTablesListener, IPartitioner cassPartitioner) {
        CQLSSTableWriter.Builder builder = CQLSSTableWriter.builder();
        for (String udt : udts) {
            builder.withType(udt);
        }
        return builder.inDirectory(inDirectory).forTable(createStatement).withPartitioner(cassPartitioner).using(insertStatement).sorted().withSSTableProducedListener(producedSSTablesListener).openSSTableOnProduced().withMaxSSTableSizeInMiB(bufferSizeMB);
    }

    static {
        Config.setClientMode((boolean)true);
    }
}

