/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraSchema;
import org.apache.cassandra.bridge.CdcBridge;
import org.apache.cassandra.bridge.CollectionElement;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.FourZeroMutation;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.api.CommitLogInstance;
import org.apache.cassandra.cdc.api.CommitLogMarkers;
import org.apache.cassandra.cdc.api.CommitLogReader;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.cdc.api.Mutation;
import org.apache.cassandra.cdc.api.RangeTombstoneData;
import org.apache.cassandra.cdc.api.Row;
import org.apache.cassandra.cdc.api.TableIdLookup;
import org.apache.cassandra.cdc.scanner.CdcSortedStreamScanner;
import org.apache.cassandra.cdc.scanner.CdcStreamScanner;
import org.apache.cassandra.cdc.state.CdcState;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.commitlog.BufferingCommitLogReader;
import org.apache.cassandra.db.commitlog.FourZeroPartitionUpdateWrapper;
import org.apache.cassandra.db.commitlog.PartitionUpdateWrapper;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCdcBridgeImplementation
extends CdcBridge {
    public void log(CqlTable cqlTable, CommitLogInstance log, Row row, long timestamp) {
        this.log(TimeProvider.DEFAULT, cqlTable, log, row, timestamp);
    }

    public void updateCdcSchema(@NotNull Set<CqlTable> cdcTables, @NotNull Partitioner partitioner, @NotNull TableIdLookup tableIdLookup) {
        CassandraSchema.updateCdcSchema(cdcTables, (Partitioner)partitioner, (TableIdLookup)tableIdLookup);
    }

    public CommitLogReader.Result readLog(@NotNull CommitLog log, @Nullable TokenRange tokenRange, @NotNull CommitLogMarkers markers, int partitionId, @NotNull ICdcStats stats, @Nullable AsyncExecutor executor, @Nullable Consumer<Marker> listener, @Nullable Long startTimestampMicros, boolean readCommitLogHeader) {
        try (BufferingCommitLogReader reader = new BufferingCommitLogReader(log, tokenRange, markers, partitionId, stats, executor, null, startTimestampMicros, readCommitLogHeader);){
            CommitLogReader.Result result = reader.result();
            return result;
        }
    }

    public CdcStreamScanner openCdcStreamScanner(Collection<PartitionUpdateWrapper> updates, @NotNull CdcState endState, Random random, CassandraSource cassandraSource, double traceSampleRate) {
        return new CdcSortedStreamScanner(updates.stream().map(a -> (FourZeroPartitionUpdateWrapper)((Object)a)).collect(Collectors.toList()), endState, ThreadLocalRandom.current(), cassandraSource, traceSampleRate);
    }

    @VisibleForTesting
    public void log(TimeProvider timeProvider, CqlTable cqlTable, CommitLogInstance log, Row row, long timestamp) {
        org.apache.cassandra.db.Mutation mutation = AbstractCdcBridgeImplementation.makeMutation(timeProvider, cqlTable, row, timestamp);
        log.add((Mutation)FourZeroMutation.wrap(mutation));
    }

    @NotNull
    @VisibleForTesting
    public static org.apache.cassandra.db.Mutation makeMutation(TimeProvider timeProvider, CqlTable cqlTable, Row row, long timestamp) {
        TableMetadata table = Schema.instance.getTableMetadata(cqlTable.keyspace(), cqlTable.table());
        assert (table != null);
        Row.Builder rowBuilder = BTreeRow.sortedBuilder();
        if (row.isInsert()) {
            rowBuilder.addPrimaryKeyLivenessInfo(LivenessInfo.create((long)timestamp, (int)timeProvider.nowInSeconds()));
        }
        org.apache.cassandra.db.rows.Row staticRow = Rows.EMPTY_STATIC_ROW;
        List partitionKeys = cqlTable.partitionKeys();
        ByteBuffer partitionKey = ByteBufferUtils.buildPartitionKey((List)partitionKeys, (Object[])partitionKeys.stream().map(f -> row.get(f.position())).toArray());
        DecoratedKey decoratedPartitionKey = table.partitioner.decorateKey(partitionKey);
        if (AbstractCdcBridgeImplementation.isPartitionDeletion(cqlTable, row)) {
            PartitionUpdate delete = PartitionUpdate.fullPartitionDelete((TableMetadata)table, (ByteBuffer)partitionKey, (long)timestamp, (int)timeProvider.nowInSeconds());
            return new org.apache.cassandra.db.Mutation(delete);
        }
        List clusteringKeys = cqlTable.clusteringKeys();
        if (row.rangeTombstones() != null && !row.rangeTombstones().isEmpty()) {
            return AbstractCdcBridgeImplementation.makeRangeTombstone(cqlTable, table, decoratedPartitionKey, timestamp, timeProvider, row);
        }
        boolean noRegularRow = false;
        if (clusteringKeys.isEmpty()) {
            rowBuilder.newRow(Clustering.EMPTY);
        } else if (clusteringKeys.stream().allMatch(f -> row.get(f.position()) == null)) {
            noRegularRow = true;
        } else {
            rowBuilder.newRow(Clustering.make((ByteBuffer[])((ByteBuffer[])clusteringKeys.stream().map(f -> f.serialize(row.get(f.position()))).toArray(ByteBuffer[]::new))));
        }
        if (row.isDeleted()) {
            rowBuilder.addRowDeletion(Row.Deletion.regular((DeletionTime)new DeletionTime(timestamp, timeProvider.nowInSeconds())));
        } else {
            BiConsumer<Row.Builder, CqlField> rowBuildFunc = (builder, field) -> {
                CqlType type = (CqlType)field.type();
                ColumnMetadata cd = table.getColumn(new ColumnIdentifier(field.name(), false));
                Object value = row.get(field.position());
                if (value != UNSET_MARKER) {
                    if (value == null) {
                        if (cd.isComplex()) {
                            type.addComplexTombstone(builder, cd, timestamp);
                        } else {
                            type.addTombstone(builder, cd, timestamp);
                        }
                    } else if (value instanceof CollectionElement) {
                        CollectionElement ce = (CollectionElement)value;
                        if (ce.value == null) {
                            type.addTombstone(builder, cd, timestamp, ce.cellPath);
                        } else {
                            type.addCell(builder, cd, timestamp, row.ttl(), timeProvider.nowInSeconds(), ce.value, ce.cellPath);
                        }
                    } else {
                        type.addCell(builder, cd, timestamp, row.ttl(), timeProvider.nowInSeconds(), value);
                    }
                }
            };
            if (!cqlTable.staticColumns().isEmpty()) {
                Row.Builder staticRowBuilder = BTreeRow.sortedBuilder();
                staticRowBuilder.newRow(Clustering.STATIC_CLUSTERING);
                for (CqlField field2 : cqlTable.staticColumns()) {
                    rowBuildFunc.accept(staticRowBuilder, field2);
                }
                staticRow = staticRowBuilder.build();
            }
            for (CqlField field3 : cqlTable.valueColumns()) {
                rowBuildFunc.accept(rowBuilder, field3);
            }
        }
        return new org.apache.cassandra.db.Mutation(PartitionUpdate.singleRowUpdate((TableMetadata)table, (DecoratedKey)decoratedPartitionKey, (org.apache.cassandra.db.rows.Row)(noRegularRow ? null : rowBuilder.build()), (org.apache.cassandra.db.rows.Row)staticRow));
    }

    protected static org.apache.cassandra.db.Mutation makeRangeTombstone(CqlTable cqlTable, TableMetadata table, DecoratedKey decoratedPartitionKey, long timestamp, TimeProvider timeProvider, Row row) {
        List clusteringKeys = cqlTable.clusteringKeys();
        PartitionUpdate.SimpleBuilder pub = PartitionUpdate.simpleBuilder((TableMetadata)table, (Object[])new Object[]{decoratedPartitionKey}).timestamp(timestamp).nowInSec(timeProvider.nowInSeconds());
        for (RangeTombstoneData rt : row.rangeTombstones()) {
            PartitionUpdate.SimpleBuilder.RangeTombstoneBuilder rangeTombstoneBuilder = pub.addRangeTombstone();
            rangeTombstoneBuilder = rt.open.inclusive ? rangeTombstoneBuilder.inclStart() : rangeTombstoneBuilder.exclStart();
            Object[] startValues = clusteringKeys.stream().map(f -> {
                Object v = rt.open.values[f.position() - cqlTable.numPartitionKeys()];
                return v == null ? null : f.serialize(v);
            }).filter(Objects::nonNull).toArray(ByteBuffer[]::new);
            rangeTombstoneBuilder.start(startValues);
            rangeTombstoneBuilder = rt.close.inclusive ? rangeTombstoneBuilder.inclEnd() : rangeTombstoneBuilder.exclEnd();
            Object[] endValues = clusteringKeys.stream().map(f -> {
                Object v = rt.close.values[f.position() - cqlTable.numPartitionKeys()];
                return v == null ? null : f.serialize(v);
            }).filter(Objects::nonNull).toArray(ByteBuffer[]::new);
            rangeTombstoneBuilder.end(endValues);
        }
        return new org.apache.cassandra.db.Mutation(pub.build());
    }

    @VisibleForTesting
    protected static boolean isPartitionDeletion(CqlTable cqlTable, Row row) {
        List clusteringKeys = cqlTable.clusteringKeys();
        List valueFields = cqlTable.valueColumns();
        List staticFields = cqlTable.staticColumns();
        for (CqlField f : Iterables.concat((Iterable)clusteringKeys, (Iterable)valueFields, (Iterable)staticFields)) {
            if (row.get(f.position()) == null) continue;
            return false;
        }
        return true;
    }
}

