/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.ICoordinator;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BulkReaderFilteringIntegrationTest
extends SharedClusterSparkIntegrationTestBase {
    static final int DATA_SIZE = 1000;
    QualifiedName twcsTable = TestUtils.uniqueTestTableFullName((String)"spark_test");
    QualifiedName lcsTable = TestUtils.uniqueTestTableFullName((String)"spark_test");
    static final long BASE_TIMESTAMP_MILLIS = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(10L);
    static final long EARLY_TIMESTAMP_MICROS = TimeUnit.MILLISECONDS.toMicros(BASE_TIMESTAMP_MILLIS);
    static final long MIDDLE_TIMESTAMP_MICROS = TimeUnit.MILLISECONDS.toMicros(BASE_TIMESTAMP_MILLIS + TimeUnit.MINUTES.toMillis(2L));
    static final long LATE_TIMESTAMP_MICROS = TimeUnit.MILLISECONDS.toMicros(BASE_TIMESTAMP_MILLIS + TimeUnit.MINUTES.toMillis(4L));

    BulkReaderFilteringIntegrationTest() {
    }

    @Test
    void testReadAllDataWithoutTimeRangeFilter() {
        Map<String, String> timeRangeOptions = Map.of();
        int expectedDataSize = 3000;
        Set<Long> expectedSSTableTimestamps = Set.of(Long.valueOf(EARLY_TIMESTAMP_MICROS), Long.valueOf(MIDDLE_TIMESTAMP_MICROS), Long.valueOf(LATE_TIMESTAMP_MICROS));
        this.runTimeRangeFilterTest(timeRangeOptions, expectedDataSize, expectedSSTableTimestamps);
    }

    @Test
    void testTimeRangeFilterWithStartBoundInclusive() {
        Map<String, String> timeRangeOptions = Map.of("sstable_start_timestamp_micros", Long.valueOf(MIDDLE_TIMESTAMP_MICROS).toString());
        int expectedDataSize = 2000;
        Set<Long> expectedSSTableTimestamps = Set.of(Long.valueOf(MIDDLE_TIMESTAMP_MICROS), Long.valueOf(LATE_TIMESTAMP_MICROS));
        this.runTimeRangeFilterTest(timeRangeOptions, expectedDataSize, expectedSSTableTimestamps);
    }

    @Test
    void testTimeRangeFilterWithStartBoundExclusive() {
        Map<String, String> timeRangeOptions = Map.of("sstable_start_timestamp_micros", Long.valueOf(LATE_TIMESTAMP_MICROS + 1L).toString());
        Set<Long> expectedSSTableTimestamps = Set.of(Long.valueOf(LATE_TIMESTAMP_MICROS));
        this.runTimeRangeFilterTest(timeRangeOptions, 1000, expectedSSTableTimestamps);
    }

    @Test
    void testTimeRangeFilterWithEndBoundInclusive() {
        Map<String, String> timeRangeOptions = Map.of("sstable_end_timestamp_micros", Long.valueOf(MIDDLE_TIMESTAMP_MICROS).toString());
        int expectedDataSize = 2000;
        Set<Long> expectedSSTableTimestamps = Set.of(Long.valueOf(EARLY_TIMESTAMP_MICROS), Long.valueOf(MIDDLE_TIMESTAMP_MICROS));
        this.runTimeRangeFilterTest(timeRangeOptions, expectedDataSize, expectedSSTableTimestamps);
    }

    @Test
    void testTimeRangeFilterWithEndBoundExclusive() {
        Map<String, String> timeRangeOptions = Map.of("sstable_end_timestamp_micros", Long.valueOf(MIDDLE_TIMESTAMP_MICROS - 1L).toString());
        Set<Long> expectedSSTableTimestamps = Set.of(Long.valueOf(EARLY_TIMESTAMP_MICROS));
        this.runTimeRangeFilterTest(timeRangeOptions, 1000, expectedSSTableTimestamps);
    }

    @Test
    void testTimeRangeFilterWithStartAndEndBound() {
        Map<String, String> timeRangeOptions = Map.of("sstable_start_timestamp_micros", Long.valueOf(MIDDLE_TIMESTAMP_MICROS).toString(), "sstable_end_timestamp_micros", Long.valueOf(LATE_TIMESTAMP_MICROS - 1L).toString());
        Set<Long> expectedSSTableTimestamps = Set.of(Long.valueOf(MIDDLE_TIMESTAMP_MICROS));
        this.runTimeRangeFilterTest(timeRangeOptions, 1000, expectedSSTableTimestamps);
    }

    @Test
    void testTimeRangeFilterWithStartAndEndBoundExclusive() {
        Map<String, String> timeRangeOptions = Map.of("sstable_start_timestamp_micros", Long.valueOf(EARLY_TIMESTAMP_MICROS + 1L).toString(), "sstable_end_timestamp_micros", Long.valueOf(LATE_TIMESTAMP_MICROS - 1L).toString());
        int expectedDataSize = 2000;
        Set<Long> expectedSSTableTimestamps = Set.of(Long.valueOf(EARLY_TIMESTAMP_MICROS), Long.valueOf(MIDDLE_TIMESTAMP_MICROS));
        this.runTimeRangeFilterTest(timeRangeOptions, expectedDataSize, expectedSSTableTimestamps);
    }

    @Test
    void testTimeRangeFilterNonOverlappingBound() {
        Map<String, String> timeRangeOptions = Map.of("sstable_end_timestamp_micros", Long.valueOf(EARLY_TIMESTAMP_MICROS - 1L).toString());
        Dataset data = this.bulkReaderDataFrame(this.twcsTable, timeRangeOptions).load();
        List rows = data.collectAsList();
        Assertions.assertThat((int)rows.size()).isEqualTo(0);
    }

    @Test
    void testTimeRangeFilterWithoutTWCS() {
        Map<String, String> timeRangeOptions = Map.of("sstable_start_timestamp_micros", Long.valueOf(EARLY_TIMESTAMP_MICROS).toString(), "sstable_end_timestamp_micros", Long.valueOf(LATE_TIMESTAMP_MICROS).toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Dataset data = this.bulkReaderDataFrame(this.lcsTable, timeRangeOptions).load();
            data.collectAsList();
        }).isInstanceOf(UnsupportedOperationException.class)).hasMessage("SSTableTimeRangeFilter is only supported with TimeWindowCompactionStrategy. Current compaction strategy is: org.apache.cassandra.db.compaction.LeveledCompactionStrategy");
    }

    private void runTimeRangeFilterTest(Map<String, String> timeRangeOptions, int expectedDataSize, Set<Long> expectedTimestamps) {
        Dataset data = this.bulkReaderDataFrame(this.twcsTable, timeRangeOptions).load();
        List rows = data.collectAsList();
        Assertions.assertThat((int)rows.size()).isEqualTo(expectedDataSize);
        Set allTimestamps = rows.stream().map(row -> row.getLong(2)).collect(Collectors.toSet());
        Assertions.assertThat((int)expectedTimestamps.size()).isEqualTo(allTimestamps.size());
        Assertions.assertThat(expectedTimestamps).containsAll(allTimestamps);
    }

    protected void initializeSchemaForTest() {
        String query;
        long timestamp;
        int i;
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF1);
        IInstance instance = this.cluster.getFirstRunningInstance();
        ICoordinator coordinator = instance.coordinator();
        this.createTestTable(this.twcsTable, "CREATE TABLE IF NOT EXISTS %s (    id text PRIMARY KEY,    data text,    timestamp bigint) WITH compaction = {    'class': 'org.apache.cassandra.db.compaction.TimeWindowCompactionStrategy',    'compaction_window_size': '1',    'compaction_window_unit': 'MINUTES'};");
        this.createTestTable(this.lcsTable, "CREATE TABLE IF NOT EXISTS %s (    id text PRIMARY KEY,    data text) WITH compaction = {    'class': 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'};");
        for (i = 0; i < 10; ++i) {
            String query2 = String.format("INSERT INTO %s (id, data) VALUES ('%s', 'data_%s')", this.lcsTable, i, "data" + i);
            coordinator.execute(query2, ConsistencyLevel.ALL, new Object[0]);
        }
        instance.nodetool(new String[]{"flush", "spark_test", this.lcsTable.table()});
        for (i = 0; i < 1000; ++i) {
            long timestamp2 = EARLY_TIMESTAMP_MICROS + (long)i;
            String query3 = String.format("INSERT INTO %s (id, data, timestamp) VALUES ('%s', 'data_%s', %d) USING TIMESTAMP %d", this.twcsTable, i, "data" + i, EARLY_TIMESTAMP_MICROS, timestamp2);
            coordinator.execute(query3, ConsistencyLevel.ALL, new Object[0]);
        }
        instance.nodetool(new String[]{"flush", "spark_test", this.twcsTable.table()});
        for (i = 0; i < 1000; ++i) {
            int id = 1000 + i;
            timestamp = MIDDLE_TIMESTAMP_MICROS + (long)i;
            query = String.format("INSERT INTO %s (id, data, timestamp) VALUES ('%s', 'data_%s', %d) USING TIMESTAMP %d", this.twcsTable, id, "data" + id, MIDDLE_TIMESTAMP_MICROS, timestamp);
            coordinator.execute(query, ConsistencyLevel.ALL, new Object[0]);
        }
        instance.nodetool(new String[]{"flush", "spark_test", this.twcsTable.table()});
        for (i = 0; i < 1000; ++i) {
            int id = 2000 + i;
            timestamp = LATE_TIMESTAMP_MICROS + (long)i;
            query = String.format("INSERT INTO %s (id, data, timestamp) VALUES ('%s', 'data_%s', %d) USING TIMESTAMP %d", this.twcsTable, id, "data" + id, LATE_TIMESTAMP_MICROS, timestamp);
            coordinator.execute(query, ConsistencyLevel.ALL, new Object[0]);
        }
        instance.nodetool(new String[]{"flush", "spark_test", this.twcsTable.table()});
    }
}

