/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.spark.data.ClientConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class CassandraDataLayerTests {
    public static final Map<String, String> REQUIRED_CLIENT_CONFIG_OPTIONS = ImmutableMap.of((Object)"keyspace", (Object)"big-data", (Object)"table", (Object)"customers", (Object)"sidecar_contact_points", (Object)"localhost");

    CassandraDataLayerTests() {
    }

    @Test
    void testDefaultClearSnapshotStrategy() {
        HashMap<String, String> options = new HashMap<String, String>(REQUIRED_CLIENT_CONFIG_OPTIONS);
        ClientConfig clientConfig = ClientConfig.create(options);
        Assertions.assertThat((String)clientConfig.keyspace()).isEqualTo("big-data");
        Assertions.assertThat((String)clientConfig.table()).isEqualTo("customers");
        Assertions.assertThat((String)clientConfig.sidecarContactPoints()).isEqualTo("localhost");
        ClientConfig.ClearSnapshotStrategy clearSnapshotStrategy = clientConfig.clearSnapshotStrategy();
        Assertions.assertThat((boolean)clearSnapshotStrategy.shouldClearOnCompletion()).isTrue();
        Assertions.assertThat((String)clearSnapshotStrategy.ttl()).isEqualTo("2d");
    }

    @ParameterizedTest
    @CsvSource(value={"false, NOOP", "true,ONCOMPLETIONORTTL 2d"})
    void testClearSnapshotOptionSupport(Boolean clearSnapshot, String expectedClearSnapshotStrategyOption) {
        HashMap<String, String> options = new HashMap<String, String>(REQUIRED_CLIENT_CONFIG_OPTIONS);
        options.put("clearsnapshot", clearSnapshot.toString());
        ClientConfig clientConfig = ClientConfig.create(options);
        ClientConfig.ClearSnapshotStrategy clearSnapshotStrategy = clientConfig.clearSnapshotStrategy();
        ClientConfig.ClearSnapshotStrategy expectedClearSnapshotStrategy = clientConfig.parseClearSnapshotStrategy(false, false, expectedClearSnapshotStrategyOption);
        Assertions.assertThat((boolean)clearSnapshotStrategy.shouldClearOnCompletion()).isEqualTo(expectedClearSnapshotStrategy.shouldClearOnCompletion());
        Assertions.assertThat((boolean)clearSnapshotStrategy.hasTTL()).isEqualTo(expectedClearSnapshotStrategy.hasTTL());
        Assertions.assertThat((String)clearSnapshotStrategy.ttl()).isEqualTo(expectedClearSnapshotStrategy.ttl());
    }
}

