/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cassandra.bridge.CassandraVersionFeatures;
import org.jetbrains.annotations.NotNull;

public final class SSTables {
    private static final String FILE_PATH_SEPARATOR = "-";
    private static final Map<String, CassandraVersionFeatures> SS_TABLE_VERSIONS = ImmutableMap.builder().put((Object)"ma", (Object)new CassandraVersionFeatures(30, 0, null)).put((Object)"mb", (Object)new CassandraVersionFeatures(30, 7, null)).put((Object)"mc", (Object)new CassandraVersionFeatures(30, 8, null)).put((Object)"md", (Object)new CassandraVersionFeatures(30, 18, null)).put((Object)"me", (Object)new CassandraVersionFeatures(30, 25, null)).put((Object)"mf", (Object)new CassandraVersionFeatures(30, 18, null)).put((Object)"na", (Object)new CassandraVersionFeatures(40, 0, null)).put((Object)"nb", (Object)new CassandraVersionFeatures(40, 0, null)).put((Object)"da", (Object)new CassandraVersionFeatures(50, 0, null)).put((Object)"oa", (Object)new CassandraVersionFeatures(50, 0, null)).build();

    private SSTables() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    private static LinkedHashMap<ComponentType, String> parse(@NotNull Path sstable) {
        String name = sstable.getFileName().toString();
        StringTokenizer st = new StringTokenizer(name, FILE_PATH_SEPARATOR);
        LinkedHashMap reverseOrderComponents = Maps.newLinkedHashMap();
        ArrayDeque<String> tokenStack = new ArrayDeque<String>();
        while (st.hasMoreTokens()) {
            tokenStack.push(st.nextToken());
        }
        reverseOrderComponents.put(ComponentType.FILE_COMPONENT, (String)tokenStack.pop());
        String nextToken = (String)tokenStack.pop();
        if (!SSTables.isNumeric(nextToken)) {
            reverseOrderComponents.put(ComponentType.FORMAT, nextToken);
            nextToken = (String)tokenStack.pop();
        }
        reverseOrderComponents.put(ComponentType.GENERATION, nextToken);
        String version = (String)tokenStack.pop();
        reverseOrderComponents.put(ComponentType.VERSION, version);
        ArrayList keys = new ArrayList(reverseOrderComponents.keySet());
        Collections.reverse(keys);
        LinkedHashMap components = Maps.newLinkedHashMap();
        keys.forEach(componentType -> components.put(componentType, (String)reverseOrderComponents.get(componentType)));
        return components;
    }

    private static boolean isNumeric(String string) {
        for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            if (character >= '0' && '9' >= character) continue;
            return false;
        }
        return true;
    }

    public static CassandraVersionFeatures cassandraVersionFromTable(@NotNull Path sstable) {
        String version = SSTables.parse(sstable).get((Object)ComponentType.VERSION);
        if (!SS_TABLE_VERSIONS.containsKey(version)) {
            throw new UnsupportedOperationException("SSTable version: " + version + " is not supported");
        }
        return SS_TABLE_VERSIONS.get(version);
    }

    private static enum ComponentType {
        VERSION,
        GENERATION,
        FORMAT,
        FILE_COMPONENT;

    }
}

