/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.flownetwork;

import org.psjava.algo.graph.flownetwork.EmptyFlowNetworkGraph;
import org.psjava.algo.graph.flownetwork.FlowAdjustOnPath;
import org.psjava.algo.graph.flownetwork.MaximumFlowAlgorithm;
import org.psjava.algo.graph.flownetwork.MaximumFlowAlgorithmResult;
import org.psjava.algo.graph.flownetwork.MaximumFlowAlgorithmResultFactory;
import org.psjava.algo.graph.flownetwork.MinimumResidualOnPath;
import org.psjava.algo.graph.flownetwork.ResidualNetworkNewGraph;
import org.psjava.algo.graph.pathfinder.PathFinder;
import org.psjava.ds.Collection;
import org.psjava.ds.graph.CapacityEdge;
import org.psjava.ds.graph.FlowNetworkEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.numbersystrem.AddableNumberSystem;

public class FordFulkersonAlgorithm {
    public static MaximumFlowAlgorithm getInstance(final PathFinder pathFinder) {
        return new MaximumFlowAlgorithm(){

            @Override
            public <V, F, E extends CapacityEdge<V, F>> MaximumFlowAlgorithmResult<F, E> calc(Graph<V, E> capacityGraph, V start, V end, AddableNumberSystem<F> ns) {
                Graph<V, FlowNetworkEdge<V, F, E>> residualNetwork;
                Collection<FlowNetworkEdge<V, F, E>> augmentingPath;
                Graph<V, FlowNetworkEdge<V, F, E>> flowNetwork = EmptyFlowNetworkGraph.create(capacityGraph, ns);
                while ((augmentingPath = pathFinder.find(residualNetwork = ResidualNetworkNewGraph.wrap(flowNetwork, ns), start, end, null)) != null && augmentingPath.size() != 0) {
                    F min2 = MinimumResidualOnPath.find(augmentingPath, ns);
                    FlowAdjustOnPath.adjust(augmentingPath, min2, ns);
                }
                return MaximumFlowAlgorithmResultFactory.create(flowNetwork, start, ns);
            }
        };
    }

    private FordFulkersonAlgorithm() {
    }
}

