/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.jdk;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCClassLoader;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCModule;
import org.openjdk.jmc.common.IMCOldObject;
import org.openjdk.jmc.common.IMCOldObjectGcRoot;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCThreadGroup;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.LabeledIdentifier;
import org.openjdk.jmc.common.util.MCClassLoader;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.messages.internal.Messages;

public final class JdkAttributes {
    public static final IAttribute<String> EVENT_THREAD_NAME = Attribute.canonicalize(new Attribute<String>("(thread).name", Messages.getString("ATTR_EVENT_THREAD_NAME"), Messages.getString("ATTR_EVENT_THREAD_NAME_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_THREAD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCThread thread = (IMCThread)accessor.getMember(i);
                    return thread == null ? null : thread.getThreadName();
                }
            };
        }
    });
    public static final IAttribute<String> EVENT_THREAD_GROUP_NAME = Attribute.canonicalize(new Attribute<String>("(thread).groupName", Messages.getString("ATTR_EVENT_THREAD_GROUP"), Messages.getString("ATTR_EVENT_THREAD_GROUP_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_THREAD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCThreadGroup group;
                    IMCThread thread = (IMCThread)accessor.getMember(i);
                    if (thread != null && (group = thread.getThreadGroup()) != null) {
                        return group.getName();
                    }
                    return null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> EVENT_THREAD_ID = Attribute.canonicalize(new Attribute<IQuantity>("(thread).javaThreadId", Messages.getString("ATTR_EVENT_THREAD_ID"), Messages.getString("ATTR_EVENT_THREAD_ID_DESC"), (ContentType)UnitLookup.NUMBER){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_THREAD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IQuantity, U>(){

                @Override
                public IQuantity getMember(U i) {
                    IMCThread thread = (IMCThread)accessor.getMember(i);
                    return thread == null || thread.getThreadId() == null ? null : UnitLookup.NUMBER_UNITY.quantity(thread.getThreadId());
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_STRING = Attribute.canonicalize(new Attribute<String>("(stackTrace).string", Messages.getString("ATTR_STACK_TRACE_STRING"), Messages.getString("ATTR_STACK_TRACE_STRING_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCStackTrace trace = (IMCStackTrace)accessor.getMember(i);
                    return trace == null ? null : FormatToolkit.getHumanReadable(trace, "", "", null);
                }
            };
        }
    });
    public static final IAttribute<IMCFrame> STACK_TRACE_TOP_FRAME = Attribute.canonicalize(new Attribute<IMCFrame>("(stackTrace).topframe", Messages.getString("ATTR_STACK_TRACE_FRAME"), Messages.getString("ATTR_STACK_TRACE_FRAME_DESC"), UnitLookup.STACKTRACE_FRAME){

        @Override
        public <U> IMemberAccessor<IMCFrame, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCFrame, U>(){

                @Override
                public IMCFrame getMember(U i) {
                    IMCStackTrace trace = (IMCStackTrace)accessor.getMember(i);
                    return trace == null || trace.getFrames().isEmpty() ? null : trace.getFrames().get(0);
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_TOP_PACKAGE = Attribute.canonicalize(new Attribute<String>("(stackTrace).topPackage", Messages.getString("ATTR_STACK_TRACE_PACKAGE"), Messages.getString("ATTR_STACK_TRACE_PACKAGE_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_CLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : FormatToolkit.getPackage(type.getPackage());
                }
            };
        }
    });
    public static final IAttribute<IMCType> STACK_TRACE_TOP_CLASS = Attribute.canonicalize(new Attribute<IMCType>("(stackTrace).topClass", Messages.getString("ATTR_STACK_TRACE_CLASS"), Messages.getString("ATTR_STACK_TRACE_CLASS_DESC"), UnitLookup.CLASS){

        @Override
        public <U> IMemberAccessor<IMCType, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_METHOD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCType, U>(){

                @Override
                public IMCType getMember(U i) {
                    IMCMethod method = (IMCMethod)accessor.getMember(i);
                    return method == null ? null : method.getType();
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_TOP_CLASS_STRING = Attribute.canonicalize(new Attribute<String>("(stackTrace).topClass.string", Messages.getString("ATTR_STACK_TRACE_CLASS"), Messages.getString("ATTR_STACK_TRACE_CLASS_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_CLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : type.getFullName();
                }
            };
        }
    });
    public static final IAttribute<IMCMethod> STACK_TRACE_TOP_METHOD = Attribute.canonicalize(new Attribute<IMCMethod>("(stackTrace).topMethod", Messages.getString("ATTR_STACK_TRACE_METHOD"), Messages.getString("ATTR_STACK_TRACE_METHOD_DESC"), UnitLookup.METHOD){

        @Override
        public <U> IMemberAccessor<IMCMethod, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_FRAME.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCMethod, U>(){

                @Override
                public IMCMethod getMember(U i) {
                    IMCFrame frame = (IMCFrame)accessor.getMember(i);
                    return frame == null ? null : frame.getMethod();
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_TOP_METHOD_STRING = Attribute.canonicalize(new Attribute<String>("(stackTrace).topMethodString", Messages.getString("ATTR_STACK_TRACE_METHOD"), Messages.getString("ATTR_STACK_TRACE_METHOD_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_METHOD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCMethod method = (IMCMethod)accessor.getMember(i);
                    return method == null ? null : FormatToolkit.getHumanReadable(method);
                }
            };
        }
    });
    public static final IAttribute<IMCFrame> STACK_TRACE_BOTTOM_FRAME = Attribute.canonicalize(new Attribute<IMCFrame>("(stackTrace).bottomFrame", Messages.getString("ATTR_STACK_TRACE_BOTTOM_FRAME"), Messages.getString("ATTR_STACK_TRACE_BOTTOM_FRAME_DESC"), UnitLookup.STACKTRACE_FRAME){

        @Override
        public <U> IMemberAccessor<IMCFrame, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCFrame, U>(){

                @Override
                public IMCFrame getMember(U i) {
                    IMCStackTrace trace = (IMCStackTrace)accessor.getMember(i);
                    if (trace != null) {
                        List<? extends IMCFrame> frames = trace.getFrames();
                        return frames == null || frames.size() == 0 ? null : frames.get(frames.size() - 1);
                    }
                    return null;
                }
            };
        }
    });
    public static final IAttribute<IMCMethod> STACK_TRACE_BOTTOM_METHOD = Attribute.canonicalize(new Attribute<IMCMethod>("(stackTrace).bottomMethod", Messages.getString("ATTR_STACK_TRACE_BOTTOM_METHOD"), Messages.getString("ATTR_STACK_TRACE_BOTTOM_METHOD_DESC"), UnitLookup.METHOD){

        @Override
        public <U> IMemberAccessor<IMCMethod, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_BOTTOM_FRAME.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCMethod, U>(){

                @Override
                public IMCMethod getMember(U i) {
                    IMCFrame frame = (IMCFrame)accessor.getMember(i);
                    return frame == null ? null : frame.getMethod();
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_BOTTOM_METHOD_STRING = Attribute.canonicalize(new Attribute<String>("(stackTrace).bottomMethodString", Messages.getString("ATTR_STACK_TRACE_BOTTOM_METHOD"), Messages.getString("ATTR_STACK_TRACE_BOTTOM_METHOD_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_BOTTOM_METHOD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCMethod method = (IMCMethod)accessor.getMember(i);
                    return method == null ? null : FormatToolkit.getHumanReadable(method);
                }
            };
        }
    });
    public static final IAttribute<Boolean> STACK_TRACE_TRUNCATED = Attribute.canonicalize(new Attribute<Boolean>("(stackTrace).truncationState", Messages.getString("ATTR_STACK_TRACE_DEPTH"), Messages.getString("ATTR_STACK_TRACE_DEPTH_DESC"), UnitLookup.FLAG){

        @Override
        public <U> IMemberAccessor<Boolean, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<Boolean, U>(){

                @Override
                public Boolean getMember(U i) {
                    IMCStackTrace trace = (IMCStackTrace)accessor.getMember(i);
                    return trace == null ? null : Boolean.valueOf(trace.getTruncationState().isTruncated());
                }
            };
        }
    });
    public static final IAttribute<String> PID = Attribute.attr("pid", Messages.getString("ATTR_PID"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> COMMAND_LINE = Attribute.attr("commandLine", Messages.getString("ATTR_COMMAND_LINE"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> JVM_SYSTEM = Attribute.attr("jvmSystem", Messages.getString("ATTR_JVM_SYSTEM"), Messages.getString("ATTR_JVM_SYSTEM_DESC"), UnitLookup.PERCENTAGE);
    public static final IAttribute<IQuantity> JVM_USER = Attribute.attr("jvmUser", Messages.getString("ATTR_JVM_USER"), Messages.getString("ATTR_JVM_USER_DESC"), UnitLookup.PERCENTAGE);
    public static final IAttribute<IQuantity> JVM_TOTAL = Attribute.canonicalize(new Attribute<IQuantity>("jvmTotal", Messages.getString("ATTR_JVM_TOTAL"), Messages.getString("ATTR_JVM_TOTAL_DESC"), (ContentType)UnitLookup.PERCENTAGE){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor jvmUserAccessor = type.getAccessor(JVM_USER.getKey());
            final IMemberAccessor jvmSystemAccessor = type.getAccessor(JVM_SYSTEM.getKey());
            if (jvmUserAccessor == null || jvmSystemAccessor == null) {
                return null;
            }
            return new IMemberAccessor<IQuantity, U>(){

                @Override
                public IQuantity getMember(U i) {
                    IQuantity jvmUser = (IQuantity)jvmUserAccessor.getMember(i);
                    IQuantity jvmSystem = (IQuantity)jvmSystemAccessor.getMember(i);
                    return jvmUser != null && jvmSystem != null ? jvmUser.add(jvmSystem) : null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> MACHINE_TOTAL = Attribute.attr("machineTotal", Messages.getString("ATTR_MACHINE_TOTAL"), Messages.getString("ATTR_MACHINE_TOTAL_DESC"), UnitLookup.PERCENTAGE);
    public static final IAttribute<IQuantity> OTHER_CPU = Attribute.canonicalize(new Attribute<IQuantity>("otherCpu", Messages.getString("ATTR_OTHER_CPU"), Messages.getString("ATTR_OTHER_CPU_DESC"), (ContentType)UnitLookup.PERCENTAGE){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor jvmTotalAccessor = JVM_TOTAL.getAccessor(type);
            final IMemberAccessor machineTotalAccessor = type.getAccessor(MACHINE_TOTAL.getKey());
            if (jvmTotalAccessor == null || machineTotalAccessor == null) {
                return null;
            }
            return new IMemberAccessor<IQuantity, U>(){

                @Override
                public IQuantity getMember(U i) {
                    IQuantity jvmTotal = (IQuantity)jvmTotalAccessor.getMember(i);
                    IQuantity machineTotal = (IQuantity)machineTotalAccessor.getMember(i);
                    return jvmTotal != null && machineTotal != null ? machineTotal.subtract(jvmTotal) : null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> RECORDING_ID = Attribute.attr("id", Messages.getString("ATTR_RECORDING_ID"), UnitLookup.NUMBER);
    public static final IAttribute<String> RECORDING_NAME = Attribute.attr("name", Messages.getString("ATTR_RECORDING_NAME"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> RECORDING_START = Attribute.attr("recordingStart", Messages.getString("ATTR_RECORDING_START"), UnitLookup.TIMESTAMP);
    public static final IAttribute<IQuantity> RECORDING_DURATION = Attribute.attr("recordingDuration", Messages.getString("ATTR_RECORDING_DURATION"), UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> RECORDING_MAX_SIZE = Attribute.attr("maxSize", Messages.getString("ATTR_RECORDING_MAX_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> RECORDING_MAX_AGE = Attribute.attr("maxAge", Messages.getString("ATTR_RECORDING_MAX_AGE"), UnitLookup.TIMESPAN);
    public static final IAttribute<String> RECORDING_DESTINATION = Attribute.attr("destination", Messages.getString("ATTR_RECORDING_DESTINATION"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<LabeledIdentifier> REC_SETTING_FOR = Attribute.attr("settingFor", Messages.getString("ATTR_REC_SETTING_FOR"), UnitLookup.LABELED_IDENTIFIER);
    public static final IAttribute<String> REC_SETTING_NAME = Attribute.attr("name", Messages.getString("ATTR_REC_SETTING_NAME"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> REC_SETTING_VALUE = Attribute.attr("value", Messages.getString("ATTR_REC_SETTING_VALUE"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> REC_SETTING_FOR_NAME = Attribute.canonicalize(new Attribute<String>("settingFor.string", Messages.getString("ATTR_REC_SETTING_FOR"), null, UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = REC_SETTING_FOR.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    LabeledIdentifier identifier = (LabeledIdentifier)accessor.getMember(i);
                    return identifier == null ? null : identifier.getName();
                }
            };
        }
    });
    public static final IAttribute<String> REC_SETTING_FOR_ID = Attribute.canonicalize(new Attribute<String>("settingFor.id", Messages.getString("ATTR_REC_SETTING_FOR"), null, UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = REC_SETTING_FOR.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    LabeledIdentifier identifier = (LabeledIdentifier)accessor.getMember(i);
                    return identifier == null ? null : identifier.getInterfaceId();
                }
            };
        }
    });
    public static final IAttribute<IMCPackage> EXPORTED_PACKAGE = Attribute.attr("exportedPackage", Messages.getString("ATTR_EXPORTED_PACKAGE"), UnitLookup.PACKAGE);
    public static final IAttribute<IMCModule> EXPORTING_MODULE = Attribute.canonicalize(new Attribute<IMCModule>("exportingModule", Messages.getString("ATTR_EXPORTING_MODULE"), null, UnitLookup.MODULE){

        @Override
        public <U> IMemberAccessor<IMCModule, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = EXPORTED_PACKAGE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCModule, U>(){

                @Override
                public IMCModule getMember(U i) {
                    IMCPackage thePackage = (IMCPackage)accessor.getMember(i);
                    return thePackage == null ? null : thePackage.getModule();
                }
            };
        }
    });
    public static final IAttribute<IQuantity> JVM_START_TIME = Attribute.attr("jvmStartTime", Messages.getString("ATTR_JVM_START_TIME"), UnitLookup.TIMESTAMP);
    public static final IAttribute<String> JVM_NAME = Attribute.attr("jvmName", Messages.getString("ATTR_JVM_NAME"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> JVM_PID = Attribute.attr("pid", Messages.getString("ATTR_JVM_PID"), UnitLookup.NUMBER);
    public static final IAttribute<String> JVM_VERSION = Attribute.attr("jvmVersion", Messages.getString("ATTR_JVM_VERSION"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> JVM_ARGUMENTS = Attribute.attr("jvmArguments", Messages.getString("ATTR_JVM_ARGUMENTS"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> JAVA_ARGUMENTS = Attribute.attr("javaArguments", Messages.getString("ATTR_JAVA_ARGUMENTS"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> IO_PATH = Attribute.attr("path", Messages.getString("ATTR_IO_PATH"), Messages.getString("ATTR_IO_PATH_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> IO_FILE_BYTES_READ = Attribute.attr("bytesRead", Messages.getString("ATTR_IO_FILE_BYTES_READ"), Messages.getString("ATTR_IO_FILE_BYTES_READ_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<Boolean> IO_FILE_READ_EOF = Attribute.attr("endOfFile", Messages.getString("ATTR_IO_FILE_READ_EOF"), Messages.getString("ATTR_IO_FILE_READ_EOF_DESC"), UnitLookup.FLAG);
    public static final IAttribute<IQuantity> IO_FILE_BYTES_WRITTEN = Attribute.attr("bytesWritten", Messages.getString("ATTR_IO_FILE_BYTES_WRITTEN"), Messages.getString("ATTR_IO_FILE_BYTES_WRITTEN_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> IO_SOCKET_BYTES_READ = Attribute.attr("bytesRead", Messages.getString("ATTR_IO_SOCKET_BYTES_READ"), Messages.getString("ATTR_IO_SOCKET_BYTES_READ_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<Boolean> IO_SOCKET_READ_EOS = Attribute.attr("endOfStream", Messages.getString("ATTR_IO_SOCKET_READ_EOS"), Messages.getString("ATTR_IO_SOCKET_READ_EOS_DESC"), UnitLookup.FLAG);
    public static final IAttribute<IQuantity> IO_SOCKET_BYTES_WRITTEN = Attribute.attr("bytesWritten", Messages.getString("ATTR_IO_SOCKET_BYTES_WRITTEN"), Messages.getString("ATTR_IO_SOCKET_BYTES_WRITTEN_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> IO_SIZE = Attribute.canonicalize(new Attribute<IQuantity>("size", "Size", null, (ContentType)UnitLookup.MEMORY){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            ArrayList accessorList = new ArrayList();
            accessorList.add(type.getAccessor(IO_SOCKET_BYTES_READ.getKey()));
            accessorList.add(type.getAccessor(IO_SOCKET_BYTES_WRITTEN.getKey()));
            accessorList.add(type.getAccessor(IO_FILE_BYTES_READ.getKey()));
            accessorList.add(type.getAccessor(IO_FILE_BYTES_WRITTEN.getKey()));
            for (IMemberAccessor iMemberAccessor : accessorList) {
                if (iMemberAccessor == null) continue;
                return iMemberAccessor;
            }
            return MemberAccessorToolkit.constant(UnitLookup.BYTE.quantity(0L));
        }
    });
    public static final IAttribute<String> IO_ADDRESS = Attribute.attr("address", Messages.getString("ATTR_IO_ADDRESS"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> IO_HOST = Attribute.attr("host", Messages.getString("ATTR_IO_HOST"), Messages.getString("ATTR_IO_HOST_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> IO_PORT = Attribute.attr("port", Messages.getString("ATTR_IO_PORT"), UnitLookup.NUMBER);
    public static final IAttribute<Object> IO_PORT_ON_ADDRESS = Attribute.canonicalize(new Attribute<Object>("portOnAddress", Messages.getString("ATTR_IO_PORT_ON_ADDRESS"), null, UnitLookup.UNKNOWN){

        @Override
        public <U> IMemberAccessor<Object, U> customAccessor(IType<U> type) {
            final IMemberAccessor addressAccessor = type.getAccessor(IO_ADDRESS.getKey());
            final IMemberAccessor portAccessor = type.getAccessor(IO_PORT.getKey());
            if (addressAccessor == null || portAccessor == null) {
                return null;
            }
            return new IMemberAccessor<Object, U>(){

                @Override
                public IDisplayable getMember(U i) {
                    String address = (String)addressAccessor.getMember(i);
                    IQuantity port = (IQuantity)portAccessor.getMember(i);
                    if (address != null && port != null) {
                        class PortOnAddress
                        implements IDisplayable {
                            final String address;
                            final IQuantity port;

                            PortOnAddress(String address, IQuantity port) {
                                this.address = address;
                                this.port = port;
                            }

                            @Override
                            public String displayUsing(String formatHint) {
                                return this.address + " : " + this.port.displayUsing(formatHint);
                            }

                            public int hashCode() {
                                return 31 * this.address.hashCode() + this.port.hashCode();
                            }

                            public boolean equals(Object o) {
                                return o instanceof PortOnAddress && ((PortOnAddress)o).address.equals(this.address) && ((PortOnAddress)o).port.equals(this.port);
                            }
                        }
                        return new PortOnAddress(address, port);
                    }
                    return null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> IO_TIMEOUT = Attribute.attr("timeout", Messages.getString("ATTR_IO_TIMEOUT"), UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> TLAB_SIZE = Attribute.attr("tlabSize", Messages.getString("ATTR_TLAB_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> ALLOCATION_SIZE = Attribute.attr("allocationSize", Messages.getString("ATTR_ALLOCATION_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IMCType> ALLOCATION_CLASS = Attribute.attr("objectClass", Messages.getString("ATTR_ALLOCATION_CLASS"), Messages.getString("ATTR_ALLOCATION_CLASS_DESC"), UnitLookup.CLASS);
    public static final IAttribute<IMCType> OBJECT_CLASS = Attribute.attr("objectClass", Messages.getString("ATTR_OBJECT_CLASS"), UnitLookup.CLASS);
    public static final IAttribute<String> OBJECT_CLASS_FULLNAME = Attribute.canonicalize(new Attribute<String>("objectClass.humanreadable", Messages.getString("ATTR_OBJECT_CLASS"), null, UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT_CLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : type.getFullName();
                }
            };
        }
    });
    public static final IAttribute<IQuantity> COUNT = Attribute.attr("count", Messages.getString("ATTR_COUNT"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> HW_THREADS = Attribute.attr("hwThreads", Messages.getString("ATTR_HW_THREADS"), Messages.getString("ATTR_HW_THREADS_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> PARALLEL_GC_THREADS = Attribute.attr("parallelGCThreads", Messages.getString("ATTR_PARALLEL_GC_THREADS"), Messages.getString("ATTR_PARALLEL_GC_THREADS_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> CONCURRENT_GC_THREADS = Attribute.attr("concurrentGCThreads", Messages.getString("ATTR_CONCURRENT_GC_THREADS"), Messages.getString("ATTR_CONCURRENT_GC_THREADS_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<String> YOUNG_COLLECTOR = Attribute.attr("youngCollector", Messages.getString("ATTR_YOUNG_COLLECTOR"), Messages.getString("ATTR_YOUNG_COLLECTOR_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> OLD_COLLECTOR = Attribute.attr("oldCollector", Messages.getString("ATTR_OLD_COLLECTOR"), Messages.getString("ATTR_OLD_COLLECTOR_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<Boolean> EXPLICIT_GC_CONCURRENT = Attribute.attr("isExplicitGCConcurrent", Messages.getString("ATTR_EXPLICIT_GC_CONCURRENT"), Messages.getString("ATTR_EXPLICIT_GC_CONCURRENT_DESC"), UnitLookup.FLAG);
    public static final IAttribute<Boolean> EXPLICIT_GC_DISABLED = Attribute.attr("isExplicitGCDisabled", Messages.getString("ATTR_EXPLICIT_GC_DISABLED"), Messages.getString("ATTR_EXPLICIT_GC_DISABLED_DESC"), UnitLookup.FLAG);
    public static final IAttribute<Boolean> USE_DYNAMIC_GC_THREADS = Attribute.attr("usesDynamicGCThreads", Messages.getString("ATTR_USE_DYNAMIC_GC_THREADS"), Messages.getString("ATTR_USE_DYNAMIC_GC_THREADS_DESC"), UnitLookup.FLAG);
    public static final IAttribute<IQuantity> GC_TIME_RATIO = Attribute.attr("gcTimeRatio", Messages.getString("ATTR_GC_TIME_RATIO"), Messages.getString("ATTR_GC_TIME_RATIO_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> HEAP_MAX_SIZE = Attribute.attr("maxSize", Messages.getString("ATTR_HEAP_MAX_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_MIN_SIZE = Attribute.attr("minSize", Messages.getString("ATTR_HEAP_MIN_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_INITIAL_SIZE = Attribute.attr("initialSize", Messages.getString("ATTR_HEAP_INITIAL_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_OBJECT_ALIGNMENT = Attribute.attr("objectAlignment", Messages.getString("ATTR_HEAP_OBJECT_ALIGNMENT"), Messages.getString("ATTR_HEAP_OBJECT_ALIGNMENT_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_ADDRESS_SIZE = Attribute.attr("heapAddressBits", Messages.getString("ATTR_HEAP_ADDRESS_SIZE"), Messages.getString("ATTR_HEAP_ADDRESS_SIZE_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<Boolean> HEAP_USE_COMPRESSED_OOPS = Attribute.attr("usesCompressedOops", Messages.getString("ATTR_HEAP_USE_COMPRESSED_OOPS"), Messages.getString("ATTR_HEAP_USE_COMPRESSED_OOPS_DESC"), UnitLookup.FLAG);
    public static final IAttribute<String> HEAP_COMPRESSED_OOPS_MODE = Attribute.attr("compressedOopsMode", Messages.getString("ATTR_HEAP_COMPRESSED_OOPS_MODE"), Messages.getString("ATTR_HEAP_COMPRESSED_OOPS_MODE_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> YOUNG_GENERATION_MIN_SIZE = Attribute.attr("minSize", Messages.getString("ATTR_YOUNG_GENERATION_MIN_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> YOUNG_GENERATION_MAX_SIZE = Attribute.attr("maxSize", Messages.getString("ATTR_YOUNG_GENERATION_MAX_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> NEW_RATIO = Attribute.attr("newRatio", Messages.getString("ATTR_NEW_RATIO"), Messages.getString("ATTR_NEW_RATIO_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> TENURING_THRESHOLD_INITIAL = Attribute.attr("initialTenuringThreshold", Messages.getString("ATTR_TENURING_THRESHOLD_INITIAL"), Messages.getString("ATTR_TENURING_THRESHOLD_INITIAL_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> TENURING_THRESHOLD_MAXIMUM = Attribute.attr("maxTenuringThreshold", Messages.getString("ATTR_TENURING_THRESHOLD_MAXIMUM"), Messages.getString("ATTR_TENURING_THRESHOLD_MAXIMUM_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<Boolean> USES_TLABS = Attribute.attr("usesTLABs", Messages.getString("ATTR_USES_TLABS"), Messages.getString("ATTR_USES_TLABS_DESC"), UnitLookup.FLAG);
    public static final IAttribute<IQuantity> TLAB_MIN_SIZE = Attribute.attr("minTLABSize", Messages.getString("ATTR_TLAB_MIN_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> TLAB_REFILL_WASTE_LIMIT = Attribute.attr("tlabRefillWasteLimit", Messages.getString("ATTR_TLAB_REFILL_WASTE_LIMIT"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_TOTAL = Attribute.attr("totalSize", Messages.getString("ATTR_HEAP_TOTAL"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_USED = Attribute.attr("heapUsed", Messages.getString("ATTR_HEAP_USED"), Messages.getString("ATTR_HEAP_USED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<String> GC_WHEN = Attribute.attr("when", Messages.getString("ATTR_GC_WHEN"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> GC_ID = Attribute.attr("gcId", Messages.getString("ATTR_GC_ID"), Messages.getString("ATTR_GC_ID_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> REFERENCE_COUNT = Attribute.attr("count", Messages.getString("ATTR_REFERENCE_COUNT"), UnitLookup.NUMBER);
    public static final IAttribute<String> GC_PHASE_NAME = Attribute.attr("name", Messages.getString("ATTR_GC_PHASE_NAME"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> GC_HEAPSPACE_COMMITTED = Attribute.attr("heapSpace:committedSize", Messages.getString("ATTR_GC_HEAPSPACE_COMMITTED"), Messages.getString("ATTR_GC_HEAPSPACE_COMMITTED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_HEAPSPACE_RESERVED = Attribute.attr("heapSpace:reservedSize", Messages.getString("ATTR_GC_HEAPSPACE_RESERVED"), Messages.getString("ATTR_GC_HEAPSPACE_RESERVED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_METASPACE_CAPACITY = Attribute.attr("metaspace:capacity", Messages.getString("ATTR_GC_METASPACE_CAPACITY"), Messages.getString("ATTR_GC_METASPACE_CAPACITY_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_METASPACE_COMMITTED = Attribute.attr("metaspace:committed", Messages.getString("ATTR_GC_METASPACE_COMMITTED"), Messages.getString("ATTR_GC_METASPACE_COMMITTED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_METASPACE_RESERVED = Attribute.attr("metaspace:reserved", Messages.getString("ATTR_GC_METASPACE_RESERVED"), Messages.getString("ATTR_GC_METASPACE_RESERVED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_METASPACE_USED = Attribute.attr("metaspace:used", Messages.getString("ATTR_GC_METASPACE_USED"), Messages.getString("ATTR_GC_METASPACE_USED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_DATASPACE_COMMITTED = Attribute.attr("dataSpace:committed", Messages.getString("ATTR_GC_METASPACE_DATA_COMMITTED"), Messages.getString("ATTR_GC_METASPACE_DATA_COMMITTED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_DATASPACE_RESERVED = Attribute.attr("dataSpace:reserved", Messages.getString("ATTR_GC_METASPACE_DATA_RESERVED"), Messages.getString("ATTR_GC_METASPACE_DATA_RESERVED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_DATASPACE_USED = Attribute.attr("dataSpace:used", Messages.getString("ATTR_GC_METASPACE_DATA_USED"), Messages.getString("ATTR_GC_METASPACE_DATA_USED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_CLASSSPACE_COMMITTED = Attribute.attr("classSpace:committed", Messages.getString("ATTR_GC_METASPACE_CLASS_COMMITTED"), Messages.getString("ATTR_GC_METASPACE_CLASS_COMMITTED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_CLASSSPACE_RESERVED = Attribute.attr("classSpace:reserved", Messages.getString("ATTR_GC_METASPACE_CLASS_RESERVED"), Messages.getString("ATTR_GC_METASPACE_CLASS_RESERVED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_CLASSSPACE_USED = Attribute.attr("classSpace:used", Messages.getString("ATTR_GC_METASPACE_CLASS_USED"), Messages.getString("ATTR_GC_METASPACE_CLASS_USED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_THRESHOLD = Attribute.attr("gcThreshold", Messages.getString("ATTR_GC_THRESHOLD"), Messages.getString("ATTR_GC_THRESHOLD_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> OS_MEMORY_TOTAL = Attribute.attr("totalSize", Messages.getString("ATTR_OS_MEMORY_TOTAL"), Messages.getString("ATTR_OS_MEMORY_TOTAL_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> OS_MEMORY_USED = Attribute.attr("usedSize", Messages.getString("ATTR_OS_MEMORY_USED"), Messages.getString("ATTR_OS_MEMORY_USED_DESC"), UnitLookup.MEMORY);
    public static final IAttribute<String> FLAG_NAME = Attribute.attr("name", Messages.getString("ATTR_FLAG_NAME"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> FLAG_ORIGIN = Attribute.attr("origin", Messages.getString("ATTR_FLAG_ORIGIN"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> FLAG_VALUE_NUMBER = Attribute.attr("value", Messages.getString("ATTR_FLAG_VALUE_NUMBER"), UnitLookup.NUMBER);
    public static final IAttribute<Boolean> FLAG_VALUE_BOOLEAN = Attribute.attr("value", Messages.getString("ATTR_FLAG_VALUE_BOOLEAN"), UnitLookup.FLAG);
    public static final IAttribute<String> FLAG_VALUE_TEXT = Attribute.attr("value", Messages.getString("ATTR_FLAG_VALUE_TEXT"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> THREAD_DUMP_RESULT = Attribute.attr("result", Messages.getString("ATTR_THREAD_DUMP_RESULT"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> DUMP_REASON = Attribute.attr("reason", Messages.getString("ATTR_DUMP_REASON"), Messages.getString("ATTR_DUMP_REASON_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> DUMP_REASON_RECORDING_ID = Attribute.attr("recordingId", Messages.getString("ATTR_DUMP_REASON_RECORDING_ID"), Messages.getString("ATTR_DUMP_REASON_RECORDING_ID_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> SHUTDOWN_REASON = Attribute.attr("reason", Messages.getString("ATTR_SHUTDOWN_REASON"), Messages.getString("ATTR_SHUTDOWN_REASON_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> CLASSLOADER_LOADED_COUNT = Attribute.attr("loadedClassCount", Messages.getString("ATTR_CLASSLOADER_LOADED_COUNT"), Messages.getString("ATTR_CLASSLOADER_LOADED_COUNT_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> CLASSLOADER_UNLOADED_COUNT = Attribute.attr("unloadedClassCount", Messages.getString("ATTR_CLASSLOADER_UNLOADED_COUNT"), Messages.getString("ATTR_CLASSLOADER_UNLOADED_COUNT_DESC"), UnitLookup.NUMBER);
    private static final IAttribute<IMCType> CLASS_DEFINING_CLASSLOADER_V0 = Attribute.attr("definingClassLoader", Messages.getString("ATTR_CLASS_DEFINING_CLASSLOADER"), UnitLookup.CLASS);
    private static final IAttribute<IMCType> CLASS_INITIATING_CLASSLOADER_V0 = Attribute.attr("initiatingClassLoader", Messages.getString("ATTR_CLASS_INITIATING_CLASSLOADER"), UnitLookup.CLASS);
    private static final IAttribute<IMCType> PARENT_CLASSLOADER_V0 = Attribute.attr("parentClassLoader", Messages.getString("ATTR_PARENT_CLASSLOADER"), UnitLookup.CLASS);
    private static final IAttribute<IMCType> CLASSLOADER_V0 = Attribute.attr("classLoader", Messages.getString("ATTR_CLASSLOADER"), UnitLookup.CLASS);
    public static final IAttribute<IMCClassLoader> CLASS_DEFINING_CLASSLOADER = Attribute.canonicalize(new Attribute<IMCClassLoader>("definingClassLoader", Messages.getString("ATTR_CLASS_DEFINING_CLASSLOADER"), null, UnitLookup.CLASS_LOADER){

        @Override
        public <U> IMemberAccessor<IMCClassLoader, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessorV0 = CLASS_DEFINING_CLASSLOADER_V0.getAccessor(type);
            if (accessorV0 != null) {
                return new IMemberAccessor<IMCClassLoader, U>(){

                    @Override
                    public IMCClassLoader getMember(U i) {
                        IMCType type = (IMCType)accessorV0.getMember(i);
                        return new MCClassLoader(type, null);
                    }
                };
            }
            return null;
        }
    });
    public static final IAttribute<IMCClassLoader> CLASS_INITIATING_CLASSLOADER = Attribute.canonicalize(new Attribute<IMCClassLoader>("initiatingClassLoader", Messages.getString("ATTR_CLASS_INITIATING_CLASSLOADER"), null, UnitLookup.CLASS_LOADER){

        @Override
        public <U> IMemberAccessor<IMCClassLoader, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessorV0 = CLASS_INITIATING_CLASSLOADER_V0.getAccessor(type);
            if (accessorV0 != null) {
                return new IMemberAccessor<IMCClassLoader, U>(){

                    @Override
                    public IMCClassLoader getMember(U i) {
                        IMCType type = (IMCType)accessorV0.getMember(i);
                        return new MCClassLoader(type, null);
                    }
                };
            }
            return null;
        }
    });
    public static final IAttribute<IMCClassLoader> PARENT_CLASSLOADER = Attribute.canonicalize(new Attribute<IMCClassLoader>("parentClassLoader", Messages.getString("ATTR_PARENT_CLASSLOADER"), null, UnitLookup.CLASS_LOADER){

        @Override
        public <U> IMemberAccessor<IMCClassLoader, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessorV0 = PARENT_CLASSLOADER_V0.getAccessor(type);
            if (accessorV0 != null) {
                return new IMemberAccessor<IMCClassLoader, U>(){

                    @Override
                    public IMCClassLoader getMember(U i) {
                        IMCType type = (IMCType)accessorV0.getMember(i);
                        return new MCClassLoader(type, null);
                    }
                };
            }
            return null;
        }
    });
    public static final IAttribute<IMCClassLoader> CLASSLOADER = Attribute.canonicalize(new Attribute<IMCClassLoader>("classLoader", Messages.getString("ATTR_CLASSLOADER"), null, UnitLookup.CLASS_LOADER){

        @Override
        public <U> IMemberAccessor<IMCClassLoader, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessorV0 = CLASSLOADER_V0.getAccessor(type);
            if (accessorV0 != null) {
                return new IMemberAccessor<IMCClassLoader, U>(){

                    @Override
                    public IMCClassLoader getMember(U i) {
                        IMCType type = (IMCType)accessorV0.getMember(i);
                        return new MCClassLoader(type, null);
                    }
                };
            }
            return null;
        }
    });
    public static final IAttribute<String> CLASS_DEFINING_CLASSLOADER_STRING = Attribute.canonicalize(new Attribute<String>("defininingClassLoader.string", Messages.getString("ATTR_CLASS_DEFINING_CLASSLOADER"), null, UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = CLASS_DEFINING_CLASSLOADER.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCClassLoader cl = (IMCClassLoader)accessor.getMember(i);
                    return cl == null ? null : FormatToolkit.getHumanReadable(cl);
                }
            };
        }
    });
    public static final IAttribute<String> CLASS_INITIATING_CLASSLOADER_STRING = Attribute.canonicalize(new Attribute<String>("initiatingClassLoader.string", Messages.getString("ATTR_CLASS_INITIATING_CLASSLOADER"), null, UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = CLASS_INITIATING_CLASSLOADER.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCClassLoader cl = (IMCClassLoader)accessor.getMember(i);
                    return cl == null ? null : FormatToolkit.getHumanReadable(cl);
                }
            };
        }
    });
    public static final IAttribute<String> PARENT_CLASSLOADER_STRING = Attribute.canonicalize(new Attribute<String>("parentClassLoader.string", Messages.getString("ATTR_PARENT_CLASSLOADER"), null, UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = PARENT_CLASSLOADER.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCClassLoader cl = (IMCClassLoader)accessor.getMember(i);
                    return cl == null ? null : FormatToolkit.getHumanReadable(cl);
                }
            };
        }
    });
    public static final IAttribute<String> CLASSLOADER_STRING = Attribute.canonicalize(new Attribute<String>("classLoader.string", Messages.getString("ATTR_CLASSLOADER"), null, UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = CLASSLOADER.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCClassLoader cl = (IMCClassLoader)accessor.getMember(i);
                    return cl == null ? null : FormatToolkit.getHumanReadable(cl);
                }
            };
        }
    });
    public static final IAttribute<IMCType> CLASS_LOADED = Attribute.attr("loadedClass", Messages.getString("ATTR_CLASS_LOADED"), UnitLookup.CLASS);
    public static final IAttribute<IMCType> CLASS_UNLOADED = Attribute.attr("unloadedClass", Messages.getString("ATTR_CLASS_UNLOADED"), UnitLookup.CLASS);
    public static final IAttribute<IMCType> CLASS_DEFINED = Attribute.attr("definedClass", Messages.getString("ATTR_CLASS_DEFINED"), UnitLookup.CLASS);
    public static final IAttribute<IQuantity> ANONYMOUS_BLOCK_SIZE = Attribute.attr("anonymousBlockSize", Messages.getString("ATTR_ANONYMOUS_BLOCK_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> ANONYMOUS_CHUNK_SIZE = Attribute.attr("anonymousChunkSize", Messages.getString("ATTR_ANONYMOUS_CHUNK_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> ANONYMOUS_CLASS_COUNT = Attribute.attr("anonymousClassCount", Messages.getString("ATTR_ANONYMOUS_CLASS_COUNT"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> BLOCK_SIZE = Attribute.attr("blockSize", Messages.getString("ATTR_BLOCK_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> CHUNK_SIZE = Attribute.attr("chunkSize", Messages.getString("ATTR_CHUNK_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> CLASS_COUNT = Attribute.attr("classCount", Messages.getString("ATTR_CLASS_COUNT"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> CLASS_LOADER_DATA = Attribute.attr("classLoaderData", Messages.getString("ATTR_CLASSLOADER_DATA"), UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> COMPILER_COMPILATION_ID = Attribute.attr("compileId", Messages.getString("ATTR_COMPILER_COMPILATION_ID"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> COMPILER_CODE_SIZE = Attribute.attr("codeSize", Messages.getString("ATTR_COMPILER_CODE_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> COMPILER_INLINED_SIZE = Attribute.attr("inlinedBytes", Messages.getString("ATTR_COMPILER_INLINED_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IMCMethod> COMPILER_METHOD = Attribute.attr("method", Messages.getString("ATTR_COMPILER_METHOD"), UnitLookup.METHOD);
    public static final IAttribute<String> COMPILER_METHOD_STRING = Attribute.canonicalize(new Attribute<String>("method.humanreadable", Messages.getString("ATTR_COMPILER_METHOD_HUMAN"), Messages.getString("ATTR_COMPILER_METHOD_HUMAN_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = COMPILER_METHOD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCMethod method = (IMCMethod)accessor.getMember(i);
                    return method == null ? null : FormatToolkit.getHumanReadable(method);
                }
            };
        }
    });
    public static final IAttribute<String> COMPILER_FAILED_MESSAGE = Attribute.attr("failureMessage", Messages.getString("ATTR_COMPILER_FAILED_MESSAGE"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> COMPILER_STANDARD_COUNT = Attribute.attr("standardCompileCount", Messages.getString("ATTR_COMPILER_STANDARD_COUNT"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> COMPILER_OSR_COUNT = Attribute.attr("osrCompileCount", Messages.getString("ATTR_COMPILER_OSR_COUNT"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> COMPILER_COMPILATION_LEVEL = Attribute.attr("compileLevel", Messages.getString("ATTR_COMPILER_COMPILATION_LEVEL"), UnitLookup.NUMBER);
    public static final IAttribute<Boolean> COMPILER_COMPILATION_SUCCEEDED = Attribute.attr("succeded", Messages.getString("ATTR_COMPILER_COMPILATION_SUCCEEDED"), UnitLookup.FLAG);
    public static final IAttribute<Boolean> COMPILER_IS_OSR = Attribute.attr("isOsr", Messages.getString("ATTR_COMPILER_IS_OSR"), UnitLookup.FLAG);
    public static final IAttribute<IQuantity> START_ADDRESS = Attribute.attr("startAddress", Messages.getString("ATTR_START_ADDRESS"), UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> COMMITTED_TOP = Attribute.attr("commitedTopAddress", Messages.getString("ATTR_COMMITTED_TOP"), UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> RESERVED_TOP = Attribute.attr("reservedTopAddress", Messages.getString("ATTR_RESERVED_TOP"), UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> ENTRIES = Attribute.attr("entryCount", Messages.getString("ATTR_ENTRIES"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> METHODS = Attribute.attr("methodCount", Messages.getString("ATTR_METHODS"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> ADAPTORS = Attribute.attr("adaptorCount", Messages.getString("ATTR_ADAPTORS"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> FULL_COUNT = Attribute.attr("fullCount", Messages.getString("ATTR_FULL_COUNT"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> UNALLOCATED = Attribute.attr("unallocatedCapacity", Messages.getString("ATTR_UNALLOCATED"), UnitLookup.MEMORY);
    private static final String CODE_HEAP_NON_NMETHODS = "CodeHeap 'non-nmethods'";
    private static final String CODE_HEAP_NON_PROFILED_NMETHODS = "CodeHeap 'non-profiled nmethods'";
    private static final String CODE_HEAP_PROFILED_NMETHODS = "CodeHeap 'profiled nmethods'";
    public static final IAttribute<IQuantity> PROFILED_UNALLOCATED = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(UNALLOCATED, "CodeHeap 'profiled nmethods'", "profiledUnallocated", Messages.getString("ATTR_PROFILED_NMETHODS_UNALLOCATED"), Messages.getString("ATTR_PROFILED_NMETHODS_UNALLOCATED_DESCRIPTION"), UnitLookup.MEMORY));
    public static final IAttribute<IQuantity> PROFILED_ENTRIES = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(ENTRIES, "CodeHeap 'profiled nmethods'", "profiledEntries", Messages.getString("ATTR_PROFILED_NMETHODS_ENTRIES"), Messages.getString("ATTR_PROFILED_NMETHODS_ENTRIES_DESCRIPTION"), UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> PROFILED_METHODS = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(METHODS, "CodeHeap 'profiled nmethods'", "profiledMethods", Messages.getString("ATTR_PROFILED_NMETHODS_METHODS"), Messages.getString("ATTR_PROFILED_NMETHODS_METHODS_DESCRIPTION"), UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> NON_PROFILED_NMETHODS_UNALLOCATED = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(UNALLOCATED, "CodeHeap 'non-profiled nmethods'", "nonProfiledUnallocated", Messages.getString("ATTR_NON_PROFILED_NMETHODS_UNALLOCATED"), Messages.getString("ATTR_NON_PROFILED_NMETHODS_UNALLOCATED_DESCRIPTION"), UnitLookup.MEMORY));
    public static final IAttribute<IQuantity> NON_PROFILED_NMETHODS_ENTRIES = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(ENTRIES, "CodeHeap 'non-profiled nmethods'", "nonProfiledEntries", Messages.getString("ATTR_NON_PROFILED_NMETHODS_ENTRIES"), Messages.getString("ATTR_NON_PROFILED_NMETHODS_ENTRIES_DESCRIPTION"), UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> NON_PROFILED_METHODS = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(METHODS, "CodeHeap 'non-profiled nmethods'", "nonProfiledMethods", Messages.getString("ATTR_NON_PROFILED_NMETHODS_METHODS"), Messages.getString("ATTR_NON_PROFILED_NMETHODS_METHODS_DESCRIPTION"), UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> NON_NMETHODS_UNALLOCATED = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(UNALLOCATED, "CodeHeap 'non-nmethods'", "nonNmethodsUnallocated", Messages.getString("ATTR_NON_NMETHODS_UNALLOCATED"), Messages.getString("ATTR_NON_NMETHODS_UNALLOCATED_DESCRIPTION"), UnitLookup.MEMORY));
    public static final IAttribute<IQuantity> NON_NMETHODS_ENTRIES = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(ENTRIES, "CodeHeap 'non-nmethods'", "nonNmethodsEntries", Messages.getString("ATTR_NON_NMETHODS_ENTRIES"), Messages.getString("ATTR_NON_NMETHODS_ENTRIES_DESCRIPTION"), UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> NON_NMETHODS_ADAPTORS = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(ADAPTORS, "CodeHeap 'non-nmethods'", "nonNmethodsAdaptors", Messages.getString("ATTR_NON_NMETHODS_ADAPTORS"), Messages.getString("ATTR_NON_NMETHODS_ADAPTORS_DESCRIPTION"), UnitLookup.NUMBER));
    public static final IAttribute<String> CODE_HEAP = Attribute.attr("codeBlobType", Messages.getString("ATTR_CODE_HEAP"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> SWEEP_INDEX = Attribute.attr("sweepId", Messages.getString("ATTR_SWEEP_INDEX"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_FRACTION_INDEX = Attribute.attr("sweepFractionIndex", Messages.getString("ATTR_SWEEP_FRACTION_INDEX"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_METHOD_SWEPT = Attribute.attr("sweptCount", Messages.getString("ATTR_SWEEP_METHOD_SWEPT"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_METHOD_FLUSHED = Attribute.attr("flushedCount", Messages.getString("ATTR_SWEEP_METHOD_FLUSHED"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_METHOD_RECLAIMED = Attribute.attr("markedCount", Messages.getString("ATTR_SWEEP_METHOD_RECLAIMED"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_METHOD_ZOMBIFIED = Attribute.attr("zombifiedCount", Messages.getString("ATTR_SWEEP_METHOD_ZOMBIFIED"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> INITIAL_SIZE = Attribute.attr("initialSize", Messages.getString("ATTR_INITIAL_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> RESERVED_SIZE = Attribute.attr("reservedSize", Messages.getString("ATTR_RESERVED_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> EXPANSION_SIZE = Attribute.attr("expansionSize", Messages.getString("ATTR_EXPANSION_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> NON_PROFILED_SIZE = Attribute.attr("nonProfiledSize", Messages.getString("ATTR_NON_PROFILED_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> PROFILED_SIZE = Attribute.attr("profiledSize", Messages.getString("ATTR_PROFILED_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> NON_NMETHOD_SIZE = Attribute.attr("nonNMethodSize", Messages.getString("ATTR_NON_NMETHOD_SIZE"), UnitLookup.MEMORY);
    public static final IAttribute<String> ENVIRONMENT_KEY = Attribute.attr("key", Messages.getString("ATTR_ENVIRONMENT_KEY"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> ENVIRONMENT_VALUE = Attribute.attr("value", Messages.getString("ATTR_ENVIRONMENT_VALUE"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> EXCEPTION_THROWABLES_COUNT = Attribute.attr("throwables", Messages.getString("ATTR_EXCEPTION_THROWABLES_COUNT"), Messages.getString("ATTR_EXCEPTION_THROWABLES_COUNT_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<IMCType> EXCEPTION_THROWNCLASS = Attribute.attr("thrownClass", Messages.getString("ATTR_EXCEPTION_THROWNCLASS"), UnitLookup.CLASS);
    public static final IAttribute<String> EXCEPTION_THROWNCLASS_NAME = Attribute.canonicalize(new Attribute<String>("thrownClassName", Messages.getString("ATTR_EXCEPTION_THROWNCLASS_NAME"), Messages.getString("ATTR_EXCEPTION_THROWNCLASS_NAME_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = EXCEPTION_THROWNCLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : type.getFullName();
                }
            };
        }
    });
    public static final IAttribute<String> EXCEPTION_MESSAGE = Attribute.attr("message", Messages.getString("ATTR_EXCEPTION_MESSAGE"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> MONITOR_ADDRESS = Attribute.attr("address", Messages.getString("ATTR_MONITOR_ADDRESS"), UnitLookup.ADDRESS);
    public static final IAttribute<IMCType> MONITOR_CLASS = Attribute.attr("monitorClass", Messages.getString("ATTR_MONITOR_CLASS"), UnitLookup.CLASS);
    public static final IAttribute<IMCThread> MONITOR_PREVIOUS_OWNER = Attribute.attr("previousOwner", Messages.getString("ATTR_MONITOR_PREVIOUS_OWNER"), UnitLookup.THREAD);
    public static final IAttribute<IQuantity> OS_SWITCH_RATE = Attribute.attr("switchRate", Messages.getString("ATTR_OS_SWITCH_RATE"), UnitLookup.NUMBER);
    public static final IAttribute<String> REFERENCE_STATISTICS_TYPE = Attribute.attr("type", Messages.getString("ATTR_REFERENCE_STATISTICS_TYPE"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> REFERENCE_STATISTICS_COUNT = Attribute.attr("count", Messages.getString("ATTR_REFERENCE_STATISTICS_COUNT"), UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> GC_SUM_OF_PAUSES = Attribute.attr("sumOfPauses", Messages.getString("ATTR_GC_SUM_OF_PAUSES"), Messages.getString("ATTR_GC_SUM_OF_PAUSES_DESC"), UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> GC_LONGEST_PAUSE = Attribute.attr("longestPause", Messages.getString("ATTR_GC_LONGEST_PAUSE"), Messages.getString("ATTR_GC_LONGEST_PAUSE_DESC"), UnitLookup.TIMESPAN);
    public static final IAttribute<String> GC_NAME = Attribute.attr("name", Messages.getString("ATTR_GC_NAME"), Messages.getString("ATTR_GC_NAME_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> GC_CAUSE = Attribute.attr("cause", Messages.getString("ATTR_GC_CAUSE"), Messages.getString("ATTR_GC_CAUSE_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IMCOldObject> OBJECT = Attribute.attr("object", Messages.getString("ATTR_REFERRER"), Messages.getString("ATTR_REFERRER_DESC"), UnitLookup.OLD_OBJECT);
    public static final IAttribute<IQuantity> ALLOCATION_TIME = Attribute.attr("allocationTime", Messages.getString("ATTR_REFERRER"), Messages.getString("ATTR_REFERRER_DESC"), UnitLookup.TIMESTAMP);
    public static final IAttribute<IMCOldObjectGcRoot> GC_ROOT = Attribute.attr("root", Messages.getString("ATTR_GC_ROOT"), Messages.getString("ATTR_GC_ROOT_DESC"), UnitLookup.OLD_OBJECT_GC_ROOT);
    public static final IAttribute<IMCType> OLD_OBJECT_CLASS = Attribute.canonicalize(new Attribute<IMCType>("oldObjectClass", Messages.getString("ATTR_OLD_OBJECT_CLASS"), Messages.getString("ATTR_OLD_OBJECT_CLASS_DESC"), UnitLookup.CLASS){

        @Override
        public <U> IMemberAccessor<IMCType, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCType, U>(){

                @Override
                public IMCType getMember(U i) {
                    IMCOldObject object = (IMCOldObject)accessor.getMember(i);
                    return object == null ? null : object.getType();
                }
            };
        }
    });
    public static final IAttribute<String> OLD_OBJECT_DESCRIPTION = Attribute.canonicalize(new Attribute<String>("oldObjectDescription", Messages.getString("ATTR_OLD_OBJECT_DESCRIPTION"), Messages.getString("ATTR_OLD_OBJECT_DESCRIPTION_DESC"), UnitLookup.PLAIN_TEXT){

        @Override
        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                @Override
                public String getMember(U i) {
                    IMCOldObject object = (IMCOldObject)accessor.getMember(i);
                    return object == null ? null : object.getDescription();
                }
            };
        }
    });
    public static final IAttribute<Long> OLD_OBJECT_ARRAY_SIZE = Attribute.canonicalize(new Attribute<Long>("oldObjectArraySize", Messages.getString("ATTR_OLD_OBJECT_ARRAY_SIZE"), Messages.getString("ATTR_OLD_OBJECT_ARRAY_SIZE_DESC"), UnitLookup.RAW_LONG){

        @Override
        public <U> IMemberAccessor<Long, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<Long, U>(){

                @Override
                public Long getMember(U i) {
                    IMCOldObject object = (IMCOldObject)accessor.getMember(i);
                    return object != null && object.getReferrerArray() != null ? object.getReferrerArray().getSize() : null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> OLD_OBJECT_ADDRESS = Attribute.canonicalize(new Attribute<IQuantity>("oldObjectAddress", Messages.getString("ATTR_OLD_OBJECT_ADDRESS"), Messages.getString("ATTR_OLD_OBJECT_ADDRESS_DESC"), (ContentType)UnitLookup.ADDRESS){

        @Override
        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IQuantity, U>(){

                @Override
                public IQuantity getMember(U i) {
                    IMCOldObject object = (IMCOldObject)accessor.getMember(i);
                    return object == null ? null : object.getAddress();
                }
            };
        }
    });
    public static final IAttribute<String> OS_VERSION = Attribute.attr("osVersion", Messages.getString("ATTR_OS_VERSION"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> NUMBER_OF_SOCKETS = Attribute.attr("sockets", Messages.getString("ATTR_NUMBER_OF_SOCKETS"), Messages.getString("ATTR_NUMBER_OF_SOCKETS_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<String> CPU_DESCRIPTION = Attribute.attr("description", Messages.getString("ATTR_CPU_DESCRIPTION"), Messages.getString("ATTR_CPU_DESCRIPTION_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> CPU_TYPE = Attribute.attr("cpu", Messages.getString("ATTR_CPU_TYPE"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> NUMBER_OF_CORES = Attribute.attr("cores", Messages.getString("ATTR_NUMBER_OF_CORES"), Messages.getString("ATTR_NUMBER_OF_CORES_DESC"), UnitLookup.NUMBER);
    public static final IAttribute<Boolean> BLOCKING = Attribute.attr("blocking", Messages.getString("ATTR_BLOCKING"), Messages.getString("ATTR_BLOCKING_DESC"), UnitLookup.FLAG);
    public static final IAttribute<Boolean> SAFEPOINT = Attribute.attr("safepoint", Messages.getString("ATTR_SAFEPOINT"), Messages.getString("ATTR_SAFEPOINT_DESC"), UnitLookup.FLAG);
    public static final IAttribute<String> OPERATION = Attribute.attr("operation", Messages.getString("ATTR_OPERATION"), Messages.getString("ATTR_OPERATION_DESC"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IMCThread> CALLER = Attribute.attr("caller", Messages.getString("ATTR_CALLER"), Messages.getString("ATTR_CALLER_DESC"), UnitLookup.THREAD);
    public static final IAttribute<IMCType> BIASED_REVOCATION_LOCK_CLASS = Attribute.attr("lockClass", Messages.getString("ATTR_REVOKATION_LOCK_CLASS"), Messages.getString("ATTR_REVOKATION_LOCK_CLASS_DESC"), UnitLookup.CLASS);
    public static final IAttribute<IMCType> BIASED_REVOCATION_CLASS = Attribute.attr("revokedClass", Messages.getString("ATTR_REVOKED_CLASS"), Messages.getString("ATTR_REVOKED_CLASS_DESC"), UnitLookup.CLASS);
    public static final IAttribute<Boolean> BIASED_REVOCATION_DISABLE_BIASING = Attribute.attr("disableBiasing", Messages.getString("ATTR_DISABLE_BIASING"), UnitLookup.FLAG);
    public static final IAttribute<String> NATIVE_LIBRARY_NAME = Attribute.attr("name", Messages.getString("ATTR_NATIVE_LIBRARY_NAME"), UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> BASE_ADDRESS = Attribute.attr("baseAddress", Messages.getString("ATTR_BASE_ADDRESS"), UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> TOP_ADDRESS = Attribute.attr("topAddress", Messages.getString("ATTR_TOP_ADDRESS"), UnitLookup.ADDRESS);

    private static Attribute<IQuantity> createCodeHeapAttribute(final IAttribute<IQuantity> attribute, final String codeHeap, String identifier, String name, String description, ContentType<IQuantity> contentType) {
        return new Attribute<IQuantity>(identifier, name, description, contentType){

            @Override
            public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
                final IMemberAccessor attributeAccessor = attribute.getAccessor(type);
                final IMemberAccessor codeHeapAccessor = CODE_HEAP.getAccessor(type);
                return attributeAccessor == null || codeHeapAccessor == null ? null : new IMemberAccessor<IQuantity, U>(){

                    @Override
                    public IQuantity getMember(U i) {
                        return ((String)codeHeapAccessor.getMember(i)).equals(codeHeap) ? (IQuantity)attributeAccessor.getMember(i) : null;
                    }
                };
            }
        };
    }
}

