/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.UnrecoverableIllegalStateException;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.HeapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JVMStabilityInspector {
    private static final Logger logger = LoggerFactory.getLogger(JVMStabilityInspector.class);
    private static Killer killer = new Killer();
    private static Object lock = new Object();
    private static boolean printingHeapHistogram;
    public static OnKillHook killerHook;

    private JVMStabilityInspector() {
    }

    public static void inspectThrowable(Throwable t) throws OutOfMemoryError {
        JVMStabilityInspector.inspectThrowable(t, JVMStabilityInspector::inspectDiskError);
    }

    public static void inspectCommitLogThrowable(Throwable t) {
        JVMStabilityInspector.inspectThrowable(t, JVMStabilityInspector::inspectCommitLogError);
    }

    private static void inspectDiskError(Throwable t) {
        if (t instanceof CorruptSSTableException) {
            FileUtils.handleCorruptSSTable((CorruptSSTableException)t);
        } else if (t instanceof FSError) {
            FileUtils.handleFSError((FSError)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inspectThrowable(Throwable t, Consumer<Throwable> fn) throws OutOfMemoryError {
        boolean isUnstable = false;
        if (t instanceof OutOfMemoryError) {
            if (Boolean.getBoolean("cassandra.printHeapHistogramOnOutOfMemoryError")) {
                Object object = lock;
                synchronized (object) {
                    if (printingHeapHistogram) {
                        return;
                    }
                    printingHeapHistogram = true;
                }
                HeapUtils.logHeapHistogram();
            }
            logger.error("OutOfMemory error letting the JVM handle the error:", t);
            StorageService.instance.removeShutdownHook();
            JVMStabilityInspector.forceHeapSpaceOomMaybe((OutOfMemoryError)t);
            throw (OutOfMemoryError)t;
        }
        if (t instanceof UnrecoverableIllegalStateException) {
            isUnstable = true;
        }
        if (DatabaseDescriptor.getDiskFailurePolicy() == Config.DiskFailurePolicy.die && (t instanceof FSError || t instanceof CorruptSSTableException)) {
            isUnstable = true;
        }
        fn.accept(t);
        if ((t instanceof FileNotFoundException || t instanceof SocketException) && t.getMessage() != null && t.getMessage().contains("Too many open files")) {
            isUnstable = true;
        }
        if (isUnstable) {
            killer.killCurrentJVM(t);
        }
        if (t.getCause() != null) {
            JVMStabilityInspector.inspectThrowable(t.getCause(), fn);
        }
    }

    private static void forceHeapSpaceOomMaybe(OutOfMemoryError oom) {
        if (oom.getMessage() != null && oom.getMessage().toLowerCase().contains("direct buffer memory") || Arrays.stream(oom.getStackTrace()).anyMatch(x -> x.getClassName().equals("java.nio.Bits") && x.getMethodName().equals("reserveMemory"))) {
            logger.error("Force heap space OutOfMemoryError in the presence of", (Throwable)oom);
            ArrayList<long[]> ignored = new ArrayList<long[]>();
            while (true) {
                ignored.add(new long[0x3FFFFFFF]);
            }
        }
    }

    private static void inspectCommitLogError(Throwable t) {
        if (!StorageService.instance.isDaemonSetupCompleted()) {
            logger.error("Exiting due to error while processing commit log during initialization.", t);
            killer.killCurrentJVM(t, true);
        } else if (DatabaseDescriptor.getCommitFailurePolicy() == Config.CommitFailurePolicy.die) {
            killer.killCurrentJVM(t);
        }
    }

    public static void killCurrentJVM(Throwable t, boolean quiet) {
        killer.killCurrentJVM(t, quiet);
    }

    public static void userFunctionTimeout(Throwable t) {
        switch (DatabaseDescriptor.getUserFunctionTimeoutPolicy()) {
            case die: {
                ScheduledExecutors.nonPeriodicTasks.schedule(() -> killer.killCurrentJVM(t), 250L, TimeUnit.MILLISECONDS);
                break;
            }
            case die_immediate: {
                killer.killCurrentJVM(t);
                break;
            }
            case ignore: {
                logger.error(t.getMessage());
            }
        }
    }

    @VisibleForTesting
    public static Killer replaceKiller(Killer newKiller) {
        Killer oldKiller = killer;
        killer = newKiller;
        return oldKiller;
    }

    public static interface OnKillHook {
        public boolean execute(Throwable var1);
    }

    @VisibleForTesting
    public static class Killer {
        private final AtomicBoolean killing = new AtomicBoolean();

        protected void killCurrentJVM(Throwable t) {
            this.killCurrentJVM(t, false);
        }

        protected void killCurrentJVM(Throwable t, boolean quiet) {
            boolean doExit;
            if (!quiet) {
                t.printStackTrace(System.err);
                logger.error("JVM state determined to be unstable.  Exiting forcefully due to:", t);
            }
            boolean bl = doExit = killerHook != null ? killerHook.execute(t) : true;
            if (doExit && this.killing.compareAndSet(false, true)) {
                StorageService.instance.removeShutdownHook();
                System.exit(100);
            }
        }
    }
}

