/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.RatioGauge;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.DoubleSupplier;
import org.apache.cassandra.cache.CacheSize;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CacheMetrics {
    public final Gauge<Long> capacity;
    public final Gauge<Long> size;
    public final Gauge<Integer> entries;
    public final Meter hits;
    public final Meter misses;
    public final Meter requests;
    public final Gauge<Double> hitRate;
    public final Gauge<Double> oneMinuteHitRate;
    public final Gauge<Double> fiveMinuteHitRate;
    public final Gauge<Double> fifteenMinuteHitRate;
    protected final MetricNameFactory factory;

    public CacheMetrics(String type, CacheSize cache) {
        this.factory = new DefaultNameFactory("Cache", type);
        this.capacity = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("Capacity"), cache::capacity);
        this.size = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("Size"), cache::weightedSize);
        this.entries = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("Entries"), cache::size);
        this.hits = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Hits"));
        this.misses = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Misses"));
        this.requests = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Requests"));
        this.hitRate = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("HitRate"), CacheMetrics.ratioGauge(this.hits::getCount, this.requests::getCount));
        this.oneMinuteHitRate = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("OneMinuteHitRate"), CacheMetrics.ratioGauge(this.hits::getOneMinuteRate, this.requests::getOneMinuteRate));
        this.fiveMinuteHitRate = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("FiveMinuteHitRate"), CacheMetrics.ratioGauge(this.hits::getFiveMinuteRate, this.requests::getFiveMinuteRate));
        this.fifteenMinuteHitRate = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("FifteenMinuteHitRate"), CacheMetrics.ratioGauge(this.hits::getFifteenMinuteRate, this.requests::getFifteenMinuteRate));
    }

    @VisibleForTesting
    public void reset() {
        this.hits.mark(-this.hits.getCount());
        this.misses.mark(-this.misses.getCount());
        this.requests.mark(-this.requests.getCount());
    }

    private static RatioGauge ratioGauge(final DoubleSupplier numeratorSupplier, final DoubleSupplier denominatorSupplier) {
        return new RatioGauge(){

            @Override
            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(numeratorSupplier.getAsDouble(), denominatorSupplier.getAsDouble());
            }
        };
    }
}

