/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.memory;

import java.nio.ByteBuffer;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.memory.KeyRangeIterator;
import org.apache.cassandra.index.sasi.memory.MemIndex;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.index.sasi.utils.RangeUnionIterator;

public class SkipListMemIndex
extends MemIndex {
    public static final int CSLM_OVERHEAD = 128;
    private final ConcurrentSkipListMap<ByteBuffer, ConcurrentSkipListSet<DecoratedKey>> index;

    public SkipListMemIndex(AbstractType<?> keyValidator, ColumnIndex columnIndex) {
        super(keyValidator, columnIndex);
        this.index = new ConcurrentSkipListMap(columnIndex.getValidator());
    }

    @Override
    public long add(DecoratedKey key, ByteBuffer value) {
        ConcurrentSkipListSet<DecoratedKey> newKeys;
        long overhead = 128L;
        ConcurrentSkipListSet<DecoratedKey> keys = this.index.get(value);
        if (keys == null && (keys = this.index.putIfAbsent(value, newKeys = new ConcurrentSkipListSet<DecoratedKey>(DecoratedKey.comparator))) == null) {
            overhead += (long)(128 + value.remaining());
            keys = newKeys;
        }
        keys.add(key);
        return overhead;
    }

    @Override
    public RangeIterator<Long, Token> search(Expression expression) {
        ByteBuffer max;
        ByteBuffer min2 = expression.lower == null ? null : expression.lower.value;
        ByteBuffer byteBuffer = max = expression.upper == null ? null : expression.upper.value;
        if (min2 == null && max == null) {
            throw new IllegalArgumentException();
        }
        NavigableMap search = min2 != null && max != null ? this.index.subMap((Object)min2, expression.lower.inclusive, (Object)max, expression.upper.inclusive) : (min2 == null ? this.index.headMap((Object)max, expression.upper.inclusive) : this.index.tailMap((Object)min2, expression.lower.inclusive));
        RangeUnionIterator.Builder<Long, Token> builder = RangeUnionIterator.builder();
        for (ConcurrentSkipListSet keys : search.values()) {
            int size = keys.size();
            if (size <= 0) continue;
            builder.add(new KeyRangeIterator(keys, size));
        }
        return builder.build();
    }
}

