/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.cql3.functions.types.CodecRegistry;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.Metadata;
import org.apache.cassandra.cql3.functions.types.UDTValue;
import org.apache.cassandra.transport.ProtocolVersion;

public class UserType
extends DataType
implements Iterable<Field> {
    private final String keyspace;
    private final String typeName;
    private final boolean frozen;
    private final ProtocolVersion protocolVersion;
    private final CodecRegistry codecRegistry;
    final Field[] byIdx;
    final Map<String, int[]> byName;

    private UserType(DataType.Name name, String keyspace, String typeName, boolean frozen, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, Field[] byIdx, Map<String, int[]> byName) {
        super(name);
        this.keyspace = keyspace;
        this.typeName = typeName;
        this.frozen = frozen;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.byIdx = byIdx;
        this.byName = byName;
    }

    UserType(String keyspace, String typeName, boolean frozen, Collection<Field> fields, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        this(DataType.Name.UDT, keyspace, typeName, frozen, protocolVersion, codecRegistry, fields.toArray(new Field[fields.size()]), UserType.mapByName(fields));
    }

    private static ImmutableMap<String, int[]> mapByName(Collection<Field> fields) {
        ImmutableMap.Builder<String, int[]> builder = new ImmutableMap.Builder<String, int[]>();
        int i = 0;
        for (Field field : fields) {
            builder.put(field.getName(), new int[]{i++});
        }
        return builder.build();
    }

    public UDTValue newValue() {
        return new UDTValue(this);
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int size() {
        return this.byIdx.length;
    }

    public boolean contains(String name) {
        return this.byName.containsKey(Metadata.handleId(name));
    }

    @Override
    public Iterator<Field> iterator() {
        return Iterators.forArray(this.byIdx);
    }

    DataType getFieldType(String name) {
        int[] idx = this.byName.get(Metadata.handleId(name));
        if (idx == null) {
            throw new IllegalArgumentException(name + " is not a field defined in this definition");
        }
        return this.byIdx[idx[0]].getType();
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    public UserType copy(boolean newFrozen) {
        if (newFrozen == this.frozen) {
            return this;
        }
        return new UserType(this.name, this.keyspace, this.typeName, newFrozen, this.protocolVersion, this.codecRegistry, this.byIdx, this.byName);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.keyspace.hashCode();
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + Arrays.hashCode(this.byIdx);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)o;
        return this.name.equals((Object)other.name) && this.keyspace.equals(other.keyspace) && this.typeName.equals(other.typeName) && Arrays.equals(this.byIdx, other.byIdx);
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public String toString() {
        String str = Metadata.quoteIfNecessary(this.getKeyspace()) + '.' + Metadata.quoteIfNecessary(this.getTypeName());
        return this.isFrozen() ? "frozen<" + str + '>' : str;
    }

    @Override
    public String asFunctionParameterString() {
        return Metadata.quoteIfNecessary(this.getTypeName());
    }

    public static class Field {
        private final String name;
        private final DataType type;

        Field(String name, DataType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.type});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            return this.name.equals(other.name) && this.type.equals(other.type);
        }

        public String toString() {
            return Metadata.quoteIfNecessary(this.name) + ' ' + this.type;
        }
    }
}

