/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.api;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.api.CommitLogMarkers;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.cdc.api.PerInstanceCommitLogMarkers;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.jetbrains.annotations.NotNull;

public class PerRangeCommitLogMarkers
implements CommitLogMarkers {
    private final Map<CassandraInstance, Map<TokenRange, Marker>> markers;

    public PerRangeCommitLogMarkers(Map<CassandraInstance, Map<TokenRange, Marker>> markers) {
        this.markers = ImmutableMap.copyOf(markers);
    }

    @Override
    @NotNull
    public Marker startMarker(CassandraInstance instance) {
        return this.markers.getOrDefault(instance, (Map<TokenRange, Marker>)ImmutableMap.of()).values().stream().min(Marker::compareTo).orElseGet(instance::zeroMarker);
    }

    @Override
    public boolean canIgnore(Marker position, BigInteger token) {
        Map<TokenRange, Marker> instMarkers = this.markers.get(position.instance());
        if (instMarkers == null || instMarkers.isEmpty()) {
            return false;
        }
        return instMarkers.entrySet().stream().filter(entry -> ((TokenRange)entry.getKey()).contains(token)).map(Map.Entry::getValue).anyMatch(position::isBefore);
    }

    public int size() {
        return this.markers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.markers.isEmpty();
    }

    @Override
    public Collection<Marker> values() {
        return this.markers.keySet().stream().map(this::startMarker).collect(Collectors.toList());
    }

    @Override
    public PerInstanceCommitLogMarkers.PerInstanceBuilder mutate() {
        return new PerInstanceCommitLogMarkers.PerInstanceBuilder(this.markers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).values().stream().min(Marker::compareTo).orElse(((CassandraInstance)e.getKey()).zeroMarker()))));
    }

    public int hashCode() {
        return Objects.hash(this.markers);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PerRangeCommitLogMarkers rhs = (PerRangeCommitLogMarkers)obj;
        return this.markers.equals(rhs.markers);
    }

    public String toString() {
        return "PerRange{markers=" + String.valueOf(this.markers) + "}";
    }

    public static class PerRangeBuilder {
        private final Map<CassandraInstance, Map<TokenRange, Marker>> markers = new HashMap<CassandraInstance, Map<TokenRange, Marker>>();

        public PerRangeBuilder add(@NotNull TokenRange tokenRange, @NotNull Marker marker) {
            this.markers.computeIfAbsent(marker.instance(), inst -> new HashMap()).put(tokenRange, marker);
            return this;
        }

        public PerRangeCommitLogMarkers build() {
            return new PerRangeCommitLogMarkers(this.markers);
        }

        public int hashCode() {
            return Objects.hash(this.markers);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PerRangeBuilder)) {
                return false;
            }
            PerRangeBuilder that = (PerRangeBuilder)other;
            return Objects.equals(this.markers, that.markers);
        }
    }
}

