/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge.type;

import java.io.Serializable;
import java.util.Objects;

public class InternalDuration
implements Serializable {
    private static final long serialVersionUID = -6867844786318937949L;
    public final int months;
    public final int days;
    public final long nanoseconds;

    public InternalDuration(int months, int days, long nanoseconds) {
        this.months = months;
        this.days = days;
        this.nanoseconds = nanoseconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalDuration that = (InternalDuration)o;
        return this.months == that.months && this.days == that.days && this.nanoseconds == that.nanoseconds;
    }

    public int hashCode() {
        return Objects.hash(this.months, this.days, this.nanoseconds);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.months < 0 || this.days < 0 || this.nanoseconds < 0L) {
            builder.append('-');
        }
        builder.append("mo").append(Math.abs(this.months));
        builder.append("d").append(Math.abs(this.days));
        builder.append("ns").append(Math.abs(this.nanoseconds));
        return builder.toString();
    }
}

