/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.eventbus;

import java.util.function.Function;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.Fluent;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.GenIgnore;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.Nullable;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.VertxGen;
import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.DeliveryContext;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.DeliveryOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.Message;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.MessageCodec;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.MessageConsumer;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.MessageProducer;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.DefaultSerializableChecker;
import o.a.c.sidecar.client.shaded.io.vertx.core.metrics.Measured;

@VertxGen
public interface EventBus
extends Measured {
    @GenIgnore
    public static final Function<String, Boolean> DEFAULT_SERIALIZABLE_CHECKER = DefaultSerializableChecker.INSTANCE::check;

    @Fluent
    public EventBus send(String var1, @Nullable Object var2);

    @Fluent
    public EventBus send(String var1, @Nullable Object var2, DeliveryOptions var3);

    @Fluent
    default public <T> EventBus request(String address, @Nullable Object message, Handler<AsyncResult<Message<T>>> replyHandler) {
        return this.request(address, message, new DeliveryOptions(), replyHandler);
    }

    default public <T> Future<Message<T>> request(String address, @Nullable Object message) {
        return this.request(address, message, new DeliveryOptions());
    }

    @Fluent
    default public <T> EventBus request(String address, @Nullable Object message, DeliveryOptions options, Handler<AsyncResult<Message<T>>> replyHandler) {
        Future reply = this.request(address, message, options);
        reply.onComplete(replyHandler);
        return this;
    }

    public <T> Future<Message<T>> request(String var1, @Nullable Object var2, DeliveryOptions var3);

    @Fluent
    public EventBus publish(String var1, @Nullable Object var2);

    @Fluent
    public EventBus publish(String var1, @Nullable Object var2, DeliveryOptions var3);

    public <T> MessageConsumer<T> consumer(String var1);

    public <T> MessageConsumer<T> consumer(String var1, Handler<Message<T>> var2);

    public <T> MessageConsumer<T> localConsumer(String var1);

    public <T> MessageConsumer<T> localConsumer(String var1, Handler<Message<T>> var2);

    public <T> MessageProducer<T> sender(String var1);

    public <T> MessageProducer<T> sender(String var1, DeliveryOptions var2);

    public <T> MessageProducer<T> publisher(String var1);

    public <T> MessageProducer<T> publisher(String var1, DeliveryOptions var2);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public EventBus registerCodec(MessageCodec var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public EventBus unregisterCodec(String var1);

    @Fluent
    @GenIgnore
    public <T> EventBus registerDefaultCodec(Class<T> var1, MessageCodec<T, ?> var2);

    @Fluent
    @GenIgnore
    public EventBus unregisterDefaultCodec(Class var1);

    @Fluent
    public EventBus codecSelector(Function<Object, String> var1);

    @Fluent
    public <T> EventBus addOutboundInterceptor(Handler<DeliveryContext<T>> var1);

    @Fluent
    public <T> EventBus removeOutboundInterceptor(Handler<DeliveryContext<T>> var1);

    @Fluent
    public <T> EventBus addInboundInterceptor(Handler<DeliveryContext<T>> var1);

    @Fluent
    public <T> EventBus removeInboundInterceptor(Handler<DeliveryContext<T>> var1);

    @Fluent
    public EventBus clusterSerializableChecker(Function<String, Boolean> var1);

    @Fluent
    public EventBus serializableChecker(Function<String, Boolean> var1);
}

