/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client;

import java.time.Duration;
import o.a.c.sidecar.client.shaded.client.SidecarClientConfig;
import o.a.c.sidecar.client.shaded.common.DataObjectBuilder;

public class SidecarClientConfigImpl
implements SidecarClientConfig {
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final long DEFAULT_RETRY_DELAY_MILLIS = 500L;
    public static final long DEFAULT_MAX_RETRY_DELAY_MILLIS = 60000L;
    public static final Duration DEFAULT_MINIMUM_HEALTH_RETRY_DELAY = Duration.ofSeconds(1L);
    public static final Duration DEFAULT_MAXIMUM_HEALTH_RETRY_DELAY = Duration.ofSeconds(5L);
    protected final int maxRetries;
    protected final long retryDelayMillis;
    protected final long maxRetryDelayMillis;
    protected final Duration minimumHealthRetryDelay;
    protected final Duration maximumHealthRetryDelay;

    private SidecarClientConfigImpl(Builder builder) {
        this.maxRetries = builder.maxRetries;
        this.retryDelayMillis = builder.retryDelayMillis;
        this.maxRetryDelayMillis = builder.maxRetryDelayMillis;
        this.minimumHealthRetryDelay = builder.minimumHealthRetryDelay;
        this.maximumHealthRetryDelay = builder.maximumHealthRetryDelay;
    }

    @Override
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    public long retryDelayMillis() {
        return this.retryDelayMillis;
    }

    @Override
    public long maxRetryDelayMillis() {
        return this.maxRetryDelayMillis;
    }

    @Override
    public Duration minimumHealthRetryDelay() {
        return this.minimumHealthRetryDelay;
    }

    @Override
    public Duration maximumHealthRetryDelay() {
        return this.maximumHealthRetryDelay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements DataObjectBuilder<Builder, SidecarClientConfig> {
        protected int maxRetries = 3;
        protected long retryDelayMillis = 500L;
        protected long maxRetryDelayMillis = 60000L;
        protected Duration minimumHealthRetryDelay = DEFAULT_MINIMUM_HEALTH_RETRY_DELAY;
        protected Duration maximumHealthRetryDelay = DEFAULT_MAXIMUM_HEALTH_RETRY_DELAY;

        protected Builder() {
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            return this.update(b -> {
                b.maxRetries = maxRetries;
            });
        }

        public Builder retryDelayMillis(long retryDelayMillis) {
            return this.update(b -> {
                b.retryDelayMillis = retryDelayMillis;
            });
        }

        public Builder maxRetryDelayMillis(long maxRetryDelayMillis) {
            return this.update(b -> {
                b.maxRetryDelayMillis = maxRetryDelayMillis;
            });
        }

        public Builder minimumHealthRetryDelay(Duration minimumHealthRetryDelay) {
            return this.update(builder -> {
                builder.minimumHealthRetryDelay = minimumHealthRetryDelay;
            });
        }

        public Builder maximumHealthRetryDelay(Duration maximumHealthRetryDelay) {
            return this.update(builder -> {
                builder.maximumHealthRetryDelay = maximumHealthRetryDelay;
            });
        }

        @Override
        public SidecarClientConfig build() {
            return new SidecarClientConfigImpl(this);
        }
    }
}

