/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc;

import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import org.apache.cassandra.cdc.Cdc;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.api.CdcOptions;
import org.apache.cassandra.cdc.api.CommitLogProvider;
import org.apache.cassandra.cdc.api.EventConsumer;
import org.apache.cassandra.cdc.api.SchemaSupplier;
import org.apache.cassandra.cdc.api.StatePersister;
import org.apache.cassandra.cdc.api.TableIdLookup;
import org.apache.cassandra.cdc.api.TokenRangeSupplier;
import org.apache.cassandra.cdc.stats.CdcStats;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdcBuilder {
    @NotNull
    protected final String jobId;
    protected final int partitionId;
    @NotNull
    TokenRangeSupplier tokenRangeSupplier = () -> null;
    @NotNull
    protected SchemaSupplier schemaSupplier;
    @NotNull
    CassandraSource cassandraSource = CassandraSource.DEFAULT;
    @NotNull
    StatePersister statePersister = StatePersister.STUB;
    @NotNull
    protected CdcOptions cdcOptions = CdcOptions.DEFAULT;
    @NotNull
    ICdcStats stats = ICdcStats.STUB;
    @NotNull
    protected AsyncExecutor asyncExecutor = null;
    @Nullable
    protected CommitLogProvider commitLogProvider = null;
    @NotNull
    protected EventConsumer eventConsumer;
    @NotNull
    public TableIdLookup tableIdLookup = TableIdLookup.STUB;

    public CdcBuilder(@NotNull String jobId, int partitionId, @NotNull EventConsumer eventConsumer, @NotNull SchemaSupplier schemaSupplier) {
        this.jobId = jobId;
        this.partitionId = partitionId;
        this.eventConsumer = eventConsumer;
        this.schemaSupplier = schemaSupplier;
    }

    public CdcBuilder withTokenRangeSupplier(@NotNull TokenRangeSupplier tokenRangeSupplier) {
        this.tokenRangeSupplier = tokenRangeSupplier;
        return this;
    }

    public CdcBuilder withCassandraSource(@NotNull CassandraSource cassandraSource) {
        this.cassandraSource = cassandraSource;
        return this;
    }

    public CdcBuilder withStatePersister(@NotNull StatePersister statePersister) {
        this.statePersister = statePersister;
        return this;
    }

    public CdcBuilder withCdcOptions(@NotNull CdcOptions cdcOptions) {
        this.cdcOptions = cdcOptions;
        return this;
    }

    public CdcBuilder withExecutor(@NotNull ExecutorService executor) {
        return this.withExecutor(AsyncExecutor.wrap((ExecutorService)executor));
    }

    public CdcBuilder withExecutor(@NotNull AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
        return this;
    }

    public CdcBuilder withCommitLogProvider(@NotNull CommitLogProvider commitLogProvider) {
        this.commitLogProvider = commitLogProvider;
        return this;
    }

    public CdcBuilder withStats(@NotNull CdcStats stats) {
        this.stats = stats;
        return this;
    }

    public CdcBuilder withEventConsumer(@NotNull EventConsumer eventConsumer) {
        this.eventConsumer = eventConsumer;
        return this;
    }

    public CdcBuilder withTableIdLookup(@NotNull TableIdLookup tableIdLookup) {
        this.tableIdLookup = tableIdLookup;
        return this;
    }

    public CdcBuilder withSchemaSupplier(@NotNull SchemaSupplier schemaSupplier) {
        this.schemaSupplier = schemaSupplier;
        return this;
    }

    public Cdc build() {
        Preconditions.checkNotNull((Object)this.commitLogProvider, (Object)"A CommitLogProvider must be supplied");
        Preconditions.checkNotNull((Object)this.asyncExecutor, (Object)"An AsyncExecutor must be supplied");
        Preconditions.checkNotNull((Object)this.eventConsumer, (Object)"An event consumer supplier must be supplied");
        Preconditions.checkNotNull((Object)this.schemaSupplier, (Object)"An schema supplier must be supplied");
        return new Cdc(this);
    }
}

