/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.data;

import java.util.HashMap;

public class SSTableImportOptions
extends HashMap<String, String> {
    private static final String RESET_LEVEL = "resetLevel";
    private static final String CLEAR_REPAIRED = "clearRepaired";
    private static final String VERIFY_SSTABLES = "verifySSTables";
    private static final String VERIFY_TOKENS = "verifyTokens";
    private static final String INVALIDATE_CACHES = "invalidateCaches";
    private static final String EXTENDED_VERIFY = "extendedVerify";
    private static final String COPY_DATA = "copyData";

    public static SSTableImportOptions defaults() {
        return new SSTableImportOptions();
    }

    private SSTableImportOptions() {
        this.put(RESET_LEVEL, Boolean.toString(true));
        this.put(CLEAR_REPAIRED, Boolean.toString(true));
        this.put(VERIFY_SSTABLES, Boolean.toString(true));
        this.put(VERIFY_TOKENS, Boolean.toString(true));
        this.put(INVALIDATE_CACHES, Boolean.toString(true));
        this.put(EXTENDED_VERIFY, Boolean.toString(true));
        this.put(COPY_DATA, Boolean.toString(false));
    }

    public SSTableImportOptions resetLevel(boolean enabled) {
        this.put(RESET_LEVEL, Boolean.toString(enabled));
        return this;
    }

    public boolean resetLevel() {
        return Boolean.parseBoolean((String)this.get(RESET_LEVEL));
    }

    public SSTableImportOptions clearRepaired(boolean enabled) {
        this.put(CLEAR_REPAIRED, Boolean.toString(enabled));
        return this;
    }

    public boolean clearRepaired() {
        return Boolean.parseBoolean((String)this.get(CLEAR_REPAIRED));
    }

    public SSTableImportOptions verifySSTables(boolean enabled) {
        this.put(VERIFY_SSTABLES, Boolean.toString(enabled));
        return this;
    }

    public boolean verifySSTables() {
        return Boolean.parseBoolean((String)this.get(VERIFY_SSTABLES));
    }

    public SSTableImportOptions verifyTokens(boolean enabled) {
        this.put(VERIFY_TOKENS, Boolean.toString(enabled));
        return this;
    }

    public boolean verifyTokens() {
        return Boolean.parseBoolean((String)this.get(VERIFY_TOKENS));
    }

    public SSTableImportOptions invalidateCaches(boolean enabled) {
        this.put(INVALIDATE_CACHES, Boolean.toString(enabled));
        return this;
    }

    public boolean invalidateCaches() {
        return Boolean.parseBoolean((String)this.get(INVALIDATE_CACHES));
    }

    public SSTableImportOptions extendedVerify(boolean enabled) {
        this.put(EXTENDED_VERIFY, Boolean.toString(enabled));
        return this;
    }

    public boolean extendedVerify() {
        return Boolean.parseBoolean((String)this.get(EXTENDED_VERIFY));
    }

    public SSTableImportOptions copyData(boolean enabled) {
        this.put(COPY_DATA, Boolean.toString(enabled));
        return this;
    }

    public boolean copyData() {
        return Boolean.parseBoolean((String)this.get(COPY_DATA));
    }
}

