/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.sparksql.CassandraInputPartition;
import org.apache.cassandra.spark.sparksql.CassandraPartitionReaderFactory;
import org.apache.cassandra.spark.sparksql.CassandraPartitioning;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.utils.FilterUtils;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.connector.read.SupportsReportPartitioning;
import org.apache.spark.sql.connector.read.partitioning.Partitioning;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

class CassandraScanBuilder
implements ScanBuilder,
Scan,
Batch,
SupportsPushDownFilters,
SupportsPushDownRequiredColumns,
SupportsReportPartitioning {
    final DataLayer dataLayer;
    final StructType schema;
    final CaseInsensitiveStringMap options;
    StructType requiredSchema = null;
    Filter[] pushedFilters = new Filter[0];

    CassandraScanBuilder(DataLayer dataLayer, StructType schema, CaseInsensitiveStringMap options) {
        this.dataLayer = dataLayer;
        this.schema = schema;
        this.options = options;
    }

    public Scan build() {
        return this;
    }

    public void pruneColumns(StructType requiredSchema) {
        this.requiredSchema = requiredSchema;
    }

    public Filter[] pushFilters(Filter[] filters) {
        Filter[] unsupportedFilters = this.dataLayer.unsupportedPushDownFilters(filters);
        ArrayList<Filter> supportedFilters = new ArrayList<Filter>(Arrays.asList(filters));
        supportedFilters.removeAll(Arrays.asList(unsupportedFilters));
        this.pushedFilters = supportedFilters.toArray(new Filter[0]);
        return unsupportedFilters;
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters;
    }

    public StructType readSchema() {
        return this.requiredSchema;
    }

    public Batch toBatch() {
        return this;
    }

    public InputPartition[] planInputPartitions() {
        return (InputPartition[])IntStream.range(0, this.dataLayer.partitionCount()).mapToObj(CassandraInputPartition::new).toArray(InputPartition[]::new);
    }

    public PartitionReaderFactory createReaderFactory() {
        return new CassandraPartitionReaderFactory(this.dataLayer, this.requiredSchema, this.buildPartitionKeyFilters());
    }

    public Partitioning outputPartitioning() {
        return new CassandraPartitioning(this.dataLayer);
    }

    private List<PartitionKeyFilter> buildPartitionKeyFilters() {
        List partitionKeyColumnNames = this.dataLayer.cqlTable().partitionKeys().stream().map(CqlField::name).collect(Collectors.toList());
        Map<String, List<String>> partitionKeyValues = FilterUtils.extractPartitionKeyValues(this.pushedFilters, new HashSet<String>(partitionKeyColumnNames));
        if (partitionKeyValues.size() > 0) {
            List<List<String>> orderedValues = partitionKeyColumnNames.stream().map(partitionKeyValues::get).collect(Collectors.toList());
            return FilterUtils.cartesianProduct(orderedValues).stream().map(this::buildFilter).collect(Collectors.toList());
        }
        return new ArrayList<PartitionKeyFilter>();
    }

    private PartitionKeyFilter buildFilter(List<String> keys) {
        AbstractMap.SimpleEntry filterKey = this.dataLayer.bridge().getPartitionKey(this.dataLayer.cqlTable(), this.dataLayer.partitioner(), keys);
        return PartitionKeyFilter.create((ByteBuffer)((ByteBuffer)filterKey.getKey()), (BigInteger)((BigInteger)filterKey.getValue()));
    }
}

