/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BoundType;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.spark.data.model.TokenOwner;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.jetbrains.annotations.NotNull;

public final class RangeUtils {
    private RangeUtils() {
    }

    public static BigInteger sizeOf(Range<BigInteger> range) {
        Preconditions.checkArgument((((BigInteger)range.lowerEndpoint()).compareTo((BigInteger)range.upperEndpoint()) <= 0 ? 1 : 0) != 0, (Object)"RangeUtils assume ranges are not wrap-around");
        Preconditions.checkArgument((boolean)RangeUtils.isOpenClosedRange(range), (Object)"Input must be an open-closed range");
        if (range.isEmpty()) {
            return BigInteger.ZERO;
        }
        return ((BigInteger)range.upperEndpoint()).subtract((BigInteger)range.lowerEndpoint());
    }

    public static boolean isOpenClosedRange(Range<?> range) {
        return range.lowerBoundType() == BoundType.OPEN && range.upperBoundType() == BoundType.CLOSED;
    }

    public static List<Range<BigInteger>> split(Range<BigInteger> range, int nrSplits) {
        Preconditions.checkArgument((((BigInteger)range.lowerEndpoint()).compareTo((BigInteger)range.upperEndpoint()) <= 0 ? 1 : 0) != 0, (Object)"RangeUtils assume ranges are not wrap-around");
        Preconditions.checkArgument((boolean)RangeUtils.isOpenClosedRange(range), (Object)"Input must be an open-closed range");
        if (range.isEmpty()) {
            return Collections.emptyList();
        }
        if (nrSplits == 1 || RangeUtils.sizeOf(range).equals(BigInteger.ONE)) {
            return Collections.singletonList(range);
        }
        Preconditions.checkArgument((nrSplits >= 1 ? 1 : 0) != 0, (Object)"nrSplits must be greater than or equal to 1");
        BigInteger[] divideAndRemainder = RangeUtils.sizeOf(range).divideAndRemainder(BigInteger.valueOf(nrSplits));
        BigInteger quotient = divideAndRemainder[0];
        int remainder = divideAndRemainder[1].intValue();
        BigInteger lowerEndpoint = (BigInteger)range.lowerEndpoint();
        ArrayList<Range<BigInteger>> splits = new ArrayList<Range<BigInteger>>();
        for (int i = 0; i < nrSplits; ++i) {
            BigInteger upperEndpoint = lowerEndpoint.add(quotient);
            if (remainder > 0) {
                upperEndpoint = upperEndpoint.add(BigInteger.ONE);
                --remainder;
            }
            if (i + 1 == nrSplits || upperEndpoint.compareTo((BigInteger)range.upperEndpoint()) >= 0) {
                splits.add((Range<BigInteger>)Range.openClosed((Comparable)lowerEndpoint, (Comparable)((BigInteger)range.upperEndpoint())));
                break;
            }
            splits.add((Range<BigInteger>)Range.openClosed((Comparable)lowerEndpoint, (Comparable)upperEndpoint));
            lowerEndpoint = upperEndpoint;
        }
        return splits;
    }

    public static <Instance extends TokenOwner> Multimap<Instance, Range<BigInteger>> calculateTokenRanges(List<Instance> instances, int replicationFactor, Partitioner partitioner) {
        Preconditions.checkArgument((replicationFactor != 0 ? 1 : 0) != 0, (Object)"Calculation token ranges wouldn't work with RF 0");
        Preconditions.checkArgument((instances.isEmpty() || replicationFactor <= instances.size() ? 1 : 0) != 0, (Object)("Calculation token ranges wouldn't work when RF (" + replicationFactor + ") is greater than number of Cassandra instances " + instances.size()));
        ArrayListMultimap tokenRanges = ArrayListMultimap.create();
        for (int index = 0; index < instances.size(); ++index) {
            BigInteger rangeEnd;
            TokenOwner instance = (TokenOwner)instances.get(index);
            int disjointReplica = (instances.size() + index - replicationFactor) % instances.size();
            BigInteger rangeStart = new BigInteger(((TokenOwner)instances.get(disjointReplica)).token());
            if (rangeStart.compareTo(rangeEnd = new BigInteger(instance.token())) >= 0) {
                tokenRanges.put((Object)instance, (Object)Range.openClosed((Comparable)rangeStart, (Comparable)partitioner.maxToken()));
                if (rangeEnd.equals(partitioner.minToken())) continue;
                tokenRanges.put((Object)instance, (Object)Range.openClosed((Comparable)partitioner.minToken(), (Comparable)rangeEnd));
                continue;
            }
            tokenRanges.put((Object)instance, (Object)Range.openClosed((Comparable)rangeStart, (Comparable)rangeEnd));
        }
        return tokenRanges;
    }

    @NotNull
    public static TokenRange toTokenRange(@NotNull Range<BigInteger> range) {
        Preconditions.checkArgument((boolean)RangeUtils.isOpenClosedRange(range), (Object)"Input must be an open-closed range");
        return TokenRange.openClosed((BigInteger)range.lowerEndpoint(), (BigInteger)range.upperEndpoint());
    }

    @NotNull
    public static Range<BigInteger> fromTokenRange(@NotNull TokenRange range) {
        return Range.openClosed((Comparable)range.lowerEndpoint(), (Comparable)range.upperEndpoint());
    }

    public static int bigIntegerByteArraySize(BigInteger bi) {
        return bi.bitLength() / 8 + 1;
    }
}

