/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.type.InternalDuration;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.bulkwriter.SqlToCqlTypeConverter;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.SparkTypeUtils;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;

public class DataTypeSerializationTests {
    private static final int MAX_TESTS = 1000;

    @Test
    public void testVarInt() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(500L))).isInstanceOf(Decimal.class);
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(500L))).isEqualTo((Object)Decimal.apply((int)500));
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(500L))).isNotEqualTo((Object)Decimal.apply((int)501));
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(-1L))).isEqualTo((Object)Decimal.apply((int)-1));
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(Long.MAX_VALUE))).isEqualTo((Object)Decimal.apply((long)Long.MAX_VALUE));
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(Long.MIN_VALUE))).isEqualTo((Object)Decimal.apply((long)Long.MIN_VALUE));
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(Integer.MAX_VALUE))).isEqualTo((Object)Decimal.apply((int)Integer.MAX_VALUE));
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(Integer.MIN_VALUE))).isEqualTo((Object)Decimal.apply((int)Integer.MIN_VALUE));
            BigInteger veryLargeValue = BigInteger.valueOf(Integer.MAX_VALUE).multiply(BigInteger.valueOf(5L));
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, veryLargeValue)).isEqualTo((Object)Decimal.apply((BigInteger)veryLargeValue));
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.bigIntegers().ofBytes(128)).checkAssert(integer -> Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, integer)).isEqualTo((Object)Decimal.apply((BigInteger)integer)));
        });
    }

    @Test
    public void testInt() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toInt(bridge, 5)).isInstanceOf(Integer.class);
            Assertions.assertThat((Object)bridge.aInt().deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), ByteBuffer.allocate(4).putInt(0, 999))).isEqualTo((Object)999);
            QuickTheory.qt().forAll(SourceDSL.integers().all()).checkAssert(integer -> Assertions.assertThat((Object)DataTypeSerializationTests.toInt(bridge, integer)).isEqualTo(integer));
        });
    }

    @Test
    public void testBoolean() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toBool(bridge, true)).isInstanceOf(Boolean.class);
            Assertions.assertThat((Boolean)((Boolean)DataTypeSerializationTests.toBool(bridge, true))).isTrue();
            Assertions.assertThat((Boolean)((Boolean)DataTypeSerializationTests.toBool(bridge, false))).isFalse();
        });
    }

    @Test
    public void testTimeUUID() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toTimeUUID(bridge, RandomUtils.getRandomTimeUUIDForTesting())).isInstanceOf(UTF8String.class);
            for (int test = 0; test < 1000; ++test) {
                UUID expected = RandomUtils.getRandomTimeUUIDForTesting();
                Assertions.assertThat((String)DataTypeSerializationTests.toTimeUUID(bridge, expected).toString()).isEqualTo(expected.toString());
            }
        });
    }

    @Test
    public void testUUID() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toUUID(bridge, UUID.randomUUID())).isInstanceOf(UTF8String.class);
            for (int test = 0; test < 1000; ++test) {
                UUID expected = UUID.randomUUID();
                Assertions.assertThat((String)DataTypeSerializationTests.toUUID(bridge, expected).toString()).isEqualTo(expected.toString());
            }
        });
    }

    @Test
    public void testLong() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toBigInt(bridge, Long.MAX_VALUE)).isInstanceOf(Long.class);
            Assertions.assertThat((Object)bridge.bigint().deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), ByteBuffer.allocate(8).putLong(0, Long.MAX_VALUE))).isEqualTo((Object)Long.MAX_VALUE);
            QuickTheory.qt().forAll(SourceDSL.integers().all()).checkAssert(integer -> Assertions.assertThat((Object)DataTypeSerializationTests.toBigInt(bridge, integer)).isEqualTo(integer));
            Assertions.assertThat((Object)DataTypeSerializationTests.toJavaType(bridge, CassandraBridge::bigint, Long.MAX_VALUE)).isEqualTo((Object)Long.MAX_VALUE);
            Assertions.assertThat((Object)DataTypeSerializationTests.toJavaType(bridge, CassandraBridge::bigint, Long.MIN_VALUE)).isEqualTo((Object)Long.MIN_VALUE);
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.longs().all()).checkAssert(aLong -> Assertions.assertThat((Object)DataTypeSerializationTests.toBigInt(bridge, aLong)).isEqualTo(aLong));
        });
    }

    @Test
    public void testDecimal() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(500L))).isInstanceOf(Decimal.class);
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(500L))).isEqualTo((Object)Decimal.apply((int)500));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(500L))).isNotEqualTo((Object)Decimal.apply((int)501));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(-1L))).isEqualTo((Object)Decimal.apply((int)-1));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(Long.MAX_VALUE))).isEqualTo((Object)Decimal.apply((long)Long.MAX_VALUE));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(Long.MIN_VALUE))).isEqualTo((Object)Decimal.apply((long)Long.MIN_VALUE));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(Integer.MAX_VALUE))).isEqualTo((Object)Decimal.apply((int)Integer.MAX_VALUE));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(Integer.MIN_VALUE))).isEqualTo((Object)Decimal.apply((int)Integer.MIN_VALUE));
            BigDecimal veryLargeValue = BigDecimal.valueOf(Integer.MAX_VALUE).multiply(BigDecimal.valueOf(5L));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, veryLargeValue)).isEqualTo((Object)Decimal.apply((BigDecimal)veryLargeValue));
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.bigDecimals().ofBytes(128).withScale(10)).checkAssert(decimal -> Assertions.assertThat((Object)bridge.decimal().deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), bridge.decimal().serialize(decimal))).isEqualTo((Object)Decimal.apply((BigDecimal)decimal)));
        });
    }

    @Test
    public void testFloat() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toFloat(bridge, Float.valueOf(Float.MAX_VALUE))).isInstanceOf(Float.class);
            Assertions.assertThat((Object)bridge.aFloat().deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), ByteBuffer.allocate(4).putFloat(0, Float.MAX_VALUE))).isEqualTo((Object)Float.valueOf(Float.MAX_VALUE));
            QuickTheory.qt().forAll(SourceDSL.integers().all()).checkAssert(integer -> Assertions.assertThat((Object)DataTypeSerializationTests.toFloat(bridge, Float.valueOf(integer.intValue()))).isEqualTo((Object)Float.valueOf(integer.intValue())));
            Assertions.assertThat((Object)DataTypeSerializationTests.toFloat(bridge, Float.valueOf(Float.MAX_VALUE))).isEqualTo((Object)Float.valueOf(Float.MAX_VALUE));
            Assertions.assertThat((Object)DataTypeSerializationTests.toFloat(bridge, Float.valueOf(Float.MIN_VALUE))).isEqualTo((Object)Float.valueOf(Float.MIN_VALUE));
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.floats().any()).checkAssert(aFloat -> Assertions.assertThat((Object)DataTypeSerializationTests.toFloat(bridge, aFloat)).isEqualTo(aFloat));
        });
    }

    @Test
    public void testDouble() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toDouble(bridge, Double.MAX_VALUE)).isInstanceOf(Double.class);
            Assertions.assertThat((Object)bridge.aDouble().deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), ByteBuffer.allocate(8).putDouble(0, Double.MAX_VALUE))).isEqualTo((Object)Double.MAX_VALUE);
            QuickTheory.qt().forAll(SourceDSL.integers().all()).checkAssert(integer -> Assertions.assertThat((Object)DataTypeSerializationTests.toDouble(bridge, integer)).isEqualTo(integer));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDouble(bridge, Double.MAX_VALUE)).isEqualTo((Object)Double.MAX_VALUE);
            Assertions.assertThat((Object)DataTypeSerializationTests.toDouble(bridge, Double.MIN_VALUE)).isEqualTo((Object)Double.MIN_VALUE);
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.doubles().any()).checkAssert(aDouble -> Assertions.assertThat((Object)DataTypeSerializationTests.toDouble(bridge, aDouble)).isEqualTo(aDouble));
        });
    }

    @Test
    public void testAscii() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toAscii(bridge, "abc")).isInstanceOf(UTF8String.class);
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.strings().ascii().ofLengthBetween(0, 100)).checkAssert(string -> Assertions.assertThat((String)DataTypeSerializationTests.toAscii(bridge, string).toString()).isEqualTo(string));
        });
    }

    @Test
    public void testText() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toText(bridge, "abc")).isInstanceOf(UTF8String.class);
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.strings().ascii().ofLengthBetween(0, 100)).checkAssert(string -> Assertions.assertThat((String)DataTypeSerializationTests.toText(bridge, string).toString()).isEqualTo(string));
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.strings().basicLatinAlphabet().ofLengthBetween(0, 100)).checkAssert(string -> Assertions.assertThat((String)DataTypeSerializationTests.toText(bridge, string).toString()).isEqualTo(string));
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.strings().numeric()).checkAssert(string -> Assertions.assertThat((String)DataTypeSerializationTests.toText(bridge, string).toString()).isEqualTo(string));
        });
    }

    @Test
    public void testVarchar() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarChar(bridge, "abc")).isInstanceOf(UTF8String.class);
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.strings().ascii().ofLengthBetween(0, 100)).checkAssert(string -> Assertions.assertThat((String)DataTypeSerializationTests.toVarChar(bridge, string).toString()).isEqualTo(string));
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.strings().basicLatinAlphabet().ofLengthBetween(0, 100)).checkAssert(string -> Assertions.assertThat((String)DataTypeSerializationTests.toVarChar(bridge, string).toString()).isEqualTo(string));
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.strings().numeric()).checkAssert(string -> Assertions.assertThat((String)DataTypeSerializationTests.toVarChar(bridge, string).toString()).isEqualTo(string));
        });
    }

    @Test
    public void testInet() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toInet(bridge, RandomUtils.randomInet())).isInstanceOf(byte[].class);
            for (int test = 0; test < 1000; ++test) {
                InetAddress expected = RandomUtils.randomInet();
                Assertions.assertThat((byte[])((byte[])DataTypeSerializationTests.toInet(bridge, expected))).isEqualTo((Object)expected.getAddress());
            }
        });
    }

    @Test
    public void testDate() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toDate(bridge, 5)).isInstanceOf(Integer.class);
            QuickTheory.qt().forAll(SourceDSL.integers().all()).checkAssert(integer -> Assertions.assertThat((Object)DataTypeSerializationTests.toDate(bridge, integer)).isEqualTo((Object)(integer - Integer.MIN_VALUE)));
        });
    }

    @Test
    public void testTime() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toTime(bridge, Long.MAX_VALUE)).isInstanceOf(Long.class);
            QuickTheory.qt().forAll(SourceDSL.integers().all()).checkAssert(integer -> Assertions.assertThat((Object)DataTypeSerializationTests.toTime(bridge, integer)).isEqualTo(integer));
            Assertions.assertThat((Object)DataTypeSerializationTests.toTime(bridge, Long.MAX_VALUE)).isEqualTo((Object)Long.MAX_VALUE);
            Assertions.assertThat((Object)DataTypeSerializationTests.toTime(bridge, Long.MIN_VALUE)).isEqualTo((Object)Long.MIN_VALUE);
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.longs().all()).checkAssert(aLong -> Assertions.assertThat((Object)DataTypeSerializationTests.toTime(bridge, aLong)).isEqualTo(aLong));
        });
    }

    @Test
    public void testDuration() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            CalendarInterval value = SparkTypeUtils.convertDuration((InternalDuration)new InternalDuration(1, 2, 7000000000L));
            Object converted = SqlToCqlTypeConverter.getConverter((CqlField.CqlType)bridge.duration()).convert((Object)value);
            Object deserialized = DataTypeSerializationTests.toDuration(bridge, converted);
            Assertions.assertThat((Object)deserialized).isInstanceOf(CalendarInterval.class);
            Assertions.assertThat((Object)deserialized).isEqualTo((Object)value);
        });
    }

    @Test
    public void testTimestamp() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Date now = new Date();
            Assertions.assertThat((Object)DataTypeSerializationTests.toTimestamp(bridge, now)).isInstanceOf(Long.class);
            Assertions.assertThat((Object)DataTypeSerializationTests.toTimestamp(bridge, now)).isEqualTo((Object)(Timestamp.from(now.toInstant()).getTime() * 1000L));
            QuickTheory.qt().withExamples(1000).forAll(SourceDSL.dates().withMillisecondsBetween(0L, Long.MAX_VALUE)).checkAssert(date -> Assertions.assertThat((Object)DataTypeSerializationTests.toTimestamp(bridge, date)).isEqualTo((Object)(Timestamp.from(date.toInstant()).getTime() * 1000L)));
        });
    }

    @Test
    public void testBlob() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toBlob(bridge, ByteBuffer.wrap(RandomUtils.randomBytes((int)5)))).isInstanceOf(byte[].class);
            for (int test = 0; test < 1000; ++test) {
                int size = RandomUtils.RANDOM.nextInt(1024);
                byte[] expected = RandomUtils.randomBytes((int)size);
                Assertions.assertThat((byte[])((byte[])DataTypeSerializationTests.toBlob(bridge, ByteBuffer.wrap(expected)))).isEqualTo((Object)expected);
            }
        });
    }

    @Test
    public void testEmpty() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> Assertions.assertThat((Object)DataTypeSerializationTests.toEmpty(bridge, null)).isNull());
    }

    @Test
    public void testSmallInt() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toSmallInt(bridge, (short)5)).isInstanceOf(Short.class);
            QuickTheory.qt().forAll(SourceDSL.integers().between(Short.MIN_VALUE, Short.MAX_VALUE)).checkAssert(integer -> {
                short expected = integer.shortValue();
                Assertions.assertThat((Object)DataTypeSerializationTests.toSmallInt(bridge, expected)).isEqualTo((Object)expected);
            });
        });
    }

    @Test
    public void testTinyInt() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((Object)DataTypeSerializationTests.toTinyInt(bridge, RandomUtils.randomByte())).isInstanceOf(Byte.class);
            for (int test = 0; test < 1000; ++test) {
                byte expected = RandomUtils.randomByte();
                Assertions.assertThat((Object)DataTypeSerializationTests.toTinyInt(bridge, expected)).isEqualTo((Object)expected);
            }
        });
    }

    @Test
    public void testSerialization() {
        QuickTheory.qt().forAll(TestUtils.bridges()).checkAssert(bridge -> {
            Assertions.assertThat((String)DataTypeSerializationTests.toAscii(bridge, "ABC").toString()).isEqualTo("ABC");
            Assertions.assertThat((Object)DataTypeSerializationTests.toBigInt(bridge, 500L)).isEqualTo((Object)500L);
            Assertions.assertThat((Boolean)((Boolean)DataTypeSerializationTests.toBool(bridge, true))).isTrue();
            Assertions.assertThat((Boolean)((Boolean)DataTypeSerializationTests.toBool(bridge, false))).isFalse();
            byte[] bytes = new byte[]{97, 98, 99, 100};
            ByteBuffer buffer = bridge.blob().serialize((Object)ByteBuffer.wrap(bytes));
            byte[] result = new byte[4];
            buffer.get(result);
            Assertions.assertThat((byte[])result).isEqualTo((Object)bytes);
            Assertions.assertThat((Object)DataTypeSerializationTests.toDate(bridge, 500)).isEqualTo((Object)-2147483148);
            Assertions.assertThat((Object)DataTypeSerializationTests.toDecimal(bridge, BigDecimal.valueOf(500000.2038484))).isEqualTo((Object)Decimal.apply((double)500000.2038484));
            Assertions.assertThat((Object)DataTypeSerializationTests.toDouble(bridge, 123211.023874839)).isEqualTo((Object)123211.023874839);
            Assertions.assertThat((Object)DataTypeSerializationTests.toFloat(bridge, Float.valueOf(58383.24f))).isEqualTo((Object)Float.valueOf(58383.24f));
            try {
                Assertions.assertThat((Object)InetAddress.getByAddress((byte[])DataTypeSerializationTests.toInet(bridge, InetAddress.getByName("www.apache.org")))).isEqualTo((Object)InetAddress.getByName("www.apache.org"));
            }
            catch (UnknownHostException exception) {
                throw new RuntimeException(exception);
            }
            Assertions.assertThat((Object)DataTypeSerializationTests.toInt(bridge, 283848498)).isEqualTo((Object)283848498);
            Assertions.assertThat((Object)DataTypeSerializationTests.toSmallInt(bridge, (short)29)).isEqualTo((Object)29);
            Assertions.assertThat((String)DataTypeSerializationTests.toAscii(bridge, "hello world").toString()).isEqualTo("hello world");
            Assertions.assertThat((Object)DataTypeSerializationTests.toTime(bridge, 5002839L)).isEqualTo((Object)5002839L);
            Date now = new Date();
            Assertions.assertThat((Object)DataTypeSerializationTests.toTimestamp(bridge, now)).isEqualTo((Object)(now.getTime() * 1000L));
            UUID timeUuid = RandomUtils.getRandomTimeUUIDForTesting();
            Assertions.assertThat((Comparable)UUID.fromString(DataTypeSerializationTests.toTimeUUID(bridge, timeUuid).toString())).isEqualTo((Object)timeUuid);
            Assertions.assertThat((Object)DataTypeSerializationTests.toTinyInt(bridge, (byte)100)).isEqualTo((Object)100);
            UUID uuid = UUID.randomUUID();
            Assertions.assertThat((Comparable)UUID.fromString(DataTypeSerializationTests.toUUID(bridge, uuid).toString())).isEqualTo((Object)uuid);
            Assertions.assertThat((String)DataTypeSerializationTests.toVarChar(bridge, "ABCDEFG").toString()).isEqualTo("ABCDEFG");
            Assertions.assertThat((Object)DataTypeSerializationTests.toVarInt(bridge, BigInteger.valueOf(12841924L))).isEqualTo((Object)Decimal.apply((int)12841924));
        });
    }

    @Test
    public void testList() {
        TestUtils.runTest((partitioner, directory, bridge) -> QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> {
            CqlField.CqlList list = bridge.list((CqlField.CqlType)type);
            SparkType sparkType = CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).toSparkType((CqlField.CqlType)type);
            List expected = IntStream.range(0, 128).mapToObj(index -> type.randomValue()).collect(Collectors.toList());
            ByteBuffer buffer = list.serialize(expected);
            List<Object> actual = Arrays.asList(((ArrayData)list.deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), buffer)).array());
            Assertions.assertThat((int)actual.size()).isEqualTo(expected.size());
            for (int index2 = 0; index2 < expected.size(); ++index2) {
                Assertions.assertThat((Object)sparkType.toTestRowType(actual.get(index2))).isEqualTo(expected.get(index2));
            }
        }));
    }

    @Test
    public void testSet() {
        TestUtils.runTest((partitioner, directory, bridge) -> QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsSetElement).checkAssert(type -> {
            CqlField.CqlSet set = bridge.set((CqlField.CqlType)type);
            SparkType sparkType = CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).toSparkType((CqlField.CqlType)type);
            Set expected = IntStream.range(0, 128).mapToObj(integer -> type.randomValue()).collect(Collectors.toSet());
            ByteBuffer buffer = set.serialize(expected);
            HashSet<Object> actual = new HashSet<Object>(Arrays.asList(((ArrayData)set.deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), buffer)).array()));
            Assertions.assertThat((int)actual.size()).isEqualTo(expected.size());
            for (Object e : actual) {
                Assertions.assertThat((boolean)expected.contains(sparkType.toTestRowType(e))).isTrue();
            }
        }));
    }

    @Test
    public void testMap() {
        TestUtils.runTest((partitioner, directory, bridge) -> QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).assuming((keyType, valueType) -> keyType.supportedAsMapKey()).checkAssert((keyType, valueType) -> {
            CqlField.CqlMap map = bridge.map((CqlField.CqlType)keyType, (CqlField.CqlType)valueType);
            SparkType keySparkType = CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).toSparkType((CqlField.CqlType)keyType);
            SparkType valueSparkType = CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).toSparkType((CqlField.CqlType)valueType);
            int count = keyType.cardinality(128);
            HashMap<Object, Object> expected = new HashMap<Object, Object>(count);
            for (int entry = 0; entry < count; ++entry) {
                Object key = null;
                while (key == null || expected.containsKey(key)) {
                    key = keyType.randomValue();
                }
                expected.put(key, valueType.randomValue());
            }
            ByteBuffer buffer = map.serialize(expected);
            ArrayBasedMapData mapData = (ArrayBasedMapData)map.deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), buffer);
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            HashMap<Object, Object> actual = new HashMap<Object, Object>(keys.numElements());
            for (int index = 0; index < keys.numElements(); ++index) {
                Object key = keySparkType.toTestRowType(keys.get(index, CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).sparkSqlType((CqlField.CqlType)keyType)));
                Object value = valueSparkType.toTestRowType(values.get(index, CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).sparkSqlType((CqlField.CqlType)valueType)));
                actual.put(key, value);
            }
            Assertions.assertThat((int)actual.size()).isEqualTo(expected.size());
            for (Map.Entry entry : expected.entrySet()) {
                Assertions.assertThat(actual.get(entry.getKey())).isEqualTo(entry.getValue());
            }
        }));
    }

    @Test
    public void testUdts() {
        TestUtils.runTest((partitioner, directory, bridge) -> QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((firstType, secondType) -> {
            CqlField.CqlUdt udt = bridge.udt("keyspace", "testudt").withField("a", (CqlField.CqlType)firstType).withField("b", (CqlField.CqlType)bridge.ascii()).withField("c", (CqlField.CqlType)secondType).build();
            Map expected = (Map)udt.randomValue();
            assert (expected != null);
            ByteBuffer buffer = udt.serializeUdt(expected);
            Map actual = udt.deserializeUdt((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), buffer, false);
            Assertions.assertThat((int)actual.size()).isEqualTo(expected.size());
            for (Map.Entry entry : expected.entrySet()) {
                SparkType sparkType = CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).toSparkType(udt.field((String)entry.getKey()).type());
                Assertions.assertThat((Object)sparkType.toTestRowType(actual.get(entry.getKey()))).isEqualTo(entry.getValue());
            }
        }));
    }

    @Test
    public void testTuples() {
        TestUtils.runTest((partitioner, directory, bridge) -> QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((firstType, secondType) -> {
            CqlField.CqlTuple tuple = bridge.tuple(new CqlField.CqlType[]{firstType, bridge.ascii(), secondType, bridge.timestamp(), bridge.uuid(), bridge.varchar()});
            Object[] expected = (Object[])tuple.randomValue();
            assert (expected != null);
            ByteBuffer buffer = tuple.serializeTuple(expected);
            GenericInternalRow row = (GenericInternalRow)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).convert((CqlField.CqlType)tuple, (Object)tuple.deserializeTuple(buffer, false), false);
            Object[] actual = row.values();
            Assertions.assertThat((int)actual.length).isEqualTo(expected.length);
            for (int index = 0; index < expected.length; ++index) {
                SparkType sparkType = CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).toSparkType(tuple.type(index));
                Assertions.assertThat((Object)sparkType.toTestRowType(actual[index])).isEqualTo(expected[index]);
            }
        }));
    }

    static Object toInt(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::aInt, value);
    }

    static Object toSmallInt(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::smallint, value);
    }

    static Object toTinyInt(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::tinyint, value);
    }

    static Object toBool(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::bool, value);
    }

    static Object toBigInt(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::bigint, value);
    }

    static Object toText(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::text, value);
    }

    static Object toAscii(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::ascii, value);
    }

    static Object toVarChar(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::varchar, value);
    }

    static Object toInet(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::inet, value);
    }

    static Object toDouble(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::aDouble, value);
    }

    static Object toFloat(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::aFloat, value);
    }

    static Object toUUID(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::uuid, value);
    }

    static Object toTimeUUID(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::timeuuid, value);
    }

    static Object toDecimal(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::decimal, value);
    }

    static Object toVarInt(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::varint, value);
    }

    static Object toDate(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::date, value);
    }

    static Object toTime(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::time, value);
    }

    static Object toDuration(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::duration, value);
    }

    static Object toTimestamp(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::timestamp, value);
    }

    static Object toBlob(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::blob, value);
    }

    static Object toEmpty(CassandraBridge bridge, Object value) {
        return DataTypeSerializationTests.toNative(bridge, CassandraBridge::empty, value);
    }

    static Object toNative(CassandraBridge bridge, Function<CassandraBridge, CqlField.NativeType> typeMapper, Object value) {
        CqlField.NativeType nativeType = typeMapper.apply(bridge);
        return nativeType.deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), nativeType.serialize(value));
    }

    static Object toJavaType(CassandraBridge bridge, Function<CassandraBridge, CqlField.NativeType> typeMapper, Object value) {
        CqlField.NativeType nativeType = typeMapper.apply(bridge);
        return typeMapper.apply(bridge).deserializeToJavaType(nativeType.serialize(value));
    }
}

