/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.IncompleteSSTableException;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.reader.CompressionMetadata;
import org.apache.cassandra.spark.reader.IndexConsumer;
import org.apache.cassandra.spark.reader.IndexEntry;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.spark.reader.SSTableCache;
import org.apache.cassandra.spark.reader.SummaryDbUtils;
import org.apache.cassandra.spark.reader.common.AbstractCompressionMetadata;
import org.apache.cassandra.spark.reader.common.IIndexReader;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.utils.vint.VIntCoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigIndexReader
implements IIndexReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BigIndexReader.class);
    private TokenRange ssTableRange = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigIndexReader(@NotNull SSTable ssTable, @NotNull TableMetadata metadata, @Nullable SparkRangeFilter rangeFilter, @NotNull Stats stats, @NotNull IndexConsumer consumer) {
        long now;
        long startTimeNanos = now = System.nanoTime();
        try {
            CompressionMetadata compressionMetadata;
            SummaryDbUtils.Summary summary;
            File file = ReaderUtils.constructFilename(metadata.keyspace, metadata.name, ssTable.getDataFileName());
            Descriptor descriptor = Descriptor.fromFilename((File)file);
            Version version = descriptor.version;
            long skipAhead = -1L;
            now = System.nanoTime();
            if (rangeFilter != null && (summary = SSTableCache.INSTANCE.keysFromSummary(metadata, ssTable)) != null) {
                this.ssTableRange = TokenRange.closed((BigInteger)ReaderUtils.tokenToBigInteger((Token)summary.first().getToken()), (BigInteger)ReaderUtils.tokenToBigInteger((Token)summary.last().getToken()));
                if (!rangeFilter.overlaps(this.ssTableRange)) {
                    LOGGER.info("Skipping non-overlapping Index.db file rangeFilter='[{},{}]' sstableRange='[{},{}]'", new Object[]{rangeFilter.tokenRange().firstEnclosedValue(), rangeFilter.tokenRange().upperEndpoint(), this.ssTableRange.firstEnclosedValue(), this.ssTableRange.upperEndpoint()});
                    stats.indexFileSkipped();
                    return;
                }
                skipAhead = summary.summary().getPosition(SummaryDbUtils.binarySearchSummary(summary.summary(), metadata.partitioner, rangeFilter.tokenRange().firstEnclosedValue()));
                stats.indexSummaryFileRead(System.nanoTime() - now);
                now = System.nanoTime();
            }
            if ((compressionMetadata = SSTableCache.INSTANCE.compressionMetadata(ssTable, version.hasMaxCompressedLength(), metadata.params.crcCheckChance)) != null) {
                stats.indexCompressionFileRead(System.nanoTime() - now);
                now = System.nanoTime();
            }
            try (InputStream is = ssTable.openPrimaryIndexStream();){
                if (is == null) {
                    consumer.onFailure((Throwable)new IncompleteSSTableException(new FileType[]{FileType.INDEX}));
                    return;
                }
                BigIndexReader.consumePrimaryIndex(metadata.partitioner, is, ssTable, compressionMetadata, rangeFilter, stats, skipAhead, consumer);
                stats.indexFileRead(System.nanoTime() - now);
            }
        }
        catch (Throwable t) {
            consumer.onFailure(t);
        }
        finally {
            consumer.onFinished(System.nanoTime() - startTimeNanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void consumePrimaryIndex(@NotNull IPartitioner partitioner, @NotNull InputStream primaryIndex, @NotNull SSTable ssTable, @Nullable CompressionMetadata compressionMetadata, @Nullable SparkRangeFilter range, @NotNull Stats stats, long skipBytes, @NotNull IndexConsumer consumer) throws IOException {
        primaryIndexLength = ssTable.length(FileType.INDEX);
        dataDbFileLength = ssTable.length(FileType.DATA);
        dis = new DataInputStream(primaryIndex);
        try {
            if (skipBytes > 0L) {
                ByteBufferUtils.skipFully((InputStream)dis, (long)skipBytes);
                stats.indexBytesSkipped(skipBytes);
            }
            prevKey = null;
            prevPos = 0L;
            prevToken = null;
            started = false;
            totalBytesRead = 0L;
            while (true) {
                try {
                    len = dis.readUnsignedShort();
                    buf = new byte[len];
                    dis.readFully(buf);
                    key = ByteBuffer.wrap(buf);
                    decoratedKey = partitioner.decorateKey(key);
                    token = ReaderUtils.tokenToBigInteger((Token)decoratedKey.getToken());
                    pos = ReaderUtils.readPosition(dis);
                    promotedIndex = ReaderUtils.skipPromotedIndex(dis);
                    totalBytesRead += (long)(2 + len + VIntCoding.computeUnsignedVIntSize((long)pos) + promotedIndex);
                    if (prevKey != null && (range == null || range.overlaps(prevToken))) {
                        started = true;
                        uncompressed = pos - prevPos;
                        compressed = compressionMetadata == null ? uncompressed : BigIndexReader.calculateCompressedSize(compressionMetadata, dataDbFileLength, prevPos, pos - 1L);
                        consumer.accept((Object)new IndexEntry(prevKey, prevToken, uncompressed, compressed));
                    } else if (started) {
                        stats.indexBytesSkipped(primaryIndexLength - totalBytesRead - skipBytes);
                    }
                    ** GOTO lbl-1000
                }
                catch (EOFException len) {
                    stats.indexBytesRead(totalBytesRead);
                    break;
                }
                catch (Throwable var33_31) {
                    stats.indexBytesRead(totalBytesRead);
                    throw var33_31;
                }
                stats.indexBytesRead(totalBytesRead);
                return;
lbl-1000:
                // 2 sources

                {
                    prevPos = pos;
                    prevKey = key;
                    prevToken = token;
                    continue;
                }
                break;
            }
            if (prevKey == null) return;
            if (range != null) {
                if (range.overlaps(prevToken) == false) return;
            }
            end = compressionMetadata == null ? dataDbFileLength : compressionMetadata.getDataLength();
            uncompressed = end - prevPos;
            compressed = compressionMetadata == null ? uncompressed : BigIndexReader.calculateCompressedSize(compressionMetadata, dataDbFileLength, prevPos, end - 1L);
            consumer.accept((Object)new IndexEntry(prevKey, prevToken, uncompressed, compressed));
            return;
        }
        finally {
            dis.close();
        }
    }

    public static long calculateCompressedSize(@NotNull CompressionMetadata compressionMetadata, long compressedDataLength, long start, long end) {
        int startIdx = compressionMetadata.chunkIdx(start);
        int endIdx = compressionMetadata.chunkIdx(end);
        AbstractCompressionMetadata.Chunk startChunk = compressionMetadata.chunkAtIndex(startIdx);
        long startLen = BigIndexReader.chunkCompressedLength(startChunk, compressedDataLength);
        long uncompressedChunkLen = compressionMetadata.chunkLength();
        if (startIdx == endIdx) {
            float perc = (float)(end - start) / (float)uncompressedChunkLen;
            return Math.round(perc * (float)startLen);
        }
        long size = BigIndexReader.partialCompressedSizeWithinChunk(start, uncompressedChunkLen, startLen, true);
        AbstractCompressionMetadata.Chunk endChunk = compressionMetadata.chunkAtIndex(endIdx);
        long endLen = BigIndexReader.chunkCompressedLength(endChunk, compressedDataLength);
        size += (long)BigIndexReader.partialCompressedSizeWithinChunk(end, uncompressedChunkLen, endLen, false);
        for (int idx = startIdx + 1; idx < endIdx; ++idx) {
            size += BigIndexReader.chunkCompressedLength(compressionMetadata.chunkAtIndex(idx), compressedDataLength);
        }
        return size;
    }

    private static long chunkCompressedLength(AbstractCompressionMetadata.Chunk chunk, long compressedDataLength) {
        return chunk.length >= 0 ? (long)chunk.length : compressedDataLength - chunk.offset;
    }

    public static int partialCompressedSizeWithinChunk(long uncompressedPos, long uncompressedChunkLen, long compressedChunkLen, boolean start) {
        long mod = uncompressedPos % uncompressedChunkLen;
        long usedBytes = start ? uncompressedChunkLen - mod : mod;
        float perc = (float)usedBytes / (float)uncompressedChunkLen;
        return Math.round(perc * (float)compressedChunkLen);
    }

    public BigInteger firstToken() {
        return this.ssTableRange != null ? this.ssTableRange.firstEnclosedValue() : null;
    }

    public BigInteger lastToken() {
        return this.ssTableRange != null ? this.ssTableRange.upperEndpoint() : null;
    }

    public boolean ignore() {
        return false;
    }
}

