/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RebufferingInputStream;

public class FileInputStreamPlus
extends RebufferingInputStream {
    final FileChannel channel;
    public final File file;

    public FileInputStreamPlus(String file) throws NoSuchFileException {
        this(new File(file));
    }

    public FileInputStreamPlus(Path path) throws NoSuchFileException {
        this(new File(path));
    }

    public FileInputStreamPlus(File file) throws NoSuchFileException {
        this(file, 16384);
    }

    public FileInputStreamPlus(File file, int bufferSize) throws NoSuchFileException {
        super(ByteBuffer.allocateDirect(bufferSize));
        this.channel = file.newReadChannel();
        this.buffer.limit(0);
        this.file = file;
    }

    @Override
    protected void reBuffer() throws IOException {
        this.buffer.clear();
        this.channel.read(this.buffer);
        this.buffer.flip();
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            try {
                FileUtils.clean(this.buffer);
            }
            finally {
                this.channel.close();
            }
        }
    }
}

