/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.googlesheetssink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelGooglesheetssinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_SPREADSHEET_ID_CONF = "camel.kamelet.google-sheets-sink.spreadsheetId";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_SPREADSHEET_ID_DOC = "The Spreadsheet ID to be used as identifier";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_SPREADSHEET_ID_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_ID_CONF = "camel.kamelet.google-sheets-sink.clientId";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_ID_DOC = "Client ID of the sheets application";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_SECRET_CONF = "camel.kamelet.google-sheets-sink.clientSecret";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_SECRET_DOC = "Client Secret of the sheets application";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_SECRET_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_ACCESS_TOKEN_CONF = "camel.kamelet.google-sheets-sink.accessToken";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_ACCESS_TOKEN_DOC = "OAuth 2 access token for google sheets application. This typically expires after an hour so refreshToken is recommended for long term usage.";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_ACCESS_TOKEN_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_REFRESH_TOKEN_CONF = "camel.kamelet.google-sheets-sink.refreshToken";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_REFRESH_TOKEN_DOC = "OAuth 2 refresh token for google sheets application. Using this, the Google Calendar component can obtain a new accessToken whenever the current one expires - a necessity if the application is long-lived.";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_REFRESH_TOKEN_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_APPLICATION_NAME_CONF = "camel.kamelet.google-sheets-sink.applicationName";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_APPLICATION_NAME_DOC = "Google Sheets application name";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_APPLICATION_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_OPERATION_CONF = "camel.kamelet.google-sheets-sink.operation";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_OPERATION_DOC = "Operation to execute (update or append) Example: append";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_OPERATION_DEFAULT = "append";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_RANGE_CONF = "camel.kamelet.google-sheets-sink.range";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_RANGE_DOC = "The cell range of rows and columns to write data to. Example: A1:B3";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_RANGE_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_MAJOR_DIMENSION_CONF = "camel.kamelet.google-sheets-sink.majorDimension";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_MAJOR_DIMENSION_DOC = "Specifies the major dimension that the given values should use (ROWS or COLUMNS). Example: ROWS";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_MAJOR_DIMENSION_DEFAULT = "ROWS";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_COLUMN_NAMES_CONF = "camel.kamelet.google-sheets-sink.columnNames";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_COLUMN_NAMES_DOC = "Optional custom column names that map to cell coordinates based on their position.";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_COLUMN_NAMES_DEFAULT = "A";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_VALUE_INPUT_OPTION_CONF = "camel.kamelet.google-sheets-sink.valueInputOption";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_VALUE_INPUT_OPTION_DOC = "Controls how the entered values should be be interpreted when adding them. Example: USER_ENTERED";
    public static final String CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_VALUE_INPUT_OPTION_DEFAULT = "USER_ENTERED";

    public CamelGooglesheetssinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelGooglesheetssinkSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_SPREADSHEET_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_SPREADSHEET_ID_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_SPREADSHEET_ID_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_ID_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_ID_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_ID_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_SECRET_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_SECRET_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_CLIENT_SECRET_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_ACCESS_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_ACCESS_TOKEN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_ACCESS_TOKEN_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_REFRESH_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_REFRESH_TOKEN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_REFRESH_TOKEN_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_APPLICATION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_APPLICATION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_APPLICATION_NAME_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_OPERATION_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_RANGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_RANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_RANGE_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_MAJOR_DIMENSION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_MAJOR_DIMENSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_MAJOR_DIMENSION_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_COLUMN_NAMES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_COLUMN_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_COLUMN_NAMES_DOC);
        conf.define(CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_VALUE_INPUT_OPTION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_VALUE_INPUT_OPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESHEETSSINK_KAMELET_VALUE_INPUT_OPTION_DOC);
        return conf;
    }
}