/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.winrm.winrm4j;

import java.io.IOException;
import java.io.Writer;

public class PrettyXmlWriter
extends Writer {
    private final Writer wrappedWriter;
    private boolean selfClosingTag = false;
    private int indentLevel = 0;
    private boolean newLine = true;
    private char lastChar = (char)10;
    private boolean isComment = false;
    private boolean newTagToProcess = false;

    public PrettyXmlWriter(Writer writer) {
        super((Object)writer);
        this.wrappedWriter = writer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.newTagToProcess) {
            this.handleMeaningfulChar(cbuf, off, '<', off, len);
            this.newTagToProcess = false;
        }
        for (int i = off; i < off + len; ++i) {
            char c = cbuf[i];
            if (this.isComment) {
                if (c == '\n') {
                    this.isComment = false;
                    this.writeNewLine();
                    continue;
                }
                this.writeChar(c);
                continue;
            }
            if (this.newLine && c == '#') {
                this.isComment = true;
                this.writeChar(c);
                continue;
            }
            this.handleMeaningfulChar(cbuf, i, c, off, len);
        }
    }

    private void handleMeaningfulChar(char[] cbuf, int i, char c, int off, int len) throws IOException {
        boolean endOfChunk;
        int end = off + len - 1;
        boolean bl = endOfChunk = end == i;
        if (this.lastChar == '<' && c == '/' || this.newTagToProcess && cbuf[i] == '/') {
            --this.indentLevel;
        }
        if (this.lastChar == '/' && c == '>') {
            this.selfClosingTag = true;
        }
        if (c == '<' && '>' == this.lastChar) {
            if (endOfChunk) {
                this.newTagToProcess = true;
                return;
            }
            this.writeNewLine();
            ++this.indentLevel;
            if (i < end && cbuf[i + 1] == '/') {
                --this.indentLevel;
            }
            if (this.selfClosingTag) {
                --this.indentLevel;
                this.selfClosingTag = false;
            }
            this.printIndent();
        }
        this.writeChar(c);
    }

    private void writeNewLine() throws IOException {
        this.wrappedWriter.write(10);
        this.newLine = true;
    }

    private void writeChar(char c) throws IOException {
        this.wrappedWriter.write(c);
        this.newLine = false;
        this.lastChar = c;
    }

    private void printIndent() throws IOException {
        for (int j = 0; j < this.indentLevel; ++j) {
            this.wrappedWriter.write(9);
        }
    }

    @Override
    public void flush() throws IOException {
        this.wrappedWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrappedWriter.close();
    }
}

