/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.vpn;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.vpn.AutoValue_VirtualNetworkGatewayConnectionProperties;
import org.jclouds.azurecompute.arm.domain.vpn.IPSecPolicy;
import org.jclouds.azurecompute.arm.domain.vpn.TunnelConnectionHealth;
import org.jclouds.azurecompute.arm.domain.vpn.VirtualNetworkGatewayConnection;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class VirtualNetworkGatewayConnectionProperties
implements Provisionable {
    @Nullable
    public abstract String authorizationKey();

    @Nullable
    public abstract VirtualNetworkGatewayConnection.Status connectionStatus();

    public abstract VirtualNetworkGatewayConnection.Type connectionType();

    @Nullable
    public abstract Integer egressBytesTransferred();

    @Nullable
    public abstract Integer ingressBytesTransferred();

    public abstract boolean enableBGP();

    public abstract List<IPSecPolicy> ipsecPolicies();

    @Nullable
    public abstract IdReference peer();

    @Override
    @Nullable
    public abstract String provisioningState();

    @Nullable
    public abstract String resourceGuid();

    @Nullable
    public abstract Integer routingWeight();

    @Nullable
    public abstract String sharedKey();

    public abstract List<TunnelConnectionHealth> tunnelConnectionStatus();

    public abstract boolean usePolicyBasedTrafficSelectors();

    public abstract IdReference localNetworkGateway2();

    public abstract IdReference virtualNetworkGateway1();

    @Nullable
    public abstract IdReference virtualNetworkGateway2();

    VirtualNetworkGatewayConnectionProperties() {
    }

    @SerializedNames(value={"authorizationKey", "connectionStatus", "connectionType", "egressBytesTransferred", "ingressBytesTransferred", "enableBGP", "ipsecPolicies", "peer", "provisioningState", "resourceGuid", "routingWeight", "sharedKey", "tunnelConnectionStatus", "usePolicyBasedTrafficSelectors", "localNetworkGateway2", "virtualNetworkGateway1", "virtualNetworkGateway2"})
    public static VirtualNetworkGatewayConnectionProperties create(String authorizationKey, VirtualNetworkGatewayConnection.Status connectionStatus, VirtualNetworkGatewayConnection.Type connectionType, Integer egressBytesTransferred, Integer ingressBytesTransferred, boolean enableBGP, List<IPSecPolicy> ipsecPolicies, IdReference peer, String provisioningState, String resourceGuid, Integer routingWeight, String sharedKey, List<TunnelConnectionHealth> tunnelConnectionStatus, boolean usePolicyBasedTrafficSelectors, IdReference localNetworkGateway2, IdReference virtualNetworkGateway1, IdReference virtualNetworkGateway2) {
        return VirtualNetworkGatewayConnectionProperties.builder(connectionType, enableBGP, usePolicyBasedTrafficSelectors, localNetworkGateway2, virtualNetworkGateway1).authorizationKey(authorizationKey).connectionStatus(connectionStatus).egressBytesTransferred(egressBytesTransferred).ingressBytesTransferred(ingressBytesTransferred).ipsecPolicies(ipsecPolicies).peer(peer).provisioningState(provisioningState).resourceGuid(resourceGuid).routingWeight(routingWeight).sharedKey(sharedKey).tunnelConnectionStatus(tunnelConnectionStatus).virtualNetworkGateway2(virtualNetworkGateway2).build();
    }

    public static Builder builder(VirtualNetworkGatewayConnection.Type connectionType, boolean enableBGP, boolean usePolicyBasedTrafficSelectors, IdReference localNetworkGateway2, IdReference virtualNetworkGateway1) {
        return new AutoValue_VirtualNetworkGatewayConnectionProperties.Builder().connectionType(connectionType).enableBGP(enableBGP).usePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors).localNetworkGateway2(localNetworkGateway2).virtualNetworkGateway1(virtualNetworkGateway1).ipsecPolicies((List<IPSecPolicy>)ImmutableList.of()).tunnelConnectionStatus((List<TunnelConnectionHealth>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder authorizationKey(String var1);

        public abstract Builder connectionStatus(VirtualNetworkGatewayConnection.Status var1);

        public abstract Builder connectionType(VirtualNetworkGatewayConnection.Type var1);

        public abstract Builder egressBytesTransferred(Integer var1);

        public abstract Builder ingressBytesTransferred(Integer var1);

        public abstract Builder enableBGP(boolean var1);

        public abstract Builder ipsecPolicies(List<IPSecPolicy> var1);

        public abstract Builder peer(IdReference var1);

        public abstract Builder provisioningState(String var1);

        public abstract Builder resourceGuid(String var1);

        public abstract Builder routingWeight(Integer var1);

        public abstract Builder sharedKey(String var1);

        public abstract Builder tunnelConnectionStatus(List<TunnelConnectionHealth> var1);

        public abstract Builder usePolicyBasedTrafficSelectors(boolean var1);

        public abstract Builder localNetworkGateway2(IdReference var1);

        public abstract Builder virtualNetworkGateway1(IdReference var1);

        public abstract Builder virtualNetworkGateway2(IdReference var1);

        abstract List<IPSecPolicy> ipsecPolicies();

        abstract List<TunnelConnectionHealth> tunnelConnectionStatus();

        abstract VirtualNetworkGatewayConnectionProperties autoBuild();

        public VirtualNetworkGatewayConnectionProperties build() {
            this.ipsecPolicies((List<IPSecPolicy>)(this.ipsecPolicies() == null ? ImmutableList.of() : ImmutableList.copyOf(this.ipsecPolicies())));
            this.tunnelConnectionStatus((List<TunnelConnectionHealth>)(this.tunnelConnectionStatus() == null ? ImmutableList.of() : ImmutableList.copyOf(this.tunnelConnectionStatus())));
            return this.autoBuild();
        }
    }
}

