/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import com.google.common.base.Function;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.stock.DelegateEntityImpl;

@ImplementedBy(value=DelegateEntityImpl.class)
public interface DelegateEntity
extends Entity {
    @CatalogConfig(label="Delegate")
    public static final AttributeSensorAndConfigKey<Entity, Entity> DELEGATE_ENTITY = ConfigKeys.newSensorAndConfigKey(Entity.class, "delegate.entity", "The delegate entity");
    public static final AttributeSensor<String> DELEGATE_ENTITY_LINK = Sensors.newStringSensor("webapp.url", "The delegate entity link");

    public static class EntityUrl {
        private static final AtomicBoolean initialized = new AtomicBoolean(false);
        private static final Function<Entity, String> entityUrlFunction = new Function<Entity, String>(){

            public String apply(Entity input) {
                if (input == null) {
                    return null;
                }
                Entity entity = input;
                String url = String.format("#/v1/applications/%s/entities/%s", entity.getApplicationId(), entity.getId());
                return url;
            }
        };

        public static Function<Entity, String> entityUrl() {
            return entityUrlFunction;
        }

        public static void init() {
            if (initialized.getAndSet(true)) {
                return;
            }
            RendererHints.register(DELEGATE_ENTITY, RendererHints.namedActionWithUrl(EntityUrl.entityUrl()));
            RendererHints.register(DELEGATE_ENTITY_LINK, RendererHints.namedActionWithUrl());
        }

        static {
            EntityUrl.init();
        }
    }
}

