/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import com.google.common.base.Stopwatch;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.variables.TypedValueToSet;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitWorkflowStep
extends WorkflowStepDefinition {
    private static final Logger log = LoggerFactory.getLogger(WaitWorkflowStep.class);
    public static final String SHORTHAND = "[ [ ${variable.type} ] ${variable.name} \"=\" ] [ ?${task} \"task\" ] ${value}";
    public static final ConfigKey<TypedValueToSet> VARIABLE = ConfigKeys.newConfigKey(TypedValueToSet.class, "variable");
    public static final ConfigKey<Object> VALUE = ConfigKeys.newConfigKey(Object.class, "value");
    public static final ConfigKey<Boolean> TASK = ConfigKeys.newBooleanConfigKey("task");

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        TypedValueToSet variable = context.getInput(VARIABLE);
        String name = null;
        TypeToken<?> type = TypeToken.of(Object.class);
        if (variable != null) {
            name = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, (Object)variable.name, String.class);
            if (Strings.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("Variable name is required");
            }
            type = context.lookupType(variable.type, () -> TypeToken.of(Object.class));
        }
        boolean task = Boolean.TRUE.equals(context.getInput(TASK));
        Stopwatch sw = Stopwatch.createStarted();
        Object unresolvedValue = this.input.get(VALUE.getName());
        Object resolvedValue = context.resolveWaiting(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, unresolvedValue, type);
        if (task) {
            if (resolvedValue instanceof String) {
                resolvedValue = ((ManagementContextInternal)context.getWorkflowExectionContext().getEntity()).getExecutionManager().getTask((String)resolvedValue);
            }
            if (resolvedValue != null) {
                if (resolvedValue instanceof TaskAdaptable) {
                    resolvedValue = ((TaskAdaptable)resolvedValue).asTask().getUnchecked();
                } else {
                    throw new IllegalArgumentException("Argument cannot be interpreted as a task: " + resolvedValue);
                }
            }
        }
        Duration duration = Duration.of((Object)sw);
        context.noteOtherMetadata("Duration", "" + duration);
        log.debug("Wait resolved after " + duration + ", " + this.input.get(unresolvedValue) + " is: " + resolvedValue);
        if (name != null) {
            Object oldValue = context.getWorkflowExectionContext().updateWorkflowScratchVariable(name, resolvedValue);
            if (oldValue != null) {
                context.noteOtherMetadata("Previous value", oldValue);
            }
            context.noteOtherMetadata("Value set", resolvedValue);
            return context.getPreviousStepOutput();
        }
        context.noteOtherMetadata("Value", resolvedValue);
        return resolvedValue;
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

